/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.DebuggingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AbsIntPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IDebugHelper;
import java.util.function.Supplier;

public class RcfgDebugHelper<STATE extends IAbstractState<STATE>, ACTION extends IAction, VARDECL, LOCATION>
implements IDebugHelper<STATE, ACTION, VARDECL, LOCATION> {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final DebuggingHoareTripleChecker mHTC;
    private final ManagedScript mMgdScript;
    private final IIcfgSymbolTable mSymbolTable;
    private static int sIllegalPredicates = Integer.MAX_VALUE;

    public RcfgDebugHelper(CfgSmtToolkit cfgSmtToolkit, IUltimateServiceProvider iUltimateServiceProvider, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mServices = iUltimateServiceProvider;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mHTC = new DebuggingHoareTripleChecker(this.mServices, this.mLogger, cfgSmtToolkit, IncrementalPlicationChecker.Validity.VALID);
    }

    @Override
    public boolean isPostSound(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, DisjunctiveAbstractState<STATE> disjunctiveAbstractState3, ACTION ACTION) {
        IPredicate iPredicate = this.createPredicateFromState(disjunctiveAbstractState);
        IPredicate iPredicate2 = this.createPredicateFromState(disjunctiveAbstractState3);
        IPredicate iPredicate3 = this.getHierachicalPre(ACTION, () -> this.createPredicateFromState(disjunctiveAbstractState2));
        return this.isPostSound(iPredicate3, ACTION, iPredicate, iPredicate2);
    }

    private IPredicate getHierachicalPre(ACTION ACTION, Supplier<IPredicate> supplier) {
        if (ACTION instanceof IIcfgReturnTransition) {
            return supplier.get();
        }
        return null;
    }

    private boolean isPostSound(IPredicate iPredicate, ACTION ACTION, IPredicate iPredicate2, IPredicate iPredicate3) {
        try {
            if (ACTION instanceof ICallAction) {
                this.mHTC.checkCall(iPredicate2, (ICallAction)ACTION, iPredicate3);
            } else if (ACTION instanceof IReturnAction) {
                this.mHTC.checkReturn(iPredicate2, iPredicate, (IReturnAction)ACTION, iPredicate3);
            } else {
                this.mHTC.checkInternal(iPredicate2, (IInternalAction)ACTION, iPredicate3);
            }
            boolean bl = this.mHTC.isLastOk();
            return bl;
        }
        finally {
            this.mHTC.releaseLock();
        }
    }

    private IPredicate createPredicateFromState(DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        Term term = disjunctiveAbstractState.getTerm(this.mMgdScript.getScript());
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term, (ManagedScript)this.mMgdScript, (IIcfgSymbolTable)this.mSymbolTable);
        return new AbsIntPredicate((IPredicate)new BasicPredicate(RcfgDebugHelper.getIllegalPredicateId(), term, termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula()), disjunctiveAbstractState);
    }

    private static int getIllegalPredicateId() {
        return sIllegalPredicates--;
    }
}

