/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CompoundDomain
implements IDomain {
    private final SymbolicTools mTools;
    private final Collection<IDomain> mSubdomains;

    public CompoundDomain(SymbolicTools symbolicTools, Collection<IDomain> collection) {
        this.mTools = symbolicTools;
        this.mSubdomains = collection;
    }

    @Override
    public IPredicate join(IPredicate iPredicate, IPredicate iPredicate2) {
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>(this.mSubdomains.size());
        for (IDomain iDomain : this.mSubdomains) {
            arrayList.add(iDomain.join(iPredicate, iPredicate2));
        }
        return this.mTools.and(arrayList);
    }

    @Override
    public IPredicate widen(IPredicate iPredicate, IPredicate iPredicate2) {
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>(this.mSubdomains.size());
        for (IDomain iDomain : this.mSubdomains) {
            arrayList.add(iDomain.widen(iPredicate, iPredicate2));
        }
        return this.mTools.and(arrayList);
    }

    @Override
    public IDomain.ResultForAlteredInputs isEqBottom(IPredicate iPredicate) {
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>(this.mSubdomains.size());
        for (IDomain iDomain : this.mSubdomains) {
            IDomain.ResultForAlteredInputs resultForAlteredInputs = iDomain.isEqBottom(iPredicate);
            if (resultForAlteredInputs.isTrueForAbstraction() || !resultForAlteredInputs.wasAbstracted()) {
                return resultForAlteredInputs;
            }
            arrayList.add(resultForAlteredInputs.getLhs());
        }
        return new IDomain.ResultForAlteredInputs(this.mTools.and(arrayList), this.mTools.bottom(), false, true);
    }

    @Override
    public IDomain.ResultForAlteredInputs isSubsetEq(IPredicate iPredicate, IPredicate iPredicate2) {
        ArrayList<IDomain.ResultForAlteredInputs> arrayList = new ArrayList<IDomain.ResultForAlteredInputs>(this.mSubdomains.size());
        ArrayList arrayList2 = new ArrayList(this.mSubdomains.size());
        for (IDomain iDomain : this.mSubdomains) {
            IDomain.ResultForAlteredInputs resultForAlteredInputs = iDomain.isSubsetEq(iPredicate, iPredicate2);
            if (!resultForAlteredInputs.wasAbstracted()) {
                return resultForAlteredInputs;
            }
            (resultForAlteredInputs.isTrueForAbstraction() ? arrayList : arrayList2).add(resultForAlteredInputs);
        }
        boolean bl = !arrayList.isEmpty();
        ArrayList<IDomain.ResultForAlteredInputs> arrayList3 = bl ? arrayList : arrayList2;
        return new IDomain.ResultForAlteredInputs(this.mTools.and(CompoundDomain.mapAndCollect(arrayList3, IDomain.ResultForAlteredInputs::getLhs)), this.mTools.and(CompoundDomain.mapAndCollect(arrayList3, IDomain.ResultForAlteredInputs::getRhs)), bl, true);
    }

    @Override
    public IPredicate alpha(IPredicate iPredicate) {
        return this.mTools.and(CompoundDomain.mapAndCollect(this.mSubdomains, iDomain -> iDomain.alpha(iPredicate)));
    }

    private static <I, O> Collection<O> mapAndCollect(Collection<I> collection, Function<I, O> function) {
        return collection.stream().map(function).collect(Collectors.toList());
    }
}

