/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.ltl2aut;

import de.uni_freiburg.informatik.ultimate.core.lib.results.CounterExampleResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.ltl2aut.Activator;
import de.uni_freiburg.informatik.ultimate.ltl2aut.LTL2autObserver;
import de.uni_freiburg.informatik.ultimate.ltl2aut.LTLFileParser;
import de.uni_freiburg.informatik.ultimate.ltl2aut.preferences.PreferenceInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LTL2aut
implements IGenerator,
ISource {
    protected List<String> mFileNames = new ArrayList<String>();
    private boolean mProcess;
    private boolean mSkip;
    private int mUseful;
    private LTL2autObserver mObserver;
    private IUltimateServiceProvider mServices;
    private final String[] mFileTypes = new String[]{"ltl"};
    private ILogger mLogger;

    public void init() {
        this.mProcess = false;
        this.mUseful = 0;
    }

    public String getPluginName() {
        return "LTL2Aut";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public ModelType getOutputDefinition() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Hardcoded");
        return new ModelType(Activator.PLUGIN_ID, ModelType.Type.AST, arrayList);
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        if (this.mSkip) {
            return ITool.ModelQuery.LAST;
        }
        return ITool.ModelQuery.ALL;
    }

    public List<String> getDesiredToolIds() {
        return null;
    }

    public void setInputDefinition(ModelType modelType) {
        switch (modelType.getCreator()) {
            case "de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator": 
            case "de.uni_freiburg.informatik.ultimate.boogie.parser": {
                this.mProcess = true;
                ++this.mUseful;
                break;
            }
            default: {
                this.mProcess = false;
            }
        }
    }

    public List<IObserver> getObservers() {
        this.mObserver = new LTL2autObserver(this.mServices);
        ArrayList<IObserver> arrayList = new ArrayList<IObserver>();
        if (this.mProcess && !this.mSkip) {
            arrayList.add((IObserver)this.mObserver);
        }
        return arrayList;
    }

    public IElement getModel() {
        return this.mObserver.getNWAContainer();
    }

    public IPreferenceInitializer getPreferences() {
        return new PreferenceInitializer();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        Collection collection = ResultUtil.filterResults((Map)iUltimateServiceProvider.getResultService().getResults(), CounterExampleResult.class);
        this.mSkip = !collection.isEmpty();
        this.mLogger = this.mServices.getLoggingService().getLogger("LTL2Aut");
    }

    public void finish() {
        if (!this.mSkip && this.mUseful == 0) {
            throw new IllegalStateException("Was used in a toolchain were it did nothing");
        }
        if (this.mSkip) {
            this.mServices.getLoggingService().getLogger(this.getPluginID()).info((Object)"Another plugin discovered errors, skipping...");
        }
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    private boolean parseable(File file) {
        String[] stringArray = this.getFileTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (file.getName().endsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IElement parseAST(File[] fileArray) throws Exception {
        if (fileArray.length == 1) {
            return this.parseAST(fileArray[0]);
        }
        throw new UnsupportedOperationException("Cannot parse more than one file");
    }

    private IElement parseAST(File file) throws Exception {
        ++this.mUseful;
        LTLFileParser lTLFileParser = new LTLFileParser(this.mLogger);
        return lTLFileParser.parse(file);
    }

    public String[] getFileTypes() {
        return this.mFileTypes;
    }
}

