/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LexicographicRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.TemplateComposition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ComposedLexicographicTemplate
extends ComposableTemplate {
    ComposableTemplate[] mParts;

    public ComposedLexicographicTemplate(ComposableTemplate[] composableTemplateArray) {
        assert (composableTemplateArray.length >= 1);
        this.mParts = composableTemplateArray;
    }

    @Override
    protected void init() {
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate composableTemplate = composableTemplateArray[n2];
            composableTemplate.init(this.mTAS);
            ++n2;
        }
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lex(");
        boolean bl = true;
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate composableTemplate = composableTemplateArray[n2];
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(composableTemplate.getName());
            bl = false;
            ++n2;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<List<List<LinearInequality>>> arrayList2 = new ArrayList<List<List<LinearInequality>>>();
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            object = composableTemplateArray[n2];
            arrayList2.add(((ComposableTemplate)object).getConstraintsDec(map, map2));
            ++n2;
        }
        arrayList.add(arrayList2);
        int n3 = 0;
        while (n3 < this.mParts.length - 1) {
            object = new ArrayList();
            object.add(this.mParts[n3].getConstraintsNonInc(map, map2));
            n2 = 0;
            while (n2 < n3) {
                object.add(this.mParts[n2].getConstraintsDec(map, map2));
                ++n2;
            }
            arrayList.add(object);
            ++n3;
        }
        List<List<LinearInequality>> list = TemplateComposition.distribute(arrayList);
        TemplateComposition.resetMotzkin(list);
        return list;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.mParts.length) {
            ArrayList<List<List<LinearInequality>>> arrayList2 = new ArrayList<List<List<LinearInequality>>>();
            arrayList2.add(this.mParts[n].getConstraintsNonInc(map, map2));
            int n2 = 0;
            while (n2 < n) {
                arrayList2.add(this.mParts[n2].getConstraintsDec(map, map2));
                ++n2;
            }
            arrayList.add(arrayList2);
            ++n;
        }
        List<List<LinearInequality>> list = TemplateComposition.distribute(arrayList);
        TemplateComposition.resetMotzkin(list);
        return list;
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Object object;
        ArrayList arrayList = new ArrayList();
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            object = composableTemplateArray[n2];
            arrayList.add(Collections.singletonList(((ComposableTemplate)object).getConstraintsBounded(map, map2)));
            ++n2;
        }
        object = TemplateComposition.distribute(arrayList);
        TemplateComposition.resetMotzkin(object);
        return object;
    }

    private List<String> blankAnnotations(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add("");
            ++n2;
        }
        return arrayList;
    }

    @Override
    public List<String> getAnnotationsDec() {
        Map<IProgramVar, TermVariable> map = Collections.emptyMap();
        return this.blankAnnotations(this.getConstraintsDec(map, map).size());
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        Map<IProgramVar, TermVariable> map = Collections.emptyMap();
        return this.blankAnnotations(this.getConstraintsNonInc(map, map).size());
    }

    @Override
    public List<String> getAnnotationsBounded() {
        Map<IProgramVar, TermVariable> map = Collections.emptyMap();
        return this.blankAnnotations(this.getConstraintsBounded(map, map).size());
    }

    public String toString() {
        return "";
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ComposableTemplate[] composableTemplateArray = this.mParts;
        int n = this.mParts.length;
        int n2 = 0;
        while (n2 < n) {
            ComposableTemplate composableTemplate = composableTemplateArray[n2];
            arrayList.addAll(composableTemplate.getCoefficients());
            ++n2;
        }
        return arrayList;
    }

    @Override
    public int getDegree() {
        Map<IProgramVar, TermVariable> map = Collections.emptyMap();
        return TemplateComposition.computeDegree(this.getConstraintsBounded(map, map)) + TemplateComposition.computeDegree(this.getConstraintsDec(map, map));
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        RankingFunction[] rankingFunctionArray = new RankingFunction[this.mParts.length];
        int n = 0;
        while (n < this.mParts.length) {
            rankingFunctionArray[n] = this.mParts[n].extractRankingFunction(map);
            ++n;
        }
        return new LexicographicRankingFunction(rankingFunctionArray);
    }
}

