/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcAuxData;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IEqualityReportingTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CongruenceClosure<ELEM extends ICongruenceClosureElement<ELEM>>
implements IEqualityReportingTarget<ELEM>,
IElementRemovalTarget<ELEM> {
    protected final ThreeValuedEquivalenceRelation<ELEM> mElementTVER;
    private final CcAuxData<ELEM> mAuxData;
    protected final FuncAppTreeAuxData mFaAuxData;
    protected final Set<ELEM> mAllLiterals;
    protected boolean mIsFrozen = false;
    boolean mConstructorInitializationPhase = false;
    protected IRemovalInfo<ELEM> mElementCurrentlyBeingRemoved;
    private IRemovalInfo<ELEM> mExternalRemovalInfo;
    private final CcManager<ELEM> mManager;
    CCLiteralSetConstraints<ELEM> mLiteralSetConstraints;

    CongruenceClosure(CcManager<ELEM> ccManager) {
        this.mElementTVER = new ThreeValuedEquivalenceRelation(CongruenceClosure::literalComparator);
        this.mAuxData = new CcAuxData(this);
        this.mFaAuxData = new FuncAppTreeAuxData();
        this.mAllLiterals = new HashSet<ELEM>();
        this.mManager = ccManager;
        this.mLiteralSetConstraints = new CCLiteralSetConstraints<ELEM>(ccManager, this);
    }

    CongruenceClosure(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"use other constructor");
        }
        this.mElementTVER = null;
        this.mAuxData = null;
        this.mFaAuxData = null;
        this.mAllLiterals = null;
        this.mManager = null;
        this.mLiteralSetConstraints = null;
    }

    CongruenceClosure(CcManager<ELEM> ccManager, ThreeValuedEquivalenceRelation<ELEM> threeValuedEquivalenceRelation) {
        this.mManager = ccManager;
        this.mElementTVER = threeValuedEquivalenceRelation;
        this.mAuxData = new CcAuxData(this);
        this.mFaAuxData = new FuncAppTreeAuxData();
        this.mAllLiterals = new HashSet<ELEM>();
        this.mLiteralSetConstraints = new CCLiteralSetConstraints<ELEM>(this.mManager, this);
        this.mConstructorInitializationPhase = true;
        for (ICongruenceClosureElement iCongruenceClosureElement : new HashSet<ELEM>(this.mElementTVER.getAllElements())) {
            this.registerNewElement(iCongruenceClosureElement, this);
        }
        this.mConstructorInitializationPhase = false;
        assert (this.sanityCheck());
    }

    CongruenceClosure(CcManager<ELEM> ccManager, ThreeValuedEquivalenceRelation<ELEM> threeValuedEquivalenceRelation, CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, IRemovalInfo<ELEM> iRemovalInfo) {
        assert (threeValuedEquivalenceRelation.getAllElements().containsAll(cCLiteralSetConstraints.getAllElementsMentionedInASetConstraint()));
        this.mElementTVER = threeValuedEquivalenceRelation;
        this.mAuxData = new CcAuxData(this);
        this.mFaAuxData = new FuncAppTreeAuxData();
        this.mAllLiterals = new HashSet<ELEM>();
        this.mManager = ccManager;
        this.mLiteralSetConstraints = Objects.requireNonNull(cCLiteralSetConstraints);
        this.mLiteralSetConstraints.setCongruenceClosure(this);
        this.mConstructorInitializationPhase = true;
        for (ICongruenceClosureElement iCongruenceClosureElement : new HashSet<ELEM>(this.mElementTVER.getAllElements())) {
            this.registerNewElement(iCongruenceClosureElement, this, iRemovalInfo);
        }
        this.mConstructorInitializationPhase = false;
        assert (this.sanityCheck(iRemovalInfo));
    }

    CongruenceClosure(CongruenceClosure<ELEM> congruenceClosure, IRemovalInfo<ELEM> iRemovalInfo) {
        if (congruenceClosure.isInconsistent()) {
            throw new IllegalArgumentException("use other constructor!");
        }
        this.mElementTVER = new ThreeValuedEquivalenceRelation<ELEM>(congruenceClosure.mElementTVER);
        this.mAuxData = new CcAuxData<ELEM>(this, congruenceClosure.getAuxData());
        this.mFaAuxData = new FuncAppTreeAuxData(congruenceClosure.mFaAuxData);
        this.mAllLiterals = new HashSet<ELEM>(congruenceClosure.mAllLiterals);
        this.mExternalRemovalInfo = iRemovalInfo;
        this.mManager = congruenceClosure.mManager;
        this.mLiteralSetConstraints = new CCLiteralSetConstraints<ELEM>(congruenceClosure.mManager, this, congruenceClosure.getLiteralSetConstraints());
        assert (this.sanityCheck(iRemovalInfo));
    }

    CongruenceClosure(CongruenceClosure<ELEM> congruenceClosure) {
        this(congruenceClosure, null);
    }

    static <ELEM extends ICongruenceClosureElement<ELEM>> Integer literalComparator(ELEM ELEM, ELEM ELEM2) {
        if (ELEM.isLiteral() && !ELEM2.isLiteral()) {
            return -1;
        }
        if (ELEM2.isLiteral() && !ELEM.isLiteral()) {
            return 1;
        }
        return 0;
    }

    public void freezeAndClose() {
        assert (!this.mIsFrozen);
        this.mIsFrozen = true;
    }

    public boolean isFrozen() {
        return this.mIsFrozen;
    }

    boolean reportEquality(ELEM ELEM, ELEM ELEM2) {
        boolean bl = this.reportEqualityRec(ELEM, ELEM2);
        return bl;
    }

    @Override
    public boolean reportEqualityRec(ELEM ELEM, ELEM ELEM2) {
        assert (!this.mIsFrozen);
        if (this.isInconsistent()) {
            throw new IllegalStateException();
        }
        boolean bl = false;
        bl |= this.mManager.addElementReportChange(this, ELEM, true);
        bl |= this.mManager.addElementReportChange(this, ELEM2, true);
        if (this.getEqualityStatus(ELEM, ELEM2) == EqualityStatus.EQUAL) {
            return bl;
        }
        if (this.getEqualityStatus(ELEM, ELEM2) == EqualityStatus.NOT_EQUAL) {
            this.mElementTVER.reportEquality(ELEM, ELEM2);
            if (!this.mElementTVER.isInconsistent()) {
                this.mElementTVER.reportDisequality(ELEM, ELEM2);
            }
            assert (this.mElementTVER.isInconsistent());
            return true;
        }
        Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> pair = this.doMergeAndComputePropagations(ELEM, ELEM2);
        if (pair == null) {
            return true;
        }
        CongruenceClosure.doFwccAndBwccPropagationsFromMerge(pair, this);
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void doFwccAndBwccPropagationsFromMerge(Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> pair, IEqualityReportingTarget<ELEM> iEqualityReportingTarget) {
        HashRelation<ELEM, ELEM> hashRelation = pair.getFirst();
        HashRelation<ELEM, ELEM> hashRelation2 = pair.getSecond();
        for (Map.Entry entry : hashRelation) {
            if (iEqualityReportingTarget.isInconsistent(false)) {
                return;
            }
            iEqualityReportingTarget.reportEqualityRec((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue());
        }
        for (Map.Entry entry : hashRelation2) {
            if (iEqualityReportingTarget.isInconsistent(false)) {
                return;
            }
            iEqualityReportingTarget.reportDisequalityRec((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue());
        }
    }

    public Pair<HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> doMergeAndComputePropagations(ELEM ELEM, ELEM ELEM2) {
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> hashRelation2;
        Object object;
        ICongruenceClosureElement iCongruenceClosureElement2 = (ICongruenceClosureElement)this.mElementTVER.getRepresentative(ELEM);
        ICongruenceClosureElement iCongruenceClosureElement3 = (ICongruenceClosureElement)this.mElementTVER.getRepresentative(ELEM2);
        CongruenceClosure.constantAndMixFunctionTreatmentOnAddEquality(iCongruenceClosureElement2, iCongruenceClosureElement3, this.mElementTVER.getEquivalenceClass(ELEM), this.mElementTVER.getEquivalenceClass(ELEM2), this.getAuxData(), iCongruenceClosureElement -> {
            CongruenceClosure<ICongruenceClosureElement> congruenceClosure = this.mManager.addElement(this, (ICongruenceClosureElement)iCongruenceClosureElement, true, true);
        }, this);
        Set<ICongruenceClosureElement> set = this.getRepresentativesUnequalTo(iCongruenceClosureElement2);
        Set<ICongruenceClosureElement> set2 = this.getRepresentativesUnequalTo(iCongruenceClosureElement3);
        this.mElementTVER.reportEquality(ELEM, ELEM2);
        if (this.mElementTVER.isInconsistent()) {
            return null;
        }
        if (iCongruenceClosureElement2.isLiteral() || iCongruenceClosureElement3.isLiteral()) {
            object = this.getRepresentativeElement(ELEM);
            assert (object.isLiteral()) : "if one element of an equivalence class is a literal, then it must be the representative";
            for (HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> hashRelation2 : this.mElementTVER.getRepresentativesUnequalTo(object)) {
                if (!hashRelation2.isLiteral()) continue;
                this.mElementTVER.removeDisequality(object, hashRelation2);
            }
        }
        object = new Pair(new HashRelation(), new HashRelation());
        hashRelation2 = this.mLiteralSetConstraints.reportEquality(iCongruenceClosureElement2, iCongruenceClosureElement3, (ICongruenceClosureElement)this.mElementTVER.getRepresentative(ELEM));
        if (hashRelation2 != null) {
            ((HashRelation)((Pair)object).getFirst()).addAll(hashRelation2);
        }
        if (this.mLiteralSetConstraints.isInconsistent()) {
            return null;
        }
        hashRelation2 = this.getAuxData().updateAndGetPropagationsOnMerge((ICongruenceClosureElement)ELEM, (ICongruenceClosureElement)ELEM2, iCongruenceClosureElement2, iCongruenceClosureElement3, set, set2);
        ((HashRelation)((Pair)object).getFirst()).addAll((AbstractRelation)((Pair)((Object)hashRelation2)).getFirst());
        ((HashRelation)((Pair)object).getSecond()).addAll((AbstractRelation)((Pair)((Object)hashRelation2)).getSecond());
        return object;
    }

    public Set<ELEM> getRepresentativesUnequalTo(ELEM ELEM) {
        assert (this.isRepresentative(ELEM));
        HashSet<ELEM> hashSet = new HashSet<ELEM>(this.mElementTVER.getRepresentativesUnequalTo(ELEM));
        if (ELEM.isLiteral()) {
            for (ICongruenceClosureElement iCongruenceClosureElement : this.mAllLiterals) {
                if (!iCongruenceClosureElement.hasSameTypeAs(ELEM) || iCongruenceClosureElement.equals(ELEM)) continue;
                hashSet.add(iCongruenceClosureElement);
            }
        }
        assert (hashSet.stream().allMatch(iCongruenceClosureElement2 -> iCongruenceClosureElement2.hasSameTypeAs(ELEM))) : "don't track disequalities between different sorts -- they are always implicit";
        return hashSet;
    }

    boolean reportDisequality(ELEM ELEM, ELEM ELEM2) {
        boolean bl = this.reportDisequalityRec(ELEM, ELEM2);
        return bl;
    }

    @Override
    public boolean reportDisequalityRec(ELEM ELEM, ELEM ELEM2) {
        assert (!this.mIsFrozen);
        assert (ELEM.hasSameTypeAs(ELEM2));
        if (this.isInconsistent()) {
            throw new IllegalStateException();
        }
        boolean bl = false;
        bl |= this.mManager.addElementReportChange(this, ELEM, true);
        bl |= this.mManager.addElementReportChange(this, ELEM2, true);
        if (this.getEqualityStatus(ELEM, ELEM2) == EqualityStatus.NOT_EQUAL) {
            return bl;
        }
        this.mElementTVER.reportDisequality(ELEM, ELEM2);
        if (this.mElementTVER.isInconsistent()) {
            return true;
        }
        if (!this.getRepresentativeElement(ELEM).isLiteral() || !this.getRepresentativeElement(ELEM2).isLiteral()) {
            this.mLiteralSetConstraints.reportDisequality(ELEM, ELEM2);
            if (this.mLiteralSetConstraints.isInconsistent()) {
                return true;
            }
        }
        HashRelation<ELEM, ELEM> hashRelation = this.getAuxData().getPropagationsOnReportDisequality(ELEM, ELEM2);
        for (Map.Entry entry : hashRelation) {
            this.reportDisequalityRec((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue());
        }
        return true;
    }

    @Override
    public boolean addElement(ELEM ELEM, boolean bl) {
        return this.addElement(ELEM, this, bl);
    }

    public boolean addElement(ELEM ELEM, IEqualityReportingTarget<ELEM> iEqualityReportingTarget, boolean bl) {
        boolean bl2 = this.addElementRec(ELEM, iEqualityReportingTarget, null);
        return bl2;
    }

    private boolean addElementRec(ELEM ELEM, IEqualityReportingTarget<ELEM> iEqualityReportingTarget, IRemovalInfo<ELEM> iRemovalInfo) {
        assert (!this.mIsFrozen);
        boolean bl = this.mElementTVER.addElement(ELEM);
        if (bl) {
            this.registerNewElement(ELEM, iEqualityReportingTarget, iRemovalInfo);
        }
        return bl;
    }

    private void registerNewElement(ELEM ELEM, IEqualityReportingTarget<ELEM> iEqualityReportingTarget) {
        this.registerNewElement(ELEM, iEqualityReportingTarget, null);
    }

    private void registerNewElement(ELEM ELEM, IEqualityReportingTarget<ELEM> iEqualityReportingTarget, IRemovalInfo<ELEM> iRemovalInfo) {
        Object object2;
        if (ELEM.isLiteral()) {
            this.mAllLiterals.add(ELEM);
        }
        if (ELEM.isDependentNonFunctionApplication()) {
            for (Object object2 : ELEM.getSupportingNodes()) {
                this.mManager.addElement(this, (ICongruenceClosureElement)object2, iEqualityReportingTarget, true, true);
                this.mFaAuxData.addSupportingNode(object2, ELEM);
            }
        }
        if (!ELEM.isFunctionApplication()) {
            assert (this.mElementTVER.getRepresentative(ELEM) != null) : "this method assumes that elem has been added already";
            return;
        }
        if (iRemovalInfo == null) {
            this.mFaAuxData.addAfParent(ELEM.getAppliedFunction(), ELEM);
            this.mFaAuxData.addArgParent(ELEM.getArgument(), ELEM);
        } else {
            if (!iRemovalInfo.getAlreadyRemovedElements().contains(ELEM.getAppliedFunction())) {
                this.mFaAuxData.addAfParent(ELEM.getAppliedFunction(), ELEM);
            }
            if (!iRemovalInfo.getAlreadyRemovedElements().contains(ELEM.getArgument())) {
                this.mFaAuxData.addArgParent(ELEM.getArgument(), ELEM);
            }
        }
        object2 = this.getAuxData().registerNewElement(ELEM);
        if (iRemovalInfo == null) {
            this.mManager.addElement(this, (ICongruenceClosureElement)ELEM.getAppliedFunction(), iEqualityReportingTarget, true, true);
            this.mManager.addElement(this, (ICongruenceClosureElement)ELEM.getArgument(), iEqualityReportingTarget, true, true);
        } else {
            if (!iRemovalInfo.getAlreadyRemovedElements().contains(ELEM.getAppliedFunction())) {
                this.mManager.addElement(this, (ICongruenceClosureElement)ELEM.getAppliedFunction(), iEqualityReportingTarget, true, true);
            }
            if (!iRemovalInfo.getAlreadyRemovedElements().contains(ELEM.getArgument())) {
                this.mManager.addElement(this, (ICongruenceClosureElement)ELEM.getArgument(), iEqualityReportingTarget, true, true);
            }
        }
        CongruenceClosure.constantFunctionTreatmentOnAddElement(ELEM, this.mElementTVER.getEquivalenceClass(ELEM.getAppliedFunction()), iEqualityReportingTarget);
        CongruenceClosure.mixFunctionTreatmentOnAddElement(ELEM, (iCongruenceClosureElement, set) -> iEqualityReportingTarget.reportContainsConstraint((ICongruenceClosureElement)iCongruenceClosureElement, (Set<ICongruenceClosureElement>)set), iCongruenceClosureElement -> {
            CongruenceClosure<ICongruenceClosureElement> congruenceClosure = this.mManager.addElement(this, (ICongruenceClosureElement)iCongruenceClosureElement, iEqualityReportingTarget, true, true);
        }, this.mElementTVER.getEquivalenceClass(ELEM.getAppliedFunction()));
        if (iRemovalInfo == null) {
            for (Map.Entry entry : ((AbstractRelation)object2).getSetOfPairs()) {
                iEqualityReportingTarget.reportEqualityRec((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue());
                if (this.isInconsistent()) break;
            }
        }
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void constantFunctionTreatmentOnAddElement(ELEM iCongruenceClosureElement, Set<ELEM> set, IEqualityReportingTarget<ELEM> iEqualityReportingTarget) {
        if (iCongruenceClosureElement.getAppliedFunction().isConstantFunction() && !iEqualityReportingTarget.isInconsistent(false)) {
            iEqualityReportingTarget.reportEqualityRec(iCongruenceClosureElement, (ICongruenceClosureElement)iCongruenceClosureElement.getAppliedFunction().getConstantFunctionValue());
        }
        for (ICongruenceClosureElement iCongruenceClosureElement2 : set) {
            if (iEqualityReportingTarget.isInconsistent(false)) {
                return;
            }
            if (iCongruenceClosureElement2 == iCongruenceClosureElement.getAppliedFunction() || !iCongruenceClosureElement2.isConstantFunction()) continue;
            iEqualityReportingTarget.addElement(iCongruenceClosureElement.replaceAppliedFunction((ICongruenceClosureElement)iCongruenceClosureElement2), false);
        }
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void mixFunctionTreatmentOnAddElement(ELEM object, BiConsumer<ELEM, Set<ELEM>> biConsumer, Consumer<ELEM> consumer, Set<ELEM> set) {
        if (object.getAppliedFunction().isMixFunction()) {
            Object object2 = object.getAppliedFunction().getMixFunction1();
            Iterator<ELEM> iterator = object.getAppliedFunction().getMixFunction2();
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(object.replaceAppliedFunction(object2));
            hashSet.add(object.replaceAppliedFunction(iterator));
            biConsumer.accept(object, hashSet);
        }
        for (Object object2 : set) {
            if (object2 == object.getAppliedFunction() || !object2.isMixFunction()) continue;
            consumer.accept(object.replaceAppliedFunction((Object)object2));
        }
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> void constantAndMixFunctionTreatmentOnAddEquality(ELEM ELEM, ELEM ELEM2, Set<ELEM> set, Set<ELEM> set2, CcAuxData<ELEM> ccAuxData, Consumer<ELEM> consumer, IEqualityReportingTarget<ELEM> iEqualityReportingTarget) {
        for (ICongruenceClosureElement iCongruenceClosureElement : new HashSet<ELEM>(set)) {
            if (!iCongruenceClosureElement.isMixFunction() && !iCongruenceClosureElement.isConstantFunction()) continue;
            for (ICongruenceClosureElement iCongruenceClosureElement2 : ccAuxData.getAfCcPars(ELEM2)) {
                if (iEqualityReportingTarget.isInconsistent(false)) {
                    return;
                }
                assert (!iCongruenceClosureElement.equals(iCongruenceClosureElement2.getAppliedFunction()));
                consumer.accept(iCongruenceClosureElement2.replaceAppliedFunction(iCongruenceClosureElement));
            }
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : new HashSet<ELEM>(set2)) {
            if (!iCongruenceClosureElement.isMixFunction() && !iCongruenceClosureElement.isConstantFunction()) continue;
            for (ICongruenceClosureElement iCongruenceClosureElement2 : ccAuxData.getAfCcPars(ELEM)) {
                if (iEqualityReportingTarget.isInconsistent(false)) {
                    return;
                }
                assert (!iCongruenceClosureElement.equals(iCongruenceClosureElement2.getAppliedFunction()));
                consumer.accept(iCongruenceClosureElement2.replaceAppliedFunction(iCongruenceClosureElement));
            }
        }
    }

    public ELEM getRepresentativeElement(ELEM ELEM) {
        ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)this.mElementTVER.getRepresentative(ELEM);
        if (iCongruenceClosureElement == null) {
            throw new IllegalArgumentException("Use this method only for elements that you know have been added already");
        }
        return (ELEM)iCongruenceClosureElement;
    }

    public Set<ELEM> collectElementsToRemove(ELEM ELEM) {
        HashSet hashSet = new HashSet(this.mFaAuxData.getDependentsOf(ELEM));
        for (ICongruenceClosureElement iCongruenceClosureElement : this.mFaAuxData.getDependentsOf(ELEM)) {
            hashSet.addAll(this.collectTransitiveParents(iCongruenceClosureElement));
        }
        hashSet.addAll(this.collectTransitiveParents(ELEM));
        return hashSet;
    }

    private Set<ELEM> collectTransitiveParents(ELEM ELEM) {
        HashSet<ICongruenceClosureElement> hashSet = new HashSet<ICongruenceClosureElement>();
        ArrayDeque arrayDeque = new ArrayDeque();
        arrayDeque.add(ELEM);
        while (!arrayDeque.isEmpty()) {
            ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)arrayDeque.pop();
            hashSet.add(iCongruenceClosureElement);
            arrayDeque.addAll(this.mFaAuxData.getAfParents(iCongruenceClosureElement));
            arrayDeque.addAll(this.mFaAuxData.getArgParents(iCongruenceClosureElement));
        }
        return hashSet;
    }

    public void removeElements(Set<ELEM> set, Map<ELEM, ELEM> map) {
        assert (!this.mIsFrozen);
        for (ICongruenceClosureElement iCongruenceClosureElement : set) {
            this.mFaAuxData.removeFromNodeToDependents(iCongruenceClosureElement);
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : set) {
            if (!this.hasElement(iCongruenceClosureElement)) continue;
            this.updateElementTverAndAuxDataOnRemoveElement(iCongruenceClosureElement, (ICongruenceClosureElement)map.get(iCongruenceClosureElement));
        }
    }

    @Override
    public Set<ELEM> getNodesToIntroduceBeforeRemoval(ELEM ELEM, Set<ELEM> set, Map<ELEM, ELEM> map) {
        assert (set.contains(ELEM));
        assert (ELEM.isFunctionApplication());
        boolean bl = set.contains(ELEM.getAppliedFunction());
        boolean bl2 = set.contains(ELEM.getArgument());
        if (bl && bl2) {
            Object ELEM2 = this.getOtherEquivalenceClassMember(ELEM.getAppliedFunction(), set);
            Object ELEM3 = this.getOtherEquivalenceClassMember(ELEM.getArgument(), set);
            if (ELEM2 != null && ELEM3 != null) {
                Object ELEM4 = ELEM.replaceAppliedFunction(ELEM2);
                Object ELEM5 = ELEM4.replaceArgument(ELEM3);
                assert (!this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(ELEM5));
                map.put(ELEM, ELEM5);
                if (!this.hasElement(ELEM5)) {
                    assert (this.nodeToAddIsEquivalentToOriginal(ELEM5, ELEM));
                    return Collections.singleton(ELEM5);
                }
                return Collections.emptySet();
            }
        } else if (bl) {
            Object ELEM6 = this.getOtherEquivalenceClassMember(ELEM.getAppliedFunction(), set);
            if (ELEM6 != null) {
                Object ELEM7 = ELEM.replaceAppliedFunction(ELEM6);
                assert (!this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(ELEM7));
                map.put(ELEM, ELEM7);
                if (!this.hasElement(ELEM7)) {
                    assert (this.nodeToAddIsEquivalentToOriginal(ELEM7, ELEM));
                    return Collections.singleton(ELEM7);
                }
                return Collections.emptySet();
            }
        } else {
            Object ELEM8 = this.getOtherEquivalenceClassMember(ELEM.getArgument(), set);
            if (ELEM8 != null) {
                Object ELEM9 = ELEM.replaceArgument(ELEM8);
                assert (!this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(ELEM9));
                map.put(ELEM, ELEM9);
                if (!this.hasElement(ELEM9)) {
                    assert (this.nodeToAddIsEquivalentToOriginal(ELEM9, ELEM));
                    return Collections.singleton(ELEM9);
                }
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    private boolean nodeToAddIsEquivalentToOriginal(ELEM ELEM, ELEM ELEM2) {
        CongruenceClosure<ELEM> congruenceClosure = this.mManager.copyNoRemInfoUnfrozen(this);
        this.mManager.addElement(congruenceClosure, ELEM, true, false);
        if (congruenceClosure.getEqualityStatus(ELEM, ELEM2) != EqualityStatus.EQUAL) {
            assert (false);
            return false;
        }
        return true;
    }

    public ELEM getOtherEquivalenceClassMember(ELEM ELEM, Set<ELEM> set) {
        assert (this.hasElement(ELEM));
        Set<ELEM> set2 = this.mElementTVER.getEquivalenceClass(ELEM);
        if (set2.size() == 1) {
            return null;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : set2) {
            if (iCongruenceClosureElement.equals(ELEM) || set != null && set.contains(iCongruenceClosureElement)) continue;
            return (ELEM)iCongruenceClosureElement;
        }
        return null;
    }

    private ELEM updateElementTverAndAuxDataOnRemoveElement(ELEM ELEM, ELEM ELEM2) {
        boolean bl = this.mElementTVER.isRepresentative(ELEM);
        ICongruenceClosureElement iCongruenceClosureElement = (ICongruenceClosureElement)this.mElementTVER.removeElement(ELEM, ELEM2);
        assert (this.mElementTVER.getRepresentative(iCongruenceClosureElement) == iCongruenceClosureElement);
        assert (!bl || ELEM2 == null || iCongruenceClosureElement == ELEM2);
        this.getAuxData().removeElement((ICongruenceClosureElement)ELEM, bl, iCongruenceClosureElement);
        if (ELEM.isFunctionApplication()) {
            this.mFaAuxData.removeAfParent(ELEM.getAppliedFunction(), ELEM);
            this.mFaAuxData.removeArgParent(ELEM.getArgument(), ELEM);
        }
        if (bl) {
            if (iCongruenceClosureElement == null) {
                this.mLiteralSetConstraints.projectAway(ELEM);
            } else {
                this.mLiteralSetConstraints.replaceRepresentative((ICongruenceClosureElement)ELEM, iCongruenceClosureElement);
            }
        }
        return (ELEM)iCongruenceClosureElement;
    }

    CongruenceClosure<ELEM> merge(CongruenceClosure<ELEM> congruenceClosure, BinaryOperator<Set<SetConstraint<ELEM>>> binaryOperator) {
        assert (!(this.isInconsistent() || congruenceClosure.isInconsistent() || this.isTautological() || congruenceClosure.isTautological()));
        Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> pair = this.mManager.alignElements(this, congruenceClosure, !this.isFrozen() && !congruenceClosure.isFrozen());
        CongruenceClosure<ELEM> congruenceClosure2 = pair.getFirst();
        CongruenceClosure<ELEM> congruenceClosure3 = pair.getSecond();
        Triple<UnionFind<ELEM>, HashRelation<ELEM, ELEM>, HashRelation<ELEM, ELEM>> triple = congruenceClosure2.mElementTVER.joinPartitions(congruenceClosure3.mElementTVER);
        UnionFind<ELEM> unionFind = triple.getFirst();
        HashRelation<ELEM, ELEM> hashRelation = triple.getSecond();
        HashRelation<ELEM, ELEM> hashRelation2 = triple.getThird();
        HashRelation<ELEM, ELEM> hashRelation3 = CongruenceClosure.intersectOrUnionDisequalities(congruenceClosure2, congruenceClosure3, unionFind, true);
        ThreeValuedEquivalenceRelation<ELEM> threeValuedEquivalenceRelation = new ThreeValuedEquivalenceRelation<ELEM>(unionFind, hashRelation3);
        assert (CcManager.isPartitionStronger(congruenceClosure2.mElementTVER, threeValuedEquivalenceRelation));
        assert (CcManager.isPartitionStronger(congruenceClosure3.mElementTVER, threeValuedEquivalenceRelation));
        CongruenceClosure<ELEM> congruenceClosure4 = this.mManager.getCongruenceClosureFromTver(threeValuedEquivalenceRelation, true);
        assert (CcManager.isPartitionStronger(congruenceClosure2.mElementTVER, congruenceClosure4.mElementTVER));
        assert (CcManager.isPartitionStronger(congruenceClosure3.mElementTVER, congruenceClosure4.mElementTVER));
        CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints = this.mLiteralSetConstraints.merge(congruenceClosure4, hashRelation, hashRelation2, congruenceClosure.mLiteralSetConstraints, binaryOperator);
        congruenceClosure4.resetCcLiteralSetConstraints(cCLiteralSetConstraints);
        return congruenceClosure4;
    }

    private void resetCcLiteralSetConstraints(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints) {
        assert (cCLiteralSetConstraints.getCongruenceClosure() == this);
        this.mLiteralSetConstraints = cCLiteralSetConstraints;
    }

    private static <E extends ICongruenceClosureElement<E>> HashRelation<E, E> intersectOrUnionDisequalities(CongruenceClosure<E> congruenceClosure, CongruenceClosure<E> congruenceClosure2, UnionFind<E> unionFind, boolean bl) {
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> hashRelation = new HashRelation<ICongruenceClosureElement, ICongruenceClosureElement>();
        BiPredicate<ICongruenceClosureElement, ICongruenceClosureElement> biPredicate = (iCongruenceClosureElement, iCongruenceClosureElement2) -> iCongruenceClosureElement != iCongruenceClosureElement2 && (!iCongruenceClosureElement.isLiteral() || !iCongruenceClosureElement2.isLiteral()) && iCongruenceClosureElement.hasSameTypeAs(iCongruenceClosureElement2);
        for (Map.Entry entry : CrossProducts.binarySelectiveCrossProduct(unionFind.getAllRepresentatives(), false, biPredicate)) {
            boolean bl2;
            assert (!((ICongruenceClosureElement)entry.getKey()).isLiteral() || !((ICongruenceClosureElement)entry.getValue()).isLiteral()) : "disequalities between literals are implicit, the selective cross product should have filtered these cases";
            if (bl) {
                bl2 = congruenceClosure.getEqualityStatus((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue()) == EqualityStatus.NOT_EQUAL && congruenceClosure2.getEqualityStatus((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue()) == EqualityStatus.NOT_EQUAL;
            } else {
                boolean bl3 = bl2 = congruenceClosure.getEqualityStatus((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue()) == EqualityStatus.NOT_EQUAL || congruenceClosure2.getEqualityStatus((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue()) == EqualityStatus.NOT_EQUAL;
            }
            if (!bl2) continue;
            hashRelation.addPair((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue());
        }
        return hashRelation;
    }

    public CongruenceClosure<ELEM> meetRec(CongruenceClosure<ELEM> congruenceClosure, IRemovalInfo<ELEM> iRemovalInfo, boolean bl) {
        assert (!this.isInconsistent());
        assert (!congruenceClosure.isInconsistent() || bl);
        CongruenceClosure<Object> congruenceClosure2 = this.mManager.addAllElements(this, congruenceClosure.getAllElements(), iRemovalInfo, bl);
        for (Map.Entry<ELEM, ELEM> entry : congruenceClosure.getSupportingElementEqualities().entrySet()) {
            if (congruenceClosure2.isInconsistent()) {
                if (bl) {
                    return congruenceClosure2;
                }
                return this.mManager.getInconsistentCc();
            }
            congruenceClosure2 = this.mManager.reportEquality((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), congruenceClosure2, bl);
        }
        for (Map.Entry<Object, Object> entry : congruenceClosure.getElementDisequalities()) {
            if (congruenceClosure2.isInconsistent()) {
                if (bl) {
                    return congruenceClosure2;
                }
                return this.mManager.getInconsistentCc();
            }
            congruenceClosure2 = this.mManager.reportDisequality((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), congruenceClosure2, bl);
        }
        for (Map.Entry<Object, Object> entry : congruenceClosure.getLiteralSetConstraints().getConstraints().entrySet()) {
            if (congruenceClosure2.isInconsistent()) {
                if (bl) {
                    return congruenceClosure2;
                }
                return this.mManager.getInconsistentCc();
            }
            congruenceClosure2 = this.mManager.reportContainsConstraint((Object)((ICongruenceClosureElement)entry.getKey()), ((SetConstraintConjunction)entry.getValue()).getSetConstraints(), congruenceClosure2, bl);
        }
        return congruenceClosure2;
    }

    public CongruenceClosure<ELEM> meetRec(CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        return this.meetRec(congruenceClosure, null, bl);
    }

    public boolean isStrongerThanNoCaching(CongruenceClosure<ELEM> congruenceClosure) {
        if (this.isInconsistent()) {
            return true;
        }
        return this.mManager.isStrongerThanNoCaching(this, congruenceClosure);
    }

    public EqualityStatus getEqualityStatus(ELEM ELEM, ELEM ELEM2) {
        ELEM ELEM3;
        assert (this.hasElement(ELEM) && this.hasElement(ELEM2));
        assert (!this.isInconsistent()) : "catch this outside!";
        this.mManager.bmStart(CcManager.CcBmNames.GET_EQUALITY_STATUS);
        if (!ELEM.hasSameTypeAs(ELEM2)) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.NOT_EQUAL;
        }
        ELEM ELEM4 = this.getRepresentativeElement(ELEM);
        if (ELEM4.equals(ELEM3 = this.getRepresentativeElement(ELEM2))) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.EQUAL;
        }
        if (ELEM4.isLiteral() && ELEM3.isLiteral()) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.NOT_EQUAL;
        }
        Set<SetConstraint<ELEM>> set = this.mLiteralSetConstraints.getConstraint(ELEM4);
        Set<SetConstraint<ELEM>> set2 = this.mLiteralSetConstraints.getConstraint(ELEM3);
        if (this.mManager.getSetConstraintManager().meetIsInconsistent(this.getLiteralSetConstraints(), set, set2)) {
            this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
            return EqualityStatus.NOT_EQUAL;
        }
        EqualityStatus equalityStatus = this.mElementTVER.getEqualityStatus(ELEM, ELEM2);
        this.mManager.bmEnd(CcManager.CcBmNames.GET_EQUALITY_STATUS);
        return equalityStatus;
    }

    public Set<ELEM> getAllElements() {
        return Collections.unmodifiableSet(this.mElementTVER.getAllElements());
    }

    public CCLiteralSetConstraints<ELEM> getLiteralSetConstraints() {
        return this.mLiteralSetConstraints;
    }

    @Override
    public boolean isInconsistent() {
        return this.mElementTVER == null || this.mElementTVER.isInconsistent() || this.mLiteralSetConstraints.isInconsistent();
    }

    @Override
    public boolean isInconsistent(boolean bl) {
        return this.isInconsistent();
    }

    private boolean assertNoElementsFromRemInfoInLitSetConstraints(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, IRemovalInfo<ELEM> iRemovalInfo) {
        if (iRemovalInfo == null) {
            return true;
        }
        for (Map.Entry<ELEM, SetConstraintConjunction<ELEM>> entry : cCLiteralSetConstraints.getConstraints().entrySet()) {
            if (CongruenceClosure.dependsOnAny((ICongruenceClosureElement)entry.getKey(), iRemovalInfo.getRemovedElements())) {
                return false;
            }
            if (CongruenceClosure.dependsOnAny(entry.getValue().getConstrainedElement(), iRemovalInfo.getRemovedElements())) {
                return false;
            }
            for (ICongruenceClosureElement iCongruenceClosureElement : entry.getValue().getAllRhsElements()) {
                if (!CongruenceClosure.dependsOnAny(iCongruenceClosureElement, iRemovalInfo.getRemovedElements())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean assertNoElementsFromRemInfoInTver(ThreeValuedEquivalenceRelation<ELEM> threeValuedEquivalenceRelation, IRemovalInfo<ELEM> iRemovalInfo) {
        if (iRemovalInfo == null) {
            return true;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : threeValuedEquivalenceRelation.getAllElements()) {
            if (!CongruenceClosure.dependsOnAny(iCongruenceClosureElement, iRemovalInfo.getRemovedElements())) continue;
            return false;
        }
        return true;
    }

    private boolean assertElementsAreSuperset(Set<ELEM> set, Set<ELEM> set2) {
        Set<ELEM> set3 = DataStructureUtils.difference(set2, set);
        if (!set3.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    boolean assertElementsAreSuperset(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        Set<ELEM> set = DataStructureUtils.difference(congruenceClosure2.getAllElements(), congruenceClosure.getAllElements());
        if (!set.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertAtMostOneLiteralPerEquivalenceClass() {
        if (this.isInconsistent()) {
            return true;
        }
        for (Set<ELEM> set : this.mElementTVER.getAllEquivalenceClasses()) {
            assert (set.stream().filter(iCongruenceClosureElement -> iCongruenceClosureElement.isLiteral()).collect(Collectors.toList()).size() < 2);
        }
        return true;
    }

    public boolean assertSimpleElementIsFullyRemoved(ELEM ELEM) {
        Set<ELEM> set = this.collectElementsToRemove(ELEM);
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!set.contains(iCongruenceClosureElement)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertSingleElementIsFullyRemoved(ELEM ELEM) {
        for (Map.Entry entry : this.mFaAuxData.getNodeToDependentPairs()) {
            if (!((ICongruenceClosureElement)entry.getKey()).equals(ELEM) && !((ICongruenceClosureElement)entry.getValue()).equals(ELEM)) continue;
            assert (false);
            return false;
        }
        return this.assertElementIsFullyRemovedOnlyCc(ELEM);
    }

    protected boolean assertElementIsFullyRemovedOnlyCc(ELEM ELEM) {
        if (this.mElementTVER.getRepresentative(ELEM) != null) {
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertHasOnlyWeqVarConstraints(Set<ELEM> set) {
        if (this.isTautological()) {
            return true;
        }
        if (set.isEmpty()) {
            return true;
        }
        HashSet<ICongruenceClosureElement> hashSet = new HashSet<ICongruenceClosureElement>();
        for (Map.Entry object : this.mElementTVER.getDisequalities().getSetOfPairs()) {
            hashSet.add((ICongruenceClosureElement)object.getKey());
            hashSet.add((ICongruenceClosureElement)object.getValue());
        }
        for (Set set2 : this.mElementTVER.getAllEquivalenceClasses()) {
            if (set2.size() == 1) continue;
            Set set3 = set2.stream().filter(iCongruenceClosureElement -> CongruenceClosure.dependsOnAny(iCongruenceClosureElement, set)).collect(Collectors.toSet());
            Set set4 = DataStructureUtils.intersection(set2, hashSet);
            if (!set3.isEmpty() || !set4.isEmpty()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertHasExternalRemInfo() {
        return this.mExternalRemovalInfo != null;
    }

    @Override
    public boolean sanityCheck() {
        return this.sanityCheck(null);
    }

    public boolean sanityCheck(IRemovalInfo<ELEM> iRemovalInfo) {
        return this.sanityCheckOnlyCc(iRemovalInfo);
    }

    public boolean sanityCheckOnlyCc() {
        return this.sanityCheckOnlyCc(null);
    }

    public boolean sanityCheckOnlyCc(IRemovalInfo<ELEM> iRemovalInfo) {
        if (this.mConstructorInitializationPhase) {
            return true;
        }
        if (this.isInconsistent()) {
            if (this.mElementTVER != null && !this.mElementTVER.isInconsistent() && !this.mLiteralSetConstraints.isInconsistent()) {
                assert (false) : "cc reports as inconsistent, but why?..";
                return false;
            }
            return true;
        }
        if (!this.mElementTVER.sanityCheck()) {
            assert (false);
            return false;
        }
        if (this.mElementTVER.isInconsistent()) {
            assert (false) : "Cc is inconsistent but fields are not null";
            return false;
        }
        for (ICongruenceClosureElement object : this.getAllRepresentatives()) {
            for (ICongruenceClosureElement iCongruenceClosureElement : this.getAuxData().getAfCcPars(object)) {
                if (iCongruenceClosureElement.isFunctionApplication()) continue;
                assert (false) : "ccpar is not a funcapp";
                return false;
            }
            for (ICongruenceClosureElement iCongruenceClosureElement : this.getAuxData().getArgCcPars(object)) {
                if (iCongruenceClosureElement.isFunctionApplication()) continue;
                assert (false) : "ccpar is not a funcapp";
                return false;
            }
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!iCongruenceClosureElement.isFunctionApplication()) continue;
            if (!(this.hasElement(iCongruenceClosureElement.getAppliedFunction()) || iRemovalInfo != null && iRemovalInfo.getRemovedElements().contains(iCongruenceClosureElement.getAppliedFunction()) || this.mElementCurrentlyBeingRemoved != null && this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(iCongruenceClosureElement.getAppliedFunction()) || this.mExternalRemovalInfo != null && this.mExternalRemovalInfo.getRemovedElements().contains(iCongruenceClosureElement.getAppliedFunction()))) {
                assert (false);
                return false;
            }
            if (this.hasElement(iCongruenceClosureElement.getArgument()) || iRemovalInfo != null && iRemovalInfo.getRemovedElements().contains(iCongruenceClosureElement.getArgument()) || this.mElementCurrentlyBeingRemoved != null && this.mElementCurrentlyBeingRemoved.getRemovedElements().contains(iCongruenceClosureElement.getArgument()) || this.mExternalRemovalInfo != null && this.mExternalRemovalInfo.getRemovedElements().contains(iCongruenceClosureElement.getArgument())) continue;
            assert (false);
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!iCongruenceClosureElement.isFunctionApplication()) continue;
            ICongruenceClosureElement iCongruenceClosureElement2 = this.getRepresentativeElement(iCongruenceClosureElement);
            if (this.getAuxData().getCcChildren(iCongruenceClosureElement2).containsPair((ICongruenceClosureElement)iCongruenceClosureElement.getAppliedFunction(), (ICongruenceClosureElement)iCongruenceClosureElement.getArgument())) continue;
            assert (false) : "ccchild store incomplete";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            if (!iCongruenceClosureElement.isLiteral() || this.mAllLiterals.contains(iCongruenceClosureElement)) continue;
            assert (false) : "all literals store incomplete";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.mAllLiterals) {
            if (iCongruenceClosureElement.isLiteral()) continue;
            assert (false) : "non-literal in all literals store";
            return false;
        }
        for (Set set : this.mElementTVER.getAllEquivalenceClasses()) {
            for (ICongruenceClosureElement<Object> iCongruenceClosureElement : set) {
                if (!iCongruenceClosureElement.isLiteral() || this.isRepresentative(iCongruenceClosureElement)) continue;
                assert (false) : "literal is not the representative of its eq class";
                return false;
            }
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            ICongruenceClosureElement iCongruenceClosureElement32;
            HashSet hashSet = new HashSet();
            Iterator<ICongruenceClosureElement> iterator = new HashSet();
            for (ICongruenceClosureElement iCongruenceClosureElement32 : this.mElementTVER.getEquivalenceClass(iCongruenceClosureElement)) {
                hashSet.addAll(this.mFaAuxData.getAfParents(iCongruenceClosureElement32));
                iterator.addAll(this.mFaAuxData.getArgParents(iCongruenceClosureElement32));
            }
            iCongruenceClosureElement32 = this.getRepresentativeElement(iCongruenceClosureElement);
            if (!hashSet.equals(this.getAuxData().getAfCcPars(iCongruenceClosureElement32))) {
                DataStructureUtils.difference(hashSet, new HashSet<ICongruenceClosureElement>(this.getAuxData().getAfCcPars(iCongruenceClosureElement32)));
                DataStructureUtils.difference(new HashSet<ICongruenceClosureElement>(this.getAuxData().getAfCcPars(iCongruenceClosureElement32)), hashSet);
                assert (false) : "funcAppTreeAuxData and ccAuxData don't agree (Af case)";
                return false;
            }
            if (iterator.equals(this.getAuxData().getArgCcPars(iCongruenceClosureElement32))) continue;
            DataStructureUtils.difference(iterator, new HashSet<ICongruenceClosureElement>(this.getAuxData().getArgCcPars(iCongruenceClosureElement32)));
            DataStructureUtils.difference(new HashSet<ICongruenceClosureElement>(this.getAuxData().getArgCcPars(iCongruenceClosureElement32)), iterator);
            assert (false) : "funcAppTreeAuxData and ccAuxData don't agree (Arg case)";
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.getAllElements()) {
            for (ICongruenceClosureElement iCongruenceClosureElement4 : this.mElementTVER.getEquivalenceClass(iCongruenceClosureElement)) {
                if (iCongruenceClosureElement.hasSameTypeAs(iCongruenceClosureElement4)) continue;
                assert (false) : "elements of incompatible type are in same eq class";
                return false;
            }
        }
        for (Map.Entry entry : this.mElementTVER.getDisequalities()) {
            if (((ICongruenceClosureElement)entry.getKey()).hasSameTypeAs((ICongruenceClosureElement)entry.getValue())) continue;
            assert (false) : "stored disequality between elements of incompatible type";
            return false;
        }
        if (!this.assertNoExplicitLiteralDisequalities()) {
            assert (false);
            return false;
        }
        if (!this.mLiteralSetConstraints.sanityCheck()) {
            assert (false);
            return false;
        }
        return true;
    }

    private boolean assertNoExplicitLiteralDisequalities() {
        for (Map.Entry entry : this.mElementTVER.getDisequalities()) {
            if (!((ICongruenceClosureElement)entry.getKey()).isLiteral() || !((ICongruenceClosureElement)entry.getValue()).isLiteral()) continue;
            assert (false) : "explicit disequality between literals";
            return false;
        }
        return true;
    }

    public Map<ELEM, ELEM> getSupportingElementEqualities() {
        return this.mElementTVER.getSupportingEqualities();
    }

    public HashRelation<ELEM, ELEM> getElementDisequalities() {
        return this.mElementTVER.getDisequalities();
    }

    Map<String, Integer> summarize() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("#Elements", this.getAllElements().size());
        hashMap.put("#EquivalenceClasses", this.getAllRepresentatives().size());
        hashMap.put("#SupportingEqualties", this.getSupportingElementEqualities().size());
        hashMap.put("#SupportingDisequalties", this.getElementDisequalities().size());
        return hashMap;
    }

    public String toString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent()) {
            return "False";
        }
        if (this.getAllElements().size() < 30) {
            return this.toLogString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : this.summarize().entrySet()) {
            stringBuilder.append(String.format("%s : %d\n", entry.getKey(), entry.getValue()));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toLogString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent()) {
            return "False";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--CC(begin):--\n");
        stringBuilder.append("Equivalences:\n");
        for (Set<ELEM> object : this.mElementTVER.getAllEquivalenceClasses()) {
            stringBuilder.append(object);
            if (object.size() > 1) {
                stringBuilder.append(" --- rep: ");
                stringBuilder.append(this.mElementTVER.getRepresentative((ICongruenceClosureElement)object.iterator().next()));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("Disequalities:\n");
        for (Map.Entry entry : this.mElementTVER.getDisequalities()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" != ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\n");
        }
        stringBuilder.append(this.mLiteralSetConstraints.toString());
        stringBuilder.append("--CC(end):--\n");
        return stringBuilder.toString();
    }

    static <E> boolean haveSameElements(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation2) {
        return threeValuedEquivalenceRelation.getAllElements().equals(threeValuedEquivalenceRelation2.getAllElements());
    }

    public boolean isTautological() {
        if (this.isInconsistent()) {
            return false;
        }
        return this.mElementTVER.isTautological() && this.mLiteralSetConstraints.isEmpty();
    }

    public void transformElementsAndFunctions(Function<ELEM, ELEM> function) {
        assert (!this.mIsFrozen);
        this.mElementTVER.transformElements(function);
        this.getAuxData().transformElements(function);
        this.mFaAuxData.transformElements(function);
        this.mLiteralSetConstraints.transformElements(function);
    }

    private static <E> boolean sanitizeTransformer(Function<E, E> function, Set<E> set) {
        for (E e : set) {
            E e2;
            if (e.equals(e2 = function.apply(e)) || !set.contains(e2)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean hasElements(ELEM ... ELEMArray) {
        ELEM[] ELEMArray2 = ELEMArray;
        int n = ELEMArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELEM ELEM = ELEMArray2[n2];
            if (!this.hasElement(ELEM)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean hasElement(ELEM ELEM) {
        return this.getAllElements().contains(ELEM);
    }

    @Override
    public boolean isConstrained(ELEM ELEM) {
        if (!this.hasElement(ELEM)) {
            return false;
        }
        if (this.isConstrainedDirectly(ELEM)) {
            return true;
        }
        if (ELEM.isDependentNonFunctionApplication()) {
            for (ICongruenceClosureElement iCongruenceClosureElement : ELEM.getSupportingNodes()) {
                if (!this.isConstrained(iCongruenceClosureElement)) continue;
                return true;
            }
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.mFaAuxData.getAfParents(ELEM)) {
            if (!this.isConstrained(iCongruenceClosureElement)) continue;
            return true;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement : this.mFaAuxData.getArgParents(ELEM)) {
            if (!this.isConstrained(iCongruenceClosureElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConstrainedDirectly(ELEM ELEM) {
        if (!this.hasElement(ELEM)) {
            return false;
        }
        if (this.mElementTVER.isConstrained(ELEM)) {
            return true;
        }
        return this.mLiteralSetConstraints.isConstrained(ELEM);
    }

    CongruenceClosure<ELEM> projectToElements(Set<ELEM> set, IRemovalInfo<ELEM> iRemovalInfo) {
        Iterator<Object> iterator2;
        Object object4;
        Object object2;
        assert (!this.mIsFrozen);
        if (this.isInconsistent()) {
            return this;
        }
        CongruenceClosure<Object> congruenceClosure = this.mManager.getCopyWithRemovalInfo(this, iRemovalInfo);
        HashSet<ELEM> hashSet = new HashSet<ELEM>(set);
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet<Object> hashSet3 = new HashSet<Object>();
        while (!hashSet.isEmpty()) {
            Object object3;
            object2 = (ICongruenceClosureElement)hashSet.iterator().next();
            hashSet.remove(object2);
            if (!congruenceClosure.hasElement(object2)) continue;
            hashSet3.addAll(congruenceClosure.mElementTVER.getEquivalenceClass(object2));
            hashSet2.add(object2);
            for (Object object4 : new HashSet<Object>(congruenceClosure.getAuxData().getAfCcPars(congruenceClosure.getRepresentativeElement(object2)))) {
                if (hashSet3.contains(object4) || hashSet2.contains(object3 = object4.replaceAppliedFunction(object2)) || iRemovalInfo != null && CongruenceClosure.dependsOnAny(object3, iRemovalInfo.getRemovedElements())) continue;
                assert (iRemovalInfo == null || !CongruenceClosure.dependsOnAny(object3, iRemovalInfo.getRemovedElements()));
                this.mManager.addElement(congruenceClosure, object3, true, false);
                hashSet.add(object3);
            }
            for (Object object4 : new HashSet<Object>(congruenceClosure.getAuxData().getArgCcPars(congruenceClosure.getRepresentativeElement(object2)))) {
                if (hashSet3.contains(object4) || hashSet2.contains(object3 = object4.replaceArgument(object2)) || iRemovalInfo != null && CongruenceClosure.dependsOnAny(object3, iRemovalInfo.getRemovedElements())) continue;
                assert (iRemovalInfo == null || !CongruenceClosure.dependsOnAny(object3, iRemovalInfo.getRemovedElements()));
                this.mManager.addElement(congruenceClosure, object3, true, false);
                hashSet.add(object3);
            }
            for (Object object4 : congruenceClosure.getLiteralSetConstraints().getRelatedElements(congruenceClosure.getRepresentativeElement(object2))) {
                if (hashSet3.contains(object4) || hashSet2.contains(object4) || iRemovalInfo != null && CongruenceClosure.dependsOnAny(object4, iRemovalInfo.getRemovedElements())) continue;
                assert (iRemovalInfo == null || !CongruenceClosure.dependsOnAny(object4, iRemovalInfo.getRemovedElements()));
                this.mManager.addElement(congruenceClosure, object4, true, false);
                hashSet.add(object4);
            }
        }
        object2 = congruenceClosure.mElementTVER.filterAndKeepOnlyConstraintsThatIntersectWith(hashSet2);
        assert (this.assertNoNewElementsIntroduced(this.getAllElements(), ((ThreeValuedEquivalenceRelation)object2).getAllElements(), set)) : "no elements may have been introduced that were not present before this operation";
        object4 = congruenceClosure.mLiteralSetConstraints.filterAndKeepOnlyConstraintsThatIntersectWith(hashSet2);
        for (Iterator<Object> iterator2 : ((CCLiteralSetConstraints)object4).getAllElementsMentionedInASetConstraint()) {
            ((ThreeValuedEquivalenceRelation)object2).addElement(iterator2);
        }
        iterator2 = this.mManager.getCongruenceClosureFromTver((ThreeValuedEquivalenceRelation<ELEM>)object2, iRemovalInfo, (CCLiteralSetConstraints<ELEM>)object4, true);
        assert (this.assertNoNewElementsIntroduced(this.getAllElements(), ((CongruenceClosure)((Object)iterator2)).getAllElements(), set)) : "no elements may have been introduced that were not present before this operation";
        assert (!((CongruenceClosure)((Object)iterator2)).isInconsistent()) : "cannot go from a consistent input to an inconsisten output during projectTo";
        return iterator2;
    }

    public boolean assertNoNewElementsIntroduced(Set<ELEM> set, Set<ELEM> set2, Set<ELEM> set3) {
        Set<ICongruenceClosureElement> set4 = DataStructureUtils.difference(set2, set);
        for (ICongruenceClosureElement iCongruenceClosureElement : set4) {
            if (CongruenceClosure.dependsOnAny(iCongruenceClosureElement, set3)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public Collection<ELEM> getAllRepresentatives() {
        return this.mElementTVER.getAllRepresentatives();
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean dependsOnAny(ELEM ELEM, Set<ELEM> set) {
        if (set.contains(ELEM)) {
            return true;
        }
        if (ELEM.isDependentNonFunctionApplication() && DataStructureUtils.haveNonEmptyIntersection(ELEM.getSupportingNodes(), set)) {
            return true;
        }
        if (ELEM.isFunctionApplication()) {
            return CongruenceClosure.dependsOnAny(ELEM.getAppliedFunction(), set) || CongruenceClosure.dependsOnAny(ELEM.getArgument(), set);
        }
        return false;
    }

    public IRemovalInfo<ELEM> getElementCurrentlyBeingRemoved() {
        return this.mElementCurrentlyBeingRemoved;
    }

    public void setExternalRemInfo(IRemovalInfo<ELEM> iRemovalInfo) {
        assert (this.mExternalRemovalInfo == null || this.mExternalRemovalInfo == iRemovalInfo);
        this.mExternalRemovalInfo = iRemovalInfo;
    }

    public boolean isRepresentative(ELEM ELEM) {
        return this.mElementTVER.isRepresentative(ELEM);
    }

    public CcAuxData<ELEM> getAuxData() {
        return this.mAuxData;
    }

    public void reportEqualityToElementTVER(ELEM ELEM, ELEM ELEM2) {
        this.mElementTVER.reportEquality(ELEM, ELEM2);
    }

    public boolean isElementTverInconsistent() {
        return this.mElementTVER.isInconsistent();
    }

    public void reportDisequalityToElementTver(ELEM ELEM, ELEM ELEM2) {
        this.mElementTVER.reportDisequality(ELEM, ELEM2);
    }

    public Collection<ELEM> getArgCcPars(ELEM ELEM) {
        return this.mAuxData.getArgCcPars(ELEM);
    }

    public Collection<ELEM> getFuncAppsWithFunc(ELEM ELEM) {
        return this.mFaAuxData.getAfParents(ELEM);
    }

    public void setElementCurrentlyBeingRemoved(IRemovalInfo<ELEM> iRemovalInfo) {
        assert (iRemovalInfo == null || this.mElementCurrentlyBeingRemoved == null);
        this.mElementCurrentlyBeingRemoved = iRemovalInfo;
    }

    @Override
    public boolean isDebugMode() {
        return this.mManager.isDebugMode();
    }

    @Override
    public ILogger getLogger() {
        return this.mManager.getLogger();
    }

    public Set<ELEM> getEquivalenceClass(ELEM ELEM) {
        return Collections.unmodifiableSet(this.mElementTVER.getEquivalenceClass(ELEM));
    }

    public Set<ELEM> getAllLiterals() {
        return Collections.unmodifiableSet(this.mAllLiterals);
    }

    public CcManager<ELEM> getManager() {
        return this.mManager;
    }

    @Override
    public void reportContainsConstraint(ELEM ELEM, Set<ELEM> set) {
        HashRelation<ELEM, ELEM> hashRelation = this.mLiteralSetConstraints.reportContains(ELEM, (Collection<ELEM>)set);
        if (hashRelation != null) {
            for (Map.Entry entry : hashRelation) {
                this.mManager.reportEquality((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), this, true);
            }
        }
    }

    @Override
    public void reportContainsConstraint(ELEM ELEM, Collection<SetConstraint<ELEM>> collection) {
        HashRelation<ELEM, ELEM> hashRelation = this.mLiteralSetConstraints.reportContains(ELEM, (Set<SetConstraint<ELEM>>)new HashSet<SetConstraint<ELEM>>(collection));
        if (hashRelation != null) {
            for (Map.Entry entry : hashRelation) {
                this.mManager.reportEquality((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue(), this, true);
            }
        }
    }

    public Set<SetConstraint<ELEM>> getContainsConstraintForElement(ELEM ELEM) {
        Set<SetConstraint<ELEM>> set = this.mLiteralSetConstraints.getConstraint(ELEM);
        if (SetConstraintManager.isTautologicalWrtElement(ELEM, set)) {
            return null;
        }
        return set;
    }

    protected class FuncAppTreeAuxData {
        private final HashRelation<ELEM, ELEM> mDirectAfPars;
        private final HashRelation<ELEM, ELEM> mDirectArgPars;
        private final HashRelation<ELEM, ELEM> mNodeToDependents;

        FuncAppTreeAuxData() {
            this.mDirectAfPars = new HashRelation();
            this.mDirectArgPars = new HashRelation();
            this.mNodeToDependents = new HashRelation();
        }

        FuncAppTreeAuxData(FuncAppTreeAuxData funcAppTreeAuxData) {
            this.mDirectAfPars = new HashRelation(funcAppTreeAuxData.mDirectAfPars);
            this.mDirectArgPars = new HashRelation(funcAppTreeAuxData.mDirectArgPars);
            this.mNodeToDependents = new HashRelation(funcAppTreeAuxData.mNodeToDependents);
        }

        public void addSupportingNode(ELEM ELEM, ELEM ELEM2) {
            this.mNodeToDependents.addPair(ELEM, ELEM2);
        }

        public void addAfParent(ELEM ELEM, ELEM ELEM2) {
            this.mDirectAfPars.addPair(ELEM, ELEM2);
        }

        public void addArgParent(ELEM ELEM, ELEM ELEM2) {
            this.mDirectArgPars.addPair(ELEM, ELEM2);
        }

        public Set<ELEM> getAfParents(ELEM ELEM) {
            return Collections.unmodifiableSet(this.mDirectAfPars.getImage(ELEM));
        }

        public Set<ELEM> getArgParents(ELEM ELEM) {
            return Collections.unmodifiableSet(this.mDirectArgPars.getImage(ELEM));
        }

        public void removeAfParent(ELEM ELEM, ELEM ELEM2) {
            this.mDirectAfPars.removePair(ELEM, ELEM2);
        }

        public void removeArgParent(ELEM ELEM, ELEM ELEM2) {
            this.mDirectArgPars.removePair(ELEM, ELEM2);
        }

        public void transformElements(Function<ELEM, ELEM> function) {
            this.mDirectAfPars.transformElements(function, function);
            this.mDirectArgPars.transformElements(function, function);
            for (Map.Entry entry : new HashRelation(this.mNodeToDependents).getSetOfPairs()) {
                this.mNodeToDependents.removePair((ICongruenceClosureElement)entry.getKey(), (ICongruenceClosureElement)entry.getValue());
                this.mNodeToDependents.addPair((ICongruenceClosureElement)function.apply((ICongruenceClosureElement)entry.getKey()), (ICongruenceClosureElement)function.apply((ICongruenceClosureElement)entry.getValue()));
            }
        }

        public Set<Map.Entry<ELEM, ELEM>> getNodeToDependentPairs() {
            return this.mNodeToDependents.getSetOfPairs();
        }

        public Set<ELEM> getDependentsOf(ELEM ELEM) {
            return this.mNodeToDependents.getImage(ELEM);
        }

        public void removeFromNodeToDependents(ELEM ELEM) {
            if (ELEM.isDependentNonFunctionApplication()) {
                this.mNodeToDependents.removeRangeElement(ELEM);
            }
            this.mNodeToDependents.removeDomainElement(ELEM);
        }
    }
}

