/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class CrossProducts {
    private CrossProducts() {
    }

    public static List<int[]> crossProduct(int[][] nArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        CrossProducts.crossProductHelper(arrayList, nArray, new int[nArray.length], 0);
        return arrayList;
    }

    public static <T> List<List<T>> crossProductOfSets(List<Set<T>> list) {
        ArrayList<List<Object>> arrayList = new ArrayList<List<T>>();
        arrayList.add(new ArrayList());
        for (Set<T> set : list) {
            ArrayList arrayList2 = new ArrayList();
            for (List list2 : arrayList) {
                for (T t : set) {
                    ArrayList<T> arrayList3 = new ArrayList<T>(list2);
                    arrayList3.add(t);
                    arrayList2.add(arrayList3);
                }
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public static <T> List<List<T>> crossProduct(List<List<T>> list) {
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>(list.size());
        int n = 0;
        while (n < list.size()) {
            arrayList2.add(null);
            ++n;
        }
        CrossProducts.crossProductHelper(arrayList, list, arrayList2, 0);
        return arrayList;
    }

    private static void crossProductHelper(List<int[]> list, int[][] nArray, int[] nArray2, int n) {
        if (n == nArray2.length) {
            list.add((int[])nArray2.clone());
        } else {
            int[] nArray3 = nArray[n];
            int n2 = nArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                nArray2[n] = n4 = nArray3[n3];
                CrossProducts.crossProductHelper(list, nArray, nArray2, n + 1);
                ++n3;
            }
        }
    }

    private static <T> void crossProductHelper(List<List<T>> list, List<List<T>> list2, ArrayList<T> arrayList, int n) {
        if (n == arrayList.size()) {
            list.add(arrayList.stream().filter(object -> object != null).collect(Collectors.toList()));
        } else {
            for (T t : list2.get(n)) {
                arrayList.set(n, t);
                CrossProducts.crossProductHelper(list, list2, arrayList, n + 1);
            }
        }
    }

    public static <T> List<int[]> subArrays(int[] nArray, int n) {
        assert (n <= nArray.length);
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        CrossProducts.sublistHelper(arrayList, nArray, new int[n], 0, 0);
        return arrayList;
    }

    public static <T> List<T[]> subArrays(T[] TArray, int n, T[] TArray2) {
        assert (TArray != null && n <= TArray.length);
        assert (TArray2 != null && TArray2.length == n);
        ArrayList<T[]> arrayList = new ArrayList<T[]>();
        CrossProducts.sublistHelper(arrayList, TArray, TArray2, 0, 0);
        return arrayList;
    }

    private static void sublistHelper(List<int[]> list, int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 == nArray2.length) {
            list.add((int[])nArray2.clone());
        } else {
            int n3 = nArray2.length - n2;
            int n4 = n;
            while (n4 <= nArray.length - n3) {
                nArray2[n2] = nArray[n4];
                CrossProducts.sublistHelper(list, nArray, nArray2, n4 + 1, n2 + 1);
                ++n4;
            }
        }
    }

    private static <T> void sublistHelper(List<T[]> list, T[] TArray, T[] TArray2, int n, int n2) {
        if (n2 == TArray2.length) {
            list.add((Object[])TArray2.clone());
        } else {
            int n3 = TArray2.length - n2;
            int n4 = n;
            while (n4 <= TArray.length - n3) {
                TArray2[n2] = TArray[n4];
                CrossProducts.sublistHelper(list, TArray, TArray2, n4 + 1, n2 + 1);
                ++n4;
            }
        }
    }

    public static <E> HashRelation<E, E> binarySelectiveCrossProduct(Collection<E> collection, boolean bl, boolean bl2) {
        HashRelation<E, E> hashRelation = new HashRelation<E, E>();
        Iterator<E> iterator = collection.iterator();
        int n = 0;
        while (n < collection.size()) {
            E e = iterator.next();
            Iterator<E> iterator2 = collection.iterator();
            int n2 = bl2 ? collection.size() : n + 1;
            int n3 = 0;
            while (n3 < n2) {
                if (n3 == n && !bl) {
                    iterator2.next();
                } else {
                    E e2 = iterator2.next();
                    hashRelation.addPair(e, e2);
                }
                ++n3;
            }
            ++n;
        }
        return hashRelation;
    }

    public static <E> HashRelation<E, E> binarySelectiveCrossProduct(Collection<E> collection, boolean bl, BiPredicate<E, E> biPredicate) {
        HashRelation<E, E> hashRelation = new HashRelation<E, E>();
        Iterator<E> iterator = collection.iterator();
        int n = 0;
        while (n < collection.size()) {
            E e = iterator.next();
            Iterator<E> iterator2 = collection.iterator();
            int n2 = bl ? collection.size() : n + 1;
            int n3 = 0;
            while (n3 < n2) {
                E e2 = iterator2.next();
                if (biPredicate.test(e, e2)) {
                    E e3 = e2;
                    hashRelation.addPair(e, e3);
                }
                ++n3;
            }
            ++n;
        }
        return hashRelation;
    }

    public static List<List<Integer>> crossProductOfSetsOfFirstNaturalNumbers(List<Integer> list) {
        ArrayList arrayList = new ArrayList();
        for (Integer n : list) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n2 = 0;
            while (n2 < n) {
                arrayList2.add(n2);
                ++n2;
            }
            arrayList.add(arrayList2);
        }
        return CrossProducts.crossProduct(arrayList);
    }

    public static <E> List<List<E>> crossProductNTimes(int n, Set<E> set) {
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(set);
            ++n2;
        }
        return CrossProducts.crossProductOfSets(arrayList);
    }
}

