/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.hopcroft;

import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class RuleContext<LETTER extends IRankedLetter, STATE> {
    private final STATE mDestinationRepresentative;
    private final LETTER mLetter;
    private final List<STATE> mSourceRepresentatives;
    private final ArrayList<LinkedHashSet<STATE>> mSources;

    public RuleContext(List<STATE> list, LETTER LETTER, STATE STATE) {
        this.mSourceRepresentatives = list;
        this.mLetter = LETTER;
        this.mDestinationRepresentative = STATE;
        this.mSources = new ArrayList(this.mSourceRepresentatives.size());
    }

    public void addSource(List<STATE> list) {
        if (list.size() != this.mSourceRepresentatives.size()) {
            throw new IllegalArgumentException("The size of the given list must be equal to the size of this context.");
        }
        Iterator<STATE> iterator = list.iterator();
        int n = 0;
        while (n < list.size()) {
            LinkedHashSet<Object> linkedHashSet;
            STATE STATE = iterator.next();
            if (n >= this.mSources.size()) {
                linkedHashSet = new LinkedHashSet();
                this.mSources.add(linkedHashSet);
            } else {
                linkedHashSet = this.mSources.get(n);
            }
            linkedHashSet.add(STATE);
            ++n;
        }
    }

    public STATE getDestinationRepresentative() {
        return this.mDestinationRepresentative;
    }

    public LETTER getLetter() {
        return this.mLetter;
    }

    public STATE getSourceRepresentativeAtPosition(int n) {
        if (n < 0 || n >= this.mSourceRepresentatives.size()) {
            throw new IllegalArgumentException("The position must be between 0 (inclusive) and the length of this contexts source tuple (exclusive).");
        }
        return this.mSourceRepresentatives.get(n);
    }

    public List<STATE> getSourceRepresentatives() {
        return this.mSourceRepresentatives;
    }

    public List<? extends Set<STATE>> getSources() {
        return this.mSources;
    }

    public int getSourceSize() {
        return this.mSourceRepresentatives.size();
    }

    public Set<STATE> getSourceStatesAtPosition(int n) {
        if (n < 0 || n >= this.mSources.size()) {
            throw new IllegalArgumentException("The position must be between 0 (inclusive) and the length of this contexts source tuple (exclusive).");
        }
        return this.mSources.get(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RuleContext [destinationRepresentative=");
        stringBuilder.append(this.mDestinationRepresentative);
        stringBuilder.append(", letter=");
        stringBuilder.append(this.mLetter);
        stringBuilder.append(", sourceRepresentatives=");
        stringBuilder.append(this.mSourceRepresentatives);
        stringBuilder.append(", sources=");
        stringBuilder.append(this.mSources);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

