/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.Req2CauseTrackingCDD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ReqInOutGuesser {
    private final ILogger mLogger;
    private final Map<String, DeclarationPattern> mVar2InitPattern;
    private final List<DeclarationPattern> mNewInitPatterns;
    private final Map<String, Integer> mId2Bounds;
    private final List<PatternType<?>> mNewRequirements;
    private final Set<PatternType<?>> mRequirementsWithTransformationErrors;
    private final PeaResultUtil mResultUtil;

    public ReqInOutGuesser(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, List<DeclarationPattern> list, List<PatternType<?>> list2) {
        this.mLogger = iLogger;
        this.mVar2InitPattern = new HashMap<String, DeclarationPattern>();
        this.mId2Bounds = new HashMap<String, Integer>();
        this.mResultUtil = new PeaResultUtil(iLogger, iUltimateServiceProvider);
        this.mRequirementsWithTransformationErrors = new HashSet();
        HashSet<DeclarationPattern> hashSet = new HashSet<DeclarationPattern>();
        for (DeclarationPattern declarationPattern : list) {
            if (declarationPattern.getCategory() == DeclarationPattern.VariableCategory.CONST) {
                this.mId2Bounds.put(declarationPattern.getId(), 42);
                hashSet.add(declarationPattern);
                continue;
            }
            this.mVar2InitPattern.put(declarationPattern.getId(), declarationPattern);
        }
        if (ReqInOutGuesser.isInputOnlyPattern(list)) {
            this.mLogger.warn((Object)"No input/output assignment was chosen! We will make a very conservative guess.");
            this.mNewInitPatterns = this.generateNewInitializationPattern(this.mVar2InitPattern.values(), list2);
            this.mNewInitPatterns.addAll(hashSet);
        } else {
            this.mNewInitPatterns = list;
        }
        if (this.mRequirementsWithTransformationErrors.isEmpty()) {
            this.mNewRequirements = list2;
        } else {
            this.mNewRequirements = new ArrayList(list2.size());
            for (PatternType patternType : list2) {
                if (this.mRequirementsWithTransformationErrors.contains(patternType)) continue;
                this.mNewRequirements.add(patternType);
            }
        }
    }

    private List<DeclarationPattern> generateNewInitializationPattern(Collection<DeclarationPattern> collection, List<PatternType<?>> list) {
        Set<String> set = ReqInOutGuesser.getAllVariables(collection);
        Set<String> set2 = this.getEffectVariables(list);
        Set<String> set3 = this.getPreconditionVars(list);
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.removeAll(set2);
        this.mLogger.warn((Object)("Inputs: " + ((Object)hashSet).toString()));
        HashSet<String> hashSet2 = new HashSet<String>(set);
        hashSet2.removeAll(set3);
        this.mLogger.warn((Object)("Outputs: " + ((Object)hashSet2).toString()));
        HashSet<String> hashSet3 = new HashSet<String>(set);
        hashSet3.removeAll(hashSet);
        hashSet3.removeAll(hashSet2);
        ArrayList<DeclarationPattern> arrayList = new ArrayList<DeclarationPattern>();
        for (String string : hashSet) {
            arrayList.add(new DeclarationPattern(string, this.mVar2InitPattern.get(string).getType(), DeclarationPattern.VariableCategory.IN));
        }
        for (String string : hashSet2) {
            arrayList.add(new DeclarationPattern(string, this.mVar2InitPattern.get(string).getType(), DeclarationPattern.VariableCategory.OUT));
        }
        for (String string : hashSet3) {
            arrayList.add(new DeclarationPattern(string, this.mVar2InitPattern.get(string).getType(), DeclarationPattern.VariableCategory.HIDDEN));
        }
        return arrayList;
    }

    private Set<String> getEffectVariables(List<PatternType<?>> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PatternType<?> patternType : list) {
            hashSet.addAll(this.reportTransformationErrorWrapper(Req2CauseTrackingCDD::getEffectVariables, patternType));
        }
        return hashSet;
    }

    private Set<String> getPreconditionVars(List<PatternType<?>> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PatternType<?> patternType : list) {
            Set<String> set = this.reportTransformationErrorWrapper(Req2CauseTrackingCDD::getAllVariables, patternType);
            set.removeAll(this.reportTransformationErrorWrapper(Req2CauseTrackingCDD::getEffectVariables, patternType));
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private Set<String> reportTransformationErrorWrapper(Function<PatternType<?>, Set<String>> function, PatternType<?> patternType) {
        if (this.mRequirementsWithTransformationErrors.contains(patternType)) {
            return Collections.emptySet();
        }
        try {
            return function.apply(patternType);
        }
        catch (Exception exception) {
            String string = exception.getMessage() == null ? exception.getClass().toString() : exception.getMessage();
            this.mResultUtil.transformationError(patternType, string);
            this.mRequirementsWithTransformationErrors.add(patternType);
            return Collections.emptySet();
        }
    }

    private static Set<String> getAllVariables(Collection<DeclarationPattern> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PatternType patternType : collection) {
            hashSet.add(((DeclarationPattern)patternType).getId());
        }
        return hashSet;
    }

    private static boolean isInputOnlyPattern(List<DeclarationPattern> list) {
        for (DeclarationPattern declarationPattern : list) {
            if (declarationPattern.getCategory() == DeclarationPattern.VariableCategory.IN || declarationPattern.getCategory() == DeclarationPattern.VariableCategory.CONST) continue;
            return false;
        }
        return true;
    }

    public List<DeclarationPattern> getInitializationPatterns() {
        return this.mNewInitPatterns;
    }

    public List<PatternType<?>> getRequirements() {
        return this.mNewRequirements;
    }
}

