/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BaseDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableDirectedGraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import java.util.Collection;

public abstract class ModifiableDirectedGraph<T extends IModifiableDirectedGraph<T, VisualizationNode>>
extends BaseDirectedGraph<T>
implements IModifiableDirectedGraph<T, VisualizationNode> {
    private static final long serialVersionUID = 1L;

    protected ModifiableDirectedGraph() {
        this(null, null);
    }

    protected ModifiableDirectedGraph(IPayload iPayload) {
        this(null, iPayload);
    }

    protected ModifiableDirectedGraph(T t) {
        this(t, null);
    }

    protected ModifiableDirectedGraph(T t, IPayload iPayload) {
        super(t, iPayload);
    }

    public boolean connectIncoming(T t) {
        boolean bl = this.addIncoming(t);
        boolean bl2 = t.addOutgoing((Object)this);
        assert (bl == bl2);
        return bl;
    }

    public boolean disconnectIncoming(T t) {
        boolean bl = this.removeIncoming(t);
        boolean bl2 = t.removeOutgoing((Object)this);
        assert (bl == bl2);
        return bl;
    }

    public boolean connectOutgoing(T t) {
        boolean bl = this.addOutgoing(t);
        boolean bl2 = t.addIncoming((Object)this);
        assert (bl == bl2);
        return bl;
    }

    public boolean disconnectOutgoing(T t) {
        boolean bl = this.removeOutgoing(t);
        boolean bl2 = t.removeIncoming((Object)this);
        assert (bl == bl2);
        return bl;
    }

    public boolean addOutgoing(T t) {
        if (t == this) assert (false);
        if (t != null) {
            return this.mOutgoingNodes.add(t);
        }
        return false;
    }

    public boolean addOutgoing(int n, T t) {
        int n2 = this.mOutgoingNodes.size();
        this.mOutgoingNodes.add(n, t);
        return n2 != this.mOutgoingNodes.size();
    }

    public boolean addAllOutgoing(Collection<? extends T> collection) {
        boolean bl = false;
        for (IModifiableDirectedGraph iModifiableDirectedGraph : collection) {
            bl |= this.addOutgoing((T)iModifiableDirectedGraph);
        }
        return bl;
    }

    public boolean addAllOutgoing(int n, Collection<? extends T> collection) {
        return this.mOutgoingNodes.addAll(n, collection);
    }

    public void clearOutgoing() {
        this.mOutgoingNodes.clear();
    }

    public T removeOutgoing(int n) {
        return (T)((IModifiableDirectedGraph)this.mOutgoingNodes.remove(n));
    }

    public boolean removeOutgoing(T t) {
        return this.mOutgoingNodes.remove(t);
    }

    public boolean removeAllOutgoing(Collection<? extends T> collection) {
        boolean bl = false;
        for (IModifiableDirectedGraph iModifiableDirectedGraph : collection) {
            bl |= this.removeOutgoing((T)iModifiableDirectedGraph);
        }
        return bl;
    }

    public boolean addIncoming(T t) {
        if (t == this) assert (false);
        if (t != null) {
            return this.mIncomingNodes.add(t);
        }
        return false;
    }

    public boolean addIncoming(int n, T t) {
        int n2 = this.mIncomingNodes.size();
        this.mIncomingNodes.add(n, t);
        return n2 != this.mIncomingNodes.size();
    }

    public boolean addAllIncoming(Collection<? extends T> collection) {
        boolean bl = false;
        for (IModifiableDirectedGraph iModifiableDirectedGraph : collection) {
            bl |= this.addIncoming((T)iModifiableDirectedGraph);
        }
        return bl;
    }

    public boolean addAllIncoming(int n, Collection<? extends T> collection) {
        return this.mIncomingNodes.addAll(n, collection);
    }

    public void clearIncoming() {
        this.mIncomingNodes.clear();
    }

    public T removeIncoming(int n) {
        return (T)((IModifiableDirectedGraph)this.mIncomingNodes.remove(n));
    }

    public boolean removeIncoming(T t) {
        return this.mIncomingNodes.remove(t);
    }

    public boolean removeAllIncoming(Collection<? extends T> collection) {
        boolean bl = false;
        for (IModifiableDirectedGraph iModifiableDirectedGraph : collection) {
            bl |= this.removeIncoming((T)iModifiableDirectedGraph);
        }
        return bl;
    }
}

