/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.MappedTerm2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.Segmentation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalTermUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.Boogie2SmtSymbolTableTmpVars;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.BoogieVarFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.CallInfoCache;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TemporaryBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ArrayDomainToolkit<STATE extends IAbstractState<STATE>> {
    private static final String BOUND_NAME = "b";
    private static final String VALUE_NAME = "v";
    private static final String AUX_NAME = "aux";
    private final IAbstractDomain<STATE, IcfgEdge> mSubDomain;
    private final BoogieVarFactory mBoogieVarFactory;
    private final Boogie2SMT mBoogie2Smt;
    private final CodeBlockFactory mCodeBlockFactory;
    private final CallInfoCache mCallInfoCache;
    private final TemporaryBoogieVar mMinBound;
    private final TemporaryBoogieVar mMaxBound;
    private final Map<TermVariable, String> mAuxVarNameMap;
    private final MappedTerm2Expression mMappedTerm2Expression;
    private final Boogie2SmtSymbolTableTmpVars mVariableProvider;
    private final IUltimateServiceProvider mServices;
    private final Map<Term, IAbstractPostOperator.EvalResult> mEvaluationCache;
    private final ILogger mLogger;

    public ArrayDomainToolkit(IAbstractDomain<STATE, IcfgEdge> iAbstractDomain, IIcfg<?> iIcfg, IUltimateServiceProvider iUltimateServiceProvider, BoogieSymbolTable boogieSymbolTable, Boogie2SmtSymbolTableTmpVars boogie2SmtSymbolTableTmpVars, ILogger iLogger) {
        this.mSubDomain = iAbstractDomain;
        BoogieIcfgContainer boogieIcfgContainer = AbsIntUtil.getBoogieIcfgContainer(iIcfg);
        this.mBoogie2Smt = boogieIcfgContainer.getBoogie2SMT();
        this.mCodeBlockFactory = boogieIcfgContainer.getCodeBlockFactory();
        Script script = this.mBoogie2Smt.getScript();
        ManagedScript managedScript = this.mBoogie2Smt.getManagedScript();
        this.mBoogieVarFactory = new BoogieVarFactory(managedScript);
        this.mCallInfoCache = new CallInfoCache(iIcfg.getCfgSmtToolkit(), boogieSymbolTable);
        this.mMappedTerm2Expression = new MappedTerm2Expression(this.mBoogie2Smt.getTypeSortTranslator(), this.mBoogie2Smt.getBoogie2SmtSymbolTable(), managedScript);
        this.mVariableProvider = boogie2SmtSymbolTableTmpVars;
        this.mAuxVarNameMap = new HashMap<TermVariable, String>();
        this.mMinBound = this.createVariable("-inf", SmtSortUtils.getIntSort((Script)script));
        this.mMaxBound = this.createVariable("inf", SmtSortUtils.getIntSort((Script)script));
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mEvaluationCache = new HashMap<Term, IAbstractPostOperator.EvalResult>();
    }

    private TemporaryBoogieVar createVariable(String string, Sort sort) {
        TemporaryBoogieVar temporaryBoogieVar = this.mBoogieVarFactory.createFreshBoogieVar(string, sort);
        this.mAuxVarNameMap.put(temporaryBoogieVar.getTermVariable(), temporaryBoogieVar.getGloballyUniqueId());
        this.mVariableProvider.addTemporaryVariable(temporaryBoogieVar);
        return temporaryBoogieVar;
    }

    public TemporaryBoogieVar createBoundVar(Sort sort) {
        return this.createVariable(BOUND_NAME, sort);
    }

    public TemporaryBoogieVar createValueVar(Sort sort) {
        return this.createVariable(VALUE_NAME, sort);
    }

    public TemporaryBoogieVar createAuxVar(Sort sort) {
        return this.createVariable(AUX_NAME, sort);
    }

    public ManagedScript getManagedScript() {
        return this.mBoogie2Smt.getManagedScript();
    }

    public Script getScript() {
        return this.mBoogie2Smt.getScript();
    }

    public CallInfoCache getCallInfoCache() {
        return this.mCallInfoCache;
    }

    public TemporaryBoogieVar getMinBound() {
        return this.mMinBound;
    }

    public TemporaryBoogieVar getMaxBound() {
        return this.mMaxBound;
    }

    public IAbstractStateBinaryOperator<STATE> getWideningOperator() {
        return this.mSubDomain.getWideningOperator();
    }

    public IUltimateServiceProvider getServices() {
        return this.mServices;
    }

    public STATE handleAssumptionBySubdomain(STATE STATE, Term term) {
        Object var3_3 = null;
        STATE STATE2 = STATE;
        AssumeStatement assumeStatement = new AssumeStatement(null, this.getExpression(term));
        while (var3_3 == null || !var3_3.isEqualTo(STATE2)) {
            var3_3 = STATE2;
            STATE2 = this.handleStatementBySubdomain(STATE2, (Statement)assumeStatement);
        }
        return STATE2;
    }

    public STATE handleStatementBySubdomain(STATE STATE, Statement statement) {
        if (STATE.isBottom()) {
            return STATE;
        }
        StatementSequence statementSequence = this.mCodeBlockFactory.constructStatementSequence(null, null, statement);
        Collection collection = this.mSubDomain.getPostOperator().apply(STATE, (Object)statementSequence);
        if (collection.isEmpty()) {
            return (STATE)this.mSubDomain.createBottomState();
        }
        return (STATE)DisjunctiveAbstractState.union((Collection)collection);
    }

    public IAbstractPostOperator.EvalResult evaluate(STATE STATE, Term term, boolean bl) {
        if (!bl) {
            return this.mSubDomain.getPostOperator().evaluate(STATE, term, this.getScript());
        }
        IAbstractPostOperator.EvalResult evalResult = this.mEvaluationCache.get(term);
        if (evalResult == null) {
            evalResult = this.mSubDomain.getPostOperator().evaluate(STATE, term, this.getScript());
            this.mEvaluationCache.put(term, evalResult);
        }
        return evalResult;
    }

    public Expression getExpression(Term term) {
        return this.mMappedTerm2Expression.translate(term, Collections.emptySet(), this.mAuxVarNameMap);
    }

    public Term getTerm(Expression expression) {
        return this.mBoogie2Smt.getExpression2Term().translateToTerm(new Expression2Term.IIdentifierTranslator[]{new IdentifierTranslator()}, expression).term();
    }

    private IProgramVarOrConst getBoogieVar(String string, DeclarationInformation declarationInformation, boolean bl) {
        IProgramVar iProgramVar = this.mVariableProvider.getBoogieVar(string, declarationInformation, bl);
        if (iProgramVar != null) {
            return iProgramVar;
        }
        return this.mVariableProvider.getBoogieConst(string);
    }

    public IProgramVarOrConst getBoogieVar(IdentifierExpression identifierExpression) {
        return this.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false);
    }

    public IProgramVar getBoogieVar(VariableLHS variableLHS) {
        IProgramVar iProgramVar = this.mVariableProvider.getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false);
        if (iProgramVar == null) {
            String string = variableLHS.getIdentifier().replaceAll("old\\((.*)\\)", "$1");
            iProgramVar = this.mVariableProvider.getBoogieVar(string, variableLHS.getDeclarationInformation(), false);
            iProgramVar = ((ProgramNonOldVar)iProgramVar).getOldVar();
        }
        assert (iProgramVar != null) : "Could not find boogie var";
        return iProgramVar;
    }

    public Pair<IProgramVar, Segmentation> createTopSegmentation(Sort sort) {
        TemporaryBoogieVar temporaryBoogieVar = this.createValueVar(TypeUtils.getValueSort(sort));
        Segmentation segmentation = new Segmentation(Arrays.asList(this.mMinBound, this.mMaxBound), Arrays.asList(temporaryBoogieVar));
        return new Pair((Object)temporaryBoogieVar, (Object)segmentation);
    }

    public Term connstructEquivalentConstraint(IProgramVarOrConst iProgramVarOrConst, IProgramVar iProgramVar, Term term) {
        Term term2 = NonrelationalTermUtils.getTermVar(iProgramVarOrConst);
        TermVariable termVariable = iProgramVar.getTermVariable();
        Term term3 = SmtUtils.filterFormula((Term)term, Collections.singleton(termVariable), (Script)this.getScript());
        return PureSubstitution.apply((Script)this.getScript(), Collections.singletonMap(termVariable, term2), (Term)term3);
    }

    public ArrayDomainState<STATE> createBottomState() {
        IAbstractState iAbstractState = this.mSubDomain.createBottomState();
        return new ArrayDomainState<IAbstractState>(iAbstractState, (ImmutableSet<IProgramVarOrConst>)iAbstractState.getVariables(), this);
    }

    public ArrayDomainState<STATE> createTopState() {
        IAbstractState iAbstractState = this.mSubDomain.createTopState();
        return new ArrayDomainState<IAbstractState>(iAbstractState, (ImmutableSet<IProgramVarOrConst>)iAbstractState.getVariables(), this);
    }

    public Term eliminateQuantifier(Term term) {
        return PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term);
    }

    private class IdentifierTranslator
    implements Expression2Term.IIdentifierTranslator {
        private IdentifierTranslator() {
        }

        public Term getSmtIdentifier(String string, DeclarationInformation declarationInformation, boolean bl, BoogieASTNode boogieASTNode) {
            return ArrayDomainToolkit.this.getBoogieVar(string, declarationInformation, bl).getTerm();
        }
    }
}

