/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.rcfg;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ReachDefBoogieAnnotator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVarBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.rcfg.ReachDefRCFGPredecessorGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.util.Util;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ReachDefRCFGVisitor
extends RCFGEdgeVisitor {
    private boolean mFixpointReached;
    private IcfgLocation mCurrentSourceNode;
    private final ILogger mLogger;
    private final IAnnotationProvider<ReachDefEdgeAnnotation> mEdgeProvider;
    private final IAnnotationProvider<ReachDefStatementAnnotation> mStatementProvider;
    private final ScopedBoogieVarBuilder mVarBuilder;
    private HashMap<IcfgEdge, HashSet<ReachDefStatementAnnotation>> mPreMap;

    public ReachDefRCFGVisitor(IAnnotationProvider<ReachDefEdgeAnnotation> iAnnotationProvider, IAnnotationProvider<ReachDefStatementAnnotation> iAnnotationProvider2, ILogger iLogger, ScopedBoogieVarBuilder scopedBoogieVarBuilder) {
        this.mLogger = iLogger;
        this.mEdgeProvider = iAnnotationProvider;
        this.mStatementProvider = iAnnotationProvider2;
        this.mVarBuilder = scopedBoogieVarBuilder;
    }

    public boolean process(IcfgEdge icfgEdge) {
        this.mFixpointReached = true;
        this.visit(icfgEdge);
        return this.mFixpointReached;
    }

    protected void visit(RootEdge rootEdge) {
        this.mFixpointReached = false;
        super.visit(rootEdge);
    }

    protected void visit(CodeBlock codeBlock) {
        ReachDefEdgeAnnotation reachDefEdgeAnnotation = this.mEdgeProvider.getAnnotation((IElement)codeBlock);
        if (reachDefEdgeAnnotation == null) {
            reachDefEdgeAnnotation = new ReachDefEdgeAnnotation((IcfgEdge)codeBlock, this.mStatementProvider);
            this.mEdgeProvider.annotate((IElement)codeBlock, reachDefEdgeAnnotation);
        }
        super.visit(codeBlock);
    }

    protected void visit(StatementSequence statementSequence) {
        boolean bl = false;
        if (statementSequence.getSource() != null) {
            this.mCurrentSourceNode = (IcfgLocation)statementSequence.getSource();
        }
        for (Statement statement : statementSequence.getStatements()) {
            ReachDefStatementAnnotation reachDefStatementAnnotation = this.mStatementProvider.getAnnotation((IElement)statement);
            if (reachDefStatementAnnotation == null) {
                reachDefStatementAnnotation = new ReachDefStatementAnnotation();
                this.mStatementProvider.annotate((IElement)statement, reachDefStatementAnnotation);
                bl = true;
            }
            ReachDefBoogieAnnotator reachDefBoogieAnnotator = this.createBoogieAnnotator(statementSequence, statement, reachDefStatementAnnotation);
            try {
                boolean bl2 = reachDefBoogieAnnotator.annotate(statement, statementSequence.getTransformula());
                if (this.mLogger.isDebugEnabled()) {
                    String string = "            " + statementSequence.hashCode() + " " + BoogiePrettyPrinter.print((Statement)statement);
                    this.mLogger.debug((Object)(string + Util.repeat(40 - string.length(), " ") + " New Use: " + reachDefStatementAnnotation.getUseAsString()));
                    this.mLogger.debug((Object)(string + Util.repeat(40 - string.length(), " ") + " New Def: " + reachDefStatementAnnotation.getDefAsString()));
                }
                bl = bl2 || bl;
            }
            catch (Throwable throwable) {
                this.mLogger.fatal((Object)"Fatal error occured", throwable);
                this.mFixpointReached = true;
                return;
            }
        }
        this.mFixpointReached = !bl && this.mFixpointReached;
        super.visit(statementSequence);
    }

    protected void visit(SequentialComposition sequentialComposition) {
        this.mCurrentSourceNode = (IcfgLocation)sequentialComposition.getSource();
        super.visit(sequentialComposition);
    }

    private ReachDefBoogieAnnotator createBoogieAnnotator(StatementSequence statementSequence, Statement statement, ReachDefStatementAnnotation reachDefStatementAnnotation) {
        AbstractCollection abstractCollection;
        int n = statementSequence.getStatements().indexOf(statement);
        if (n != 0) {
            abstractCollection = new ArrayList<ReachDefStatementAnnotation>();
            abstractCollection.add(this.mStatementProvider.getAnnotation((IElement)statementSequence.getStatements().get(n - 1)));
        } else if (this.mCurrentSourceNode != null) {
            HashSet<ReachDefStatementAnnotation> hashSet;
            if (this.mPreMap == null) {
                this.mPreMap = new HashMap();
            }
            if ((hashSet = this.mPreMap.get(statementSequence)) == null) {
                hashSet = new HashSet();
                this.mPreMap.put((IcfgEdge)statementSequence, hashSet);
            }
            hashSet.addAll(new ReachDefRCFGPredecessorGenerator(this.mStatementProvider, this.mLogger).process(this.mCurrentSourceNode));
            abstractCollection = hashSet;
        } else {
            abstractCollection = new ArrayList();
        }
        return new ReachDefBoogieAnnotator(abstractCollection, reachDefStatementAnnotation, this.mLogger, this.mVarBuilder);
    }
}

