/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;
import java.util.Arrays;

public class ExpressionNormalizer
extends BoogieTransformer {
    private final NormalFormTransformer<Expression> mNormalFormTransformer = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());

    public Expression transform(Expression expression) {
        Expression expression2;
        Expression expression3 = expression2 = (Expression)this.mNormalFormTransformer.simplify((Object)expression);
        Expression expression4 = this.processExpression(expression2);
        while (expression4 != expression3) {
            assert (expression4 != null);
            assert (expression4.getType() != null) : "Normalization did set a null type";
            expression3 = expression4;
            expression4 = this.processExpression(expression3);
        }
        return expression4;
    }

    protected Expression processExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            return this.postNormalize(expression, this.normalizeBinaryExpression((BinaryExpression)expression));
        }
        if (expression instanceof UnaryExpression) {
            return this.postNormalize(expression, this.normalizeUnaryExpression((UnaryExpression)expression));
        }
        return super.processExpression(expression);
    }

    private Expression normalizeBinaryExpression(BinaryExpression binaryExpression) {
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        Expression expression = this.processExpression(binaryExpression.getRight());
        Expression expression2 = this.processExpression(binaryExpression.getLeft());
        if (operator == BinaryExpression.Operator.COMPNEQ) {
            BoogiePrimitiveType boogiePrimitiveType;
            BoogiePrimitiveType boogiePrimitiveType2;
            BoogiePrimitiveType boogiePrimitiveType3;
            if (ExpressionNormalizer.isPrimitive(binaryExpression) && ExpressionNormalizer.isOfType(-1, boogiePrimitiveType3 = (BoogiePrimitiveType)binaryExpression.getType(), boogiePrimitiveType2 = (BoogiePrimitiveType)expression2.getType(), boogiePrimitiveType = (BoogiePrimitiveType)expression.getType())) {
                Expression expression3 = ExpressionNormalizer.not((Expression)binaryExpression, expression);
                return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.COMPEQ, expression2, expression3);
            }
            boogiePrimitiveType3 = ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.COMPLT, expression2, expression);
            boogiePrimitiveType2 = ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.COMPGT, expression2, expression);
            return ExpressionNormalizer.or((Expression)binaryExpression, (Expression)boogiePrimitiveType3, (Expression)boogiePrimitiveType2);
        }
        if (operator == BinaryExpression.Operator.COMPGT || operator == BinaryExpression.Operator.COMPLT) {
            BoogiePrimitiveType boogiePrimitiveType;
            BoogiePrimitiveType boogiePrimitiveType4;
            if (ExpressionNormalizer.isPrimitive(binaryExpression) && ExpressionNormalizer.isOfType(-2, boogiePrimitiveType4 = (BoogiePrimitiveType)expression2.getType(), boogiePrimitiveType = (BoogiePrimitiveType)expression.getType())) {
                if (operator == BinaryExpression.Operator.COMPGT) {
                    Expression expression4 = ExpressionNormalizer.createBinaryExpr(expression, BinaryExpression.Operator.ARITHPLUS, expression, ExpressionNormalizer.createValueLiteral(expression, "1"));
                    return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.COMPGEQ, expression2, expression4);
                }
                if (operator == BinaryExpression.Operator.COMPLT) {
                    BinaryExpression binaryExpression2 = new BinaryExpression(expression.getLocation(), expression.getType(), BinaryExpression.Operator.ARITHMINUS, expression, ExpressionNormalizer.createValueLiteral(expression, "1"));
                    return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.COMPLEQ, expression2, (Expression)binaryExpression2);
                }
            }
        } else {
            if (operator == BinaryExpression.Operator.LOGICIMPLIES) {
                return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.LOGICOR, ExpressionNormalizer.not((Expression)binaryExpression, expression2), expression);
            }
            if (operator == BinaryExpression.Operator.LOGICIFF) {
                Expression expression5 = ExpressionNormalizer.and((Expression)binaryExpression, expression, expression2);
                Expression expression6 = ExpressionNormalizer.and((Expression)binaryExpression, ExpressionNormalizer.not((Expression)binaryExpression, expression), ExpressionNormalizer.not((Expression)binaryExpression, expression2));
                return ExpressionNormalizer.or((Expression)binaryExpression, expression5, expression6);
            }
            if (operator == BinaryExpression.Operator.ARITHPLUS || operator == BinaryExpression.Operator.ARITHMINUS) {
                IdentifierExpression identifierExpression;
                UnaryExpression unaryExpression;
                if (expression instanceof UnaryExpression && (unaryExpression = (UnaryExpression)expression).getOperator() == UnaryExpression.Operator.ARITHNEGATIVE) {
                    return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, operator == BinaryExpression.Operator.ARITHPLUS ? BinaryExpression.Operator.ARITHMINUS : BinaryExpression.Operator.ARITHPLUS, expression2, unaryExpression.getExpr());
                }
                if (expression2 instanceof UnaryExpression) {
                    unaryExpression = (UnaryExpression)expression2;
                    if (operator == BinaryExpression.Operator.ARITHPLUS && unaryExpression.getOperator() == UnaryExpression.Operator.ARITHNEGATIVE) {
                        return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.ARITHMINUS, expression, unaryExpression.getExpr());
                    }
                    if (unaryExpression.getOperator() == UnaryExpression.Operator.ARITHNEGATIVE && expression instanceof IdentifierExpression) {
                        IdentifierExpression identifierExpression2;
                        identifierExpression = (IdentifierExpression)expression;
                        if (unaryExpression.getExpr() instanceof IdentifierExpression && (identifierExpression2 = (IdentifierExpression)unaryExpression.getExpr()).getIdentifier().equals(identifierExpression.getIdentifier())) {
                            return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.ARITHMUL, ExpressionNormalizer.neg((Expression)binaryExpression, ExpressionNormalizer.createValueLiteral((Expression)binaryExpression, "2")), (Expression)identifierExpression);
                        }
                    }
                }
                if (expression2 instanceof IdentifierExpression && expression instanceof IdentifierExpression) {
                    unaryExpression = (IdentifierExpression)expression2;
                    identifierExpression = (IdentifierExpression)expression;
                    if (unaryExpression.getIdentifier().equals(identifierExpression.getIdentifier())) {
                        return operator == BinaryExpression.Operator.ARITHPLUS ? ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, BinaryExpression.Operator.ARITHMUL, ExpressionNormalizer.createValueLiteral((Expression)binaryExpression, "2"), (Expression)unaryExpression) : ExpressionNormalizer.createValueLiteral((Expression)binaryExpression, "0");
                    }
                }
            }
        }
        if (expression2 == binaryExpression.getLeft() && expression == binaryExpression.getRight()) {
            return binaryExpression;
        }
        return ExpressionNormalizer.createBinaryExpr((Expression)binaryExpression, binaryExpression.getOperator(), expression2, expression);
    }

    private Expression normalizeUnaryExpression(UnaryExpression unaryExpression) {
        Expression expression;
        Expression expression2;
        Expression expression3 = this.processExpression(unaryExpression.getExpr());
        if (unaryExpression.getOperator() == UnaryExpression.Operator.LOGICNEG && (expression2 = (Expression)this.mNormalFormTransformer.rewriteNotEquals((Object)(expression = ExpressionNormalizer.createUnaryExpr((Expression)unaryExpression, unaryExpression.getOperator(), expression3)))) != expression) {
            return expression2;
        }
        if (expression3 == unaryExpression.getExpr()) {
            return unaryExpression;
        }
        return ExpressionNormalizer.createUnaryExpr((Expression)unaryExpression, unaryExpression.getOperator(), expression3);
    }

    private static Expression or(Expression expression, Expression expression2, Expression expression3) {
        return ExpressionNormalizer.createBinaryExpr(expression, BinaryExpression.Operator.LOGICOR, expression2, expression3);
    }

    private static Expression not(Expression expression, Expression expression2) {
        return ExpressionNormalizer.createUnaryExpr(expression, UnaryExpression.Operator.LOGICNEG, expression2);
    }

    private static Expression neg(Expression expression, Expression expression2) {
        return ExpressionNormalizer.createUnaryExpr(expression, UnaryExpression.Operator.ARITHNEGATIVE, expression2);
    }

    private static Expression and(Expression expression, Expression expression2, Expression expression3) {
        return ExpressionNormalizer.createBinaryExpr(expression, BinaryExpression.Operator.LOGICAND, expression2, expression3);
    }

    private static Expression createValueLiteral(Expression expression, String string) {
        if (!(expression.getType() instanceof BoogieType)) {
            throw new UnsupportedOperationException("Expected IBoogieType to be of type BoogieType.");
        }
        BoogieType boogieType = (BoogieType)expression.getType();
        if (boogieType == BoogieType.TYPE_INT) {
            return ExpressionNormalizer.createIntegerLiteral(expression, string);
        }
        if (boogieType == BoogieType.TYPE_REAL) {
            return ExpressionNormalizer.createRealLiteral(expression, string);
        }
        throw new UnsupportedOperationException("Type " + String.valueOf(boogieType) + " not implemented.");
    }

    private static IntegerLiteral createIntegerLiteral(Expression expression, String string) {
        return new IntegerLiteral(expression.getLocation(), (IBoogieType)BoogieType.TYPE_INT, string);
    }

    private static RealLiteral createRealLiteral(Expression expression, String string) {
        return new RealLiteral(expression.getLocation(), (IBoogieType)BoogieType.TYPE_REAL, string);
    }

    private static Expression createBinaryExpr(Expression expression, BinaryExpression.Operator operator, Expression expression2, Expression expression3) {
        return new BinaryExpression(expression.getLocation(), ExpressionNormalizer.getNewTypeBinary(operator, expression2, expression3), operator, expression2, expression3);
    }

    private static Expression createUnaryExpr(Expression expression, UnaryExpression.Operator operator, Expression expression2) {
        return new UnaryExpression(expression.getLocation(), ExpressionNormalizer.getNewTypeUnary(operator, expression2), operator, expression2);
    }

    private static IBoogieType getNewTypeBinary(BinaryExpression.Operator operator, Expression expression, Expression expression2) {
        switch (operator) {
            case BITVECCONCAT: 
            case ARITHPLUS: 
            case ARITHMINUS: 
            case ARITHMUL: 
            case ARITHDIV: 
            case ARITHMOD: {
                assert (expression.getType().equals(expression2.getType())) : "Type error";
                return expression.getType();
            }
            case LOGICIFF: 
            case LOGICIMPLIES: 
            case LOGICAND: 
            case LOGICOR: 
            case COMPLT: 
            case COMPGT: 
            case COMPLEQ: 
            case COMPGEQ: 
            case COMPEQ: 
            case COMPNEQ: 
            case COMPPO: {
                return BoogieType.TYPE_BOOL;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf(operator));
    }

    private static IBoogieType getNewTypeUnary(UnaryExpression.Operator operator, Expression expression) {
        switch (operator) {
            case ARITHNEGATIVE: 
            case OLD: {
                return expression.getType();
            }
            case LOGICNEG: {
                return BoogieType.TYPE_BOOL;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf(operator));
    }

    private static boolean isPrimitive(BinaryExpression binaryExpression) {
        return binaryExpression.getType() instanceof BoogiePrimitiveType && binaryExpression.getLeft().getType() instanceof BoogiePrimitiveType && binaryExpression.getRight().getType() instanceof BoogiePrimitiveType;
    }

    private static boolean isOfType(int n, BoogiePrimitiveType ... boogiePrimitiveTypeArray) {
        if (boogiePrimitiveTypeArray == null || boogiePrimitiveTypeArray.length == 0) {
            return false;
        }
        return Arrays.stream(boogiePrimitiveTypeArray).allMatch(boogiePrimitiveType -> boogiePrimitiveType.getTypeCode() == n);
    }

    private Expression postNormalize(Expression expression, Expression expression2) {
        if (expression2 == null || expression2 == expression) {
            return expression;
        }
        ModelUtils.copyAnnotations((IElement)expression, (IElement)expression2);
        return this.processExpression(expression2);
    }
}

