/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.Acc;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface IBuchi<S extends IState> {
    public Acc getAcceptance();

    public int getStateSize();

    public S addState();

    public S makeState(int var1);

    public int addState(S var1);

    public S getState(int var1);

    public IntSet getInitialStates();

    public IntSet getFinalStates();

    default public boolean isInitial(S s) {
        return this.isInitial(s.getId());
    }

    public boolean isInitial(int var1);

    default public boolean isFinal(S s) {
        return this.isFinal(s.getId());
    }

    public boolean isFinal(int var1);

    default public void setInitial(S s) {
        this.setInitial(s.getId());
    }

    public void setInitial(int var1);

    default public void setFinal(S s) {
        this.setFinal(s.getId());
    }

    public void setFinal(int var1);

    public Collection<S> getStates();

    public void makeComplete();

    public int getAlphabetSize();

    public int getTransitionSize();

    default public String toDot() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.getAlphabetSize()) {
                arrayList.add("" + n);
                ++n;
            }
            this.toDot(new PrintStream(byteArrayOutputStream), arrayList);
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "ERROR";
        }
    }

    default public void toDot(PrintStream printStream, List<String> list) {
        printStream.print("digraph {\n");
        Collection<S> collection = this.getStates();
        for (IState object : collection) {
            IntSet intSet = this.getAcceptance().getLabels(object.getId());
            printStream.print("  " + object.getId());
            if (this.isFinal(object.getId())) {
                printStream.print(" [label=\"" + object.getId() + "\", shape = doublecircle");
            } else if (!intSet.isEmpty()) {
                printStream.print(" [label=\"" + object.getId() + " " + String.valueOf(intSet) + "\", shape = box");
            } else {
                printStream.print(", shape = circle");
            }
            printStream.print("];\n");
            object.toDot(printStream, list);
        }
        printStream.print("  " + collection.size() + " [label=\"\", shape = plaintext];\n");
        for (Integer n : this.getInitialStates().iterable()) {
            printStream.print("  " + collection.size() + " -> " + String.valueOf(n) + " [label=\"\"];\n");
        }
        printStream.print("}\n\n");
    }

    public void toATS(PrintStream var1, List<String> var2);

    public boolean isSemiDeterministic();

    public boolean isDeterministic(int var1);
}

