/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;

public abstract class BranchingProcessWriter<LETTER, STATE>
extends GeneralAutomatonPrinter {
    private final Map<LETTER, String> mAlphabet;
    private final Map<Condition<LETTER, STATE>, String> mConditionsMapping;

    public BranchingProcessWriter(PrintWriter printWriter, String string, BranchingProcess<LETTER, STATE> branchingProcess) {
        super(printWriter);
        this.mAlphabet = this.getAlphabetMapping(branchingProcess.getAlphabet());
        this.mConditionsMapping = this.getConditionsMapping(branchingProcess.getConditions());
        this.print("Branching Process ");
        this.print(string);
        this.printAutomatonPrefix();
        this.printAlphabet();
        this.printConditions();
        this.printEvents(branchingProcess);
        this.printInitialConditions(branchingProcess.initialConditions());
        this.printAutomatonSuffix();
        this.finish();
    }

    protected abstract Map<LETTER, String> getAlphabetMapping(Collection<LETTER> var1);

    protected abstract Map<Condition<LETTER, STATE>, String> getConditionsMapping(Collection<Condition<LETTER, STATE>> var1);

    protected final void printElementPrefix(String string) {
        this.print(String.format("\t%s = ", string));
    }

    private void printAlphabet() {
        this.printCollectionPrefix("alphabet");
        this.printValues(this.mAlphabet);
        this.printCollectionSuffix();
    }

    private void printConditions() {
        this.printCollectionPrefix("conditions");
        this.printValues(this.mConditionsMapping);
        this.printCollectionSuffix();
    }

    private void printEvents(BranchingProcess<LETTER, STATE> branchingProcess) {
        this.printlnCollectionPrefix("events");
        for (Event<LETTER, STATE> event : branchingProcess.getEvents()) {
            this.printEvent(event);
        }
        this.printTransitionsSuffix();
        this.print(',');
        this.print(NEW_LINE);
    }

    private void printEvent(Event<LETTER, STATE> event) {
        if (event.getTransition() != null) {
            this.printOneTransitionPrefix();
            this.printMarking(event.getPredecessorConditions());
            this.print(' ');
            this.print(this.mAlphabet.get(event.getTransition().getSymbol()));
            this.print(' ');
            this.printMarking(event.getSuccessorConditions());
            this.printOneTransitionSuffix();
        }
    }

    private void printMarking(Collection<Condition<LETTER, STATE>> collection) {
        this.print('{');
        for (Condition<LETTER, STATE> condition : collection) {
            this.printElement(this.mConditionsMapping.get(condition));
        }
        this.print('}');
    }

    private void printInitialConditions(Collection<Condition<LETTER, STATE>> collection) {
        this.printElementPrefix("initial conditions");
        this.printMarking(collection);
        this.println(',');
    }
}

