/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;

public class DebugMessage {
    private static final TermDirectFormat TERM_FORMAT = new TermDirectFormat();
    private final boolean mTermDirect;
    private final String mMsg;
    private final Object[] mParams;

    public DebugMessage(String string, Object ... objectArray) {
        this(false, string, objectArray);
    }

    public DebugMessage(boolean bl, String string, Object ... objectArray) {
        this.mTermDirect = bl;
        this.mMsg = string;
        this.mParams = objectArray;
    }

    public String toString() {
        MessageFormat messageFormat = new MessageFormat(this.mMsg);
        if (this.mTermDirect) {
            int n = 0;
            while (n < this.mParams.length) {
                if (this.mParams[n] instanceof Term) {
                    messageFormat.setFormatByArgumentIndex(n, TERM_FORMAT);
                }
                ++n;
            }
        }
        return messageFormat.format(this.mParams, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static class TermDirectFormat
    extends Format {
        private static final long serialVersionUID = -6518060753837104534L;

        private TermDirectFormat() {
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer.append(((Term)object).toStringDirect());
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

