/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.ConstantArrayUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.FunctionDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DataRaceAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DataRaceChecker {
    private static final boolean SUPPORT_ARRAY_STRUCT_LHS = true;
    private static final String UNSUPPORTED_MSG = "Race detection currently only supports simple variables and data on heap. Structs and arrays are not yet supported (unless they are on the heap).";
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final MemoryHandler mMemoryHandler;
    private final ITypeHandler mTypeHandler;
    private final TypeSizeAndOffsetComputer mTypeSizeComputer;
    private final TypeSizes mTypeSizes;
    private final ProcedureManager mProcedureManager;
    private final FunctionDeclarations mFunDecl;
    private final boolean mIsPreRun;
    private final Map<String, BoogieType> mRaceIndicators = new HashMap<String, BoogieType>();

    public DataRaceChecker(AuxVarInfoBuilder auxVarInfoBuilder, MemoryHandler memoryHandler, ITypeHandler iTypeHandler, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer, TypeSizes typeSizes, ProcedureManager procedureManager, FunctionDeclarations functionDeclarations, boolean bl) {
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mMemoryHandler = memoryHandler;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizeComputer = typeSizeAndOffsetComputer;
        this.mTypeSizes = typeSizes;
        this.mProcedureManager = procedureManager;
        this.mFunDecl = functionDeclarations;
        this.mIsPreRun = bl;
    }

    public void checkOnRead(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue) {
        if (this.mProcedureManager.isGlobalScope()) {
            return;
        }
        if (DataRaceChecker.isRaceImpossible(lRValue)) {
            return;
        }
        Expression expression = this.createRaceRead();
        DataRaceAnnotation.Race[] raceArray = this.updateRaceIndicator(expressionResultBuilder, iLocation, lRValue, expression, false);
        this.addAssert(expressionResultBuilder, iLocation, lRValue, expression, raceArray);
    }

    private static boolean isUnsupportedArrayOrStruct(LRValue lRValue) {
        if (lRValue instanceof LocalLValue) {
            LocalLValue localLValue = (LocalLValue)lRValue;
            return !(localLValue.getLhs() instanceof VariableLHS);
        }
        return false;
    }

    private Expression createRaceRead() {
        return this.mMemoryHandler.getBooleanArrayHelper().constructFalse();
    }

    public void checkOnWrite(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue) {
        if (this.mProcedureManager.isGlobalScope()) {
            return;
        }
        if (DataRaceChecker.isRaceImpossible(lRValue)) {
            return;
        }
        Expression expression = this.createRaceWrite(expressionResultBuilder, iLocation);
        DataRaceAnnotation.Race[] raceArray = this.updateRaceIndicator(expressionResultBuilder, iLocation, lRValue, expression, true);
        this.addAssert(expressionResultBuilder, iLocation, lRValue, expression, raceArray);
    }

    private Expression createRaceWrite(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation) {
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, this.getBoolASTType(), SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()});
        expressionResultBuilder.addStatement((Statement)havocStatement);
        return auxVarInfo.getExp();
    }

    private DataRaceAnnotation.Race[] updateRaceIndicator(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue, Expression expression, boolean bl) {
        LeftHandSide[] leftHandSideArray = this.getRaceLhs(iLocation, lRValue);
        DataRaceAnnotation.Race[] raceArray = new DataRaceAnnotation.Race[leftHandSideArray.length];
        int n = 0;
        while (n < leftHandSideArray.length) {
            AssignmentStatement assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{leftHandSideArray[n]}, (Expression[])new Expression[]{this.wrapRaceIndicatorValue(iLocation, expression, leftHandSideArray[n].getType())});
            raceArray[n] = DataRaceAnnotation.annotateAccess((IElement)assignmentStatement, (String)DataRaceChecker.getAccessPath(lRValue), (ILocation)iLocation, (boolean)bl);
            expressionResultBuilder.addStatement((Statement)assignmentStatement);
            ++n;
        }
        return raceArray;
    }

    private void addAssert(ExpressionResultBuilder expressionResultBuilder, ILocation iLocation, LRValue lRValue, Expression expression, DataRaceAnnotation.Race[] raceArray) {
        Check check = new Check(Spec.DATA_RACE);
        Expression expression3 = ExpressionFactory.and((ILocation)iLocation, this.getRaceExpressions(iLocation, lRValue).map(expression2 -> ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expression2, (Expression)this.wrapRaceIndicatorValue(iLocation, expression, expression2.getType()))).collect(Collectors.toList()));
        AssertStatement assertStatement = new AssertStatement(iLocation, expression3);
        check.annotate((IElement)assertStatement);
        DataRaceAnnotation.annotateCheck((IElement)assertStatement, (DataRaceAnnotation.Race[])raceArray, (ILocation)iLocation);
        expressionResultBuilder.addStatement((Statement)assertStatement);
    }

    private static String getAccessPath(LRValue lRValue) {
        if (lRValue instanceof LocalLValue) {
            ImmutableList<String> immutableList = DataRaceChecker.getAccessPath(((LocalLValue)lRValue).getLhs());
            if (immutableList == null) {
                return null;
            }
            return immutableList.stream().collect(Collectors.joining("->"));
        }
        return null;
    }

    private static ImmutableList<String> getAccessPath(LeftHandSide leftHandSide) {
        if (leftHandSide instanceof VariableLHS) {
            return ImmutableList.singleton((Object)((VariableLHS)leftHandSide).getIdentifier());
        }
        if (leftHandSide instanceof StructLHS) {
            ImmutableList<String> immutableList = DataRaceChecker.getAccessPath(((StructLHS)leftHandSide).getStruct());
            if (immutableList == null) {
                return null;
            }
            return new ImmutableList((Object)((StructLHS)leftHandSide).getField(), immutableList);
        }
        if (leftHandSide instanceof ArrayLHS) {
            return null;
        }
        throw new IllegalArgumentException("unknown type of LHS: " + String.valueOf(leftHandSide));
    }

    private static boolean isRaceImpossible(LRValue lRValue) {
        if (lRValue.getCType().isAtomic()) {
            return true;
        }
        if (lRValue instanceof HeapLValue) {
            Expression expression = ((HeapLValue)lRValue).getAddress();
            return expression instanceof IdentifierExpression && ((IdentifierExpression)expression).getIdentifier().startsWith("#funAddr~");
        }
        if (!(lRValue instanceof LocalLValue)) {
            return false;
        }
        VariableLHS variableLHS = DataRaceChecker.getRootLhs(((LocalLValue)lRValue).getLhs());
        return switch (variableLHS.getDeclarationInformation().getStorageClass()) {
            case DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, DeclarationInformation.StorageClass.LOCAL, DeclarationInformation.StorageClass.PROC_FUNC -> true;
            case DeclarationInformation.StorageClass.GLOBAL, DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, DeclarationInformation.StorageClass.QUANTIFIED, DeclarationInformation.StorageClass.IMPLEMENTATION -> false;
            default -> throw new MatchException(null, null);
        };
    }

    private static VariableLHS getRootLhs(LeftHandSide leftHandSide) {
        while (!(leftHandSide instanceof VariableLHS)) {
            if (leftHandSide instanceof StructLHS) {
                leftHandSide = ((StructLHS)leftHandSide).getStruct();
                continue;
            }
            if (leftHandSide instanceof ArrayLHS) {
                leftHandSide = ((ArrayLHS)leftHandSide).getArray();
                continue;
            }
            throw new IllegalArgumentException("unknown type of LHS: " + String.valueOf(leftHandSide));
        }
        return (VariableLHS)leftHandSide;
    }

    private LeftHandSide[] getRaceLhs(ILocation iLocation, LRValue lRValue) {
        if (lRValue instanceof HeapLValue) {
            HeapLValue heapLValue = (HeapLValue)lRValue;
            VariableLHS variableLHS = this.mMemoryHandler.getMemoryRaceArrayLhs(iLocation);
            LeftHandSide[] leftHandSideArray = new LeftHandSide[this.getTypeSize(iLocation, heapLValue.getUnderlyingType())];
            int n = 0;
            while (n < leftHandSideArray.length) {
                Expression expression = this.mMemoryHandler.addIntegerConstantToPointer(iLocation, heapLValue.getAddress(), BigInteger.valueOf(n));
                leftHandSideArray[n] = ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression[])new Expression[]{expression});
                ++n;
            }
            return leftHandSideArray;
        }
        if (lRValue instanceof LocalLValue) {
            return new LeftHandSide[]{this.getRaceIndicatorLhs(iLocation, (LocalLValue)lRValue)};
        }
        throw new UnsupportedOperationException();
    }

    private Stream<Expression> getRaceExpressions(ILocation iLocation, LRValue lRValue) {
        return Arrays.stream(this.getRaceLhs(iLocation, lRValue)).map(CTranslationUtil::convertLhsToExpression);
    }

    private int getTypeSize(ILocation iLocation, ICType iCType) {
        Expression expression = this.mTypeSizeComputer.constructBytesizeExpression(iLocation, iCType);
        return this.mTypeSizes.extractIntegerValue(expression, this.mTypeSizeComputer.getSizeT()).intValueExact();
    }

    private LeftHandSide getRaceIndicatorLhs(ILocation iLocation, LocalLValue localLValue) {
        return this.createRaceIndicatorLhs(iLocation, localLValue.getLhs());
    }

    private LeftHandSide createRaceIndicatorLhs(ILocation iLocation, LeftHandSide leftHandSide) {
        if (leftHandSide instanceof VariableLHS) {
            String string = "#race" + ((VariableLHS)leftHandSide).getIdentifier();
            VariableLHS variableLHS = new VariableLHS(iLocation, (IBoogieType)this.getRaceIndicatorType(leftHandSide.getType()), string, DeclarationInformation.DECLARATIONINFO_GLOBAL);
            assert (this.mRaceIndicators.getOrDefault(string, (BoogieType)variableLHS.getType()).equals((Object)variableLHS.getType())) : "Ambiguous types for " + string + ": " + String.valueOf(this.mRaceIndicators.get(string)) + " vs. " + String.valueOf(variableLHS.getType());
            this.mRaceIndicators.put(string, (BoogieType)variableLHS.getType());
            return variableLHS;
        }
        if (leftHandSide instanceof ArrayLHS) {
            LeftHandSide leftHandSide2 = this.createRaceIndicatorLhs(iLocation, ((ArrayLHS)leftHandSide).getArray());
            return ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)leftHandSide2, (Expression[])((ArrayLHS)leftHandSide).getIndices());
        }
        if (leftHandSide instanceof StructLHS) {
            LeftHandSide leftHandSide3 = this.createRaceIndicatorLhs(iLocation, ((StructLHS)leftHandSide).getStruct());
            return ExpressionFactory.constructStructAccessLhs((ILocation)iLocation, (LeftHandSide)leftHandSide3, (String)((StructLHS)leftHandSide).getField());
        }
        throw new UnsupportedOperationException("Cannot detect races for " + String.valueOf(leftHandSide));
    }

    private BoogieType getRaceIndicatorType(IBoogieType iBoogieType) {
        if (iBoogieType instanceof BoogiePrimitiveType || iBoogieType.equals(this.mTypeHandler.getBoogiePointerType())) {
            return this.getBoolType();
        }
        if (iBoogieType instanceof BoogieArrayType) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)iBoogieType;
            assert (boogieArrayType.getNumPlaceholders() == 0);
            BoogieType[] boogieTypeArray = new BoogieType[boogieArrayType.getIndexCount()];
            int n = 0;
            while (n < boogieTypeArray.length) {
                boogieTypeArray[n] = boogieArrayType.getIndexType(n);
                ++n;
            }
            return BoogieType.createArrayType((int)0, (BoogieType[])boogieTypeArray, (BoogieType)this.getRaceIndicatorType((IBoogieType)boogieArrayType.getValueType()));
        }
        if (iBoogieType instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)iBoogieType;
            BoogieType[] boogieTypeArray = (BoogieType[])Arrays.stream(boogieStructType.getFieldTypes()).map(this::getRaceIndicatorType).toArray(BoogieType[]::new);
            return BoogieType.createStructType((String[])boogieStructType.getFieldIds(), (BoogieType[])boogieTypeArray);
        }
        throw new UnsupportedOperationException("Cannot detect races for values of type " + String.valueOf(iBoogieType));
    }

    private Expression wrapRaceIndicatorValue(ILocation iLocation, Expression expression, IBoogieType iBoogieType) {
        if (iBoogieType instanceof BoogiePrimitiveType || iBoogieType.equals(this.mTypeHandler.getBoogiePointerType())) {
            return expression;
        }
        if (iBoogieType instanceof BoogieArrayType) {
            return ConstantArrayUtil.getConstantArray(this.mFunDecl, iLocation, (BoogieArrayType)iBoogieType, expression);
        }
        if (iBoogieType instanceof BoogieStructType) {
            BoogieStructType boogieStructType = (BoogieStructType)iBoogieType;
            Expression[] expressionArray = (Expression[])Arrays.stream(boogieStructType.getFieldTypes()).map(boogieType -> this.wrapRaceIndicatorValue(iLocation, expression, (IBoogieType)boogieType)).toArray(Expression[]::new);
            return ExpressionFactory.constructStructConstructor((ILocation)iLocation, (String[])boogieStructType.getFieldIds(), (Expression[])expressionArray);
        }
        throw new UnsupportedOperationException("Cannot detect races for values of type " + String.valueOf(iBoogieType));
    }

    public Collection<Declaration> declareRaceCheckingInfrastructure(ILocation iLocation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        arrayList.add(this.constructMemoryRaceArrayDeclaration(iLocation));
        for (Map.Entry<String, BoogieType> entry : this.mRaceIndicators.entrySet()) {
            VarList varList = new VarList(iLocation, new String[]{entry.getKey()}, entry.getValue().toASTType(iLocation));
            arrayList.add((Declaration)new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList}));
        }
        return arrayList;
    }

    private Declaration constructMemoryRaceArrayDeclaration(ILocation iLocation) {
        BoogieArrayType boogieArrayType = BoogieType.createArrayType((int)0, (BoogieType[])new BoogieType[]{this.mTypeHandler.getBoogiePointerType()}, (BoogieType)this.getBoolType());
        ArrayType arrayType = new ArrayType(iLocation, (IBoogieType)boogieArrayType, new String[0], new ASTType[]{this.mTypeHandler.constructPointerType(iLocation)}, this.getBoolASTType());
        VarList varList = new VarList(iLocation, new String[]{MemoryModelDeclarations.ULTIMATE_DATA_RACE_MEMORY.getName()}, (ASTType)arrayType);
        return new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList});
    }

    private ASTType getBoolASTType() {
        return this.mMemoryHandler.getBooleanArrayHelper().constructBoolReplacementType();
    }

    private BoogieType getBoolType() {
        return this.mTypeHandler.getBoogieTypeForBoogieASTType(this.getBoolASTType());
    }
}

