/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePlaceholderType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;

public class BoogieArrayType
extends BoogieType {
    private static final long serialVersionUID = -8089266195576415316L;
    private final int numPlaceholders;
    private final BoogieType[] indexTypes;
    private final BoogieType valueType;
    private final BoogieType realType;
    private final boolean isFinite;

    BoogieArrayType(int n, BoogieType[] boogieTypeArray, BoogieType boogieType) {
        this.numPlaceholders = n;
        this.indexTypes = boogieTypeArray;
        this.valueType = boogieType;
        boolean bl = false;
        BoogieType boogieType2 = boogieType.getUnderlyingType();
        if (boogieType2 != boogieType) {
            bl = true;
        }
        BoogieType[] boogieTypeArray2 = new BoogieType[boogieTypeArray.length];
        int n2 = 0;
        while (n2 < boogieTypeArray2.length) {
            boogieTypeArray2[n2] = boogieTypeArray[n2].getUnderlyingType();
            if (boogieTypeArray2[n2] != boogieTypeArray[n2]) {
                bl = true;
            }
            ++n2;
        }
        this.realType = bl ? BoogieArrayType.createArrayType(n, boogieTypeArray2, boogieType2) : this;
        n2 = boogieType2.isFinite() ? 1 : 0;
        BoogieType[] boogieTypeArray3 = boogieTypeArray2;
        int n3 = boogieTypeArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            BoogieType boogieType3 = boogieTypeArray3[n4];
            n2 &= boogieType3.isFinite();
            ++n4;
        }
        this.isFinite = n2;
    }

    @Override
    protected BoogieType substitutePlaceholders(int n, BoogieType[] boogieTypeArray) {
        boolean bl = false;
        BoogieType boogieType = this.valueType.substitutePlaceholders(n += this.numPlaceholders, boogieTypeArray);
        if (boogieType != this.valueType) {
            bl = true;
        }
        BoogieType[] boogieTypeArray2 = new BoogieType[this.indexTypes.length];
        int n2 = 0;
        while (n2 < this.indexTypes.length) {
            boogieTypeArray2[n2] = this.indexTypes[n2].substitutePlaceholders(n, boogieTypeArray);
            if (boogieTypeArray2[n2] != this.indexTypes[n2]) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            return BoogieArrayType.createArrayType(this.numPlaceholders, boogieTypeArray2, boogieType);
        }
        return this;
    }

    @Override
    protected BoogieType incrementPlaceholders(int n, int n2) {
        boolean bl = false;
        BoogieType boogieType = this.valueType.incrementPlaceholders(n += this.numPlaceholders, n2);
        if (boogieType != this.valueType) {
            bl = true;
        }
        BoogieType[] boogieTypeArray = new BoogieType[this.indexTypes.length];
        int n3 = 0;
        while (n3 < this.indexTypes.length) {
            boogieTypeArray[n3] = this.indexTypes[n3].incrementPlaceholders(n, n2);
            if (boogieTypeArray[n3] != this.indexTypes[n3]) {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            return BoogieArrayType.createArrayType(this.numPlaceholders, boogieTypeArray, boogieType);
        }
        return this;
    }

    @Override
    public BoogieType getUnderlyingType() {
        return this.realType;
    }

    public int getNumPlaceholders() {
        return this.numPlaceholders;
    }

    public int getIndexCount() {
        return this.indexTypes.length;
    }

    public BoogieType getIndexType(int n) {
        return this.indexTypes[n];
    }

    public BoogieType getValueType() {
        return this.valueType;
    }

    @Override
    protected boolean unify(int n, BoogieType boogieType, BoogieType[] boogieTypeArray) {
        if (boogieType == TYPE_ERROR) {
            return true;
        }
        if (!(boogieType instanceof BoogieArrayType)) {
            return false;
        }
        BoogieArrayType boogieArrayType = (BoogieArrayType)boogieType;
        if (boogieArrayType.numPlaceholders != this.numPlaceholders || boogieArrayType.indexTypes.length != this.indexTypes.length) {
            return false;
        }
        n += this.numPlaceholders;
        int n2 = 0;
        while (n2 < this.indexTypes.length) {
            if (!this.indexTypes[n2].unify(n, boogieArrayType.indexTypes[n2], boogieTypeArray)) {
                return false;
            }
            ++n2;
        }
        return this.valueType.unify(n, boogieArrayType.valueType, boogieTypeArray);
    }

    @Override
    protected boolean hasPlaceholder(int n, int n2) {
        n += this.numPlaceholders;
        n2 += this.numPlaceholders;
        BoogieType[] boogieTypeArray = this.indexTypes;
        int n3 = this.indexTypes.length;
        int n4 = 0;
        while (n4 < n3) {
            BoogieType boogieType = boogieTypeArray[n4];
            if (boogieType.hasPlaceholder(n, n2)) {
                return true;
            }
            ++n4;
        }
        return this.valueType.hasPlaceholder(n, n2);
    }

    @Override
    protected boolean isUnifiableTo(int n, BoogieType boogieType, ArrayList<BoogieType> arrayList) {
        if (this == boogieType || boogieType == TYPE_ERROR) {
            return true;
        }
        if (boogieType instanceof BoogiePlaceholderType) {
            return boogieType.isUnifiableTo(n, this, arrayList);
        }
        if (!(boogieType instanceof BoogieArrayType)) {
            return false;
        }
        BoogieArrayType boogieArrayType = (BoogieArrayType)boogieType;
        if (boogieArrayType.numPlaceholders != this.numPlaceholders || boogieArrayType.indexTypes.length != this.indexTypes.length) {
            return false;
        }
        n += this.numPlaceholders;
        int n2 = 0;
        while (n2 < this.indexTypes.length) {
            if (!this.indexTypes[n2].isUnifiableTo(n, boogieArrayType.indexTypes[n2], arrayList)) {
                return false;
            }
            ++n2;
        }
        return this.valueType.isUnifiableTo(n, boogieArrayType.valueType, arrayList);
    }

    @Override
    protected String toString(int n, boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("(");
        }
        if (this.numPlaceholders > 0) {
            stringBuilder.append("<");
            string = "";
            int n2 = 0;
            while (n2 < this.numPlaceholders) {
                stringBuilder.append(string).append("$" + (n + n2));
                string = ",";
                ++n2;
            }
            stringBuilder.append(">");
        }
        stringBuilder.append("[");
        string = "";
        BoogieType[] boogieTypeArray = this.indexTypes;
        int n3 = this.indexTypes.length;
        int n4 = 0;
        while (n4 < n3) {
            BoogieType boogieType = boogieTypeArray[n4];
            stringBuilder.append(string).append(boogieType.toString(n + this.numPlaceholders, false));
            string = ",";
            ++n4;
        }
        stringBuilder.append("]");
        stringBuilder.append(this.valueType.toString(n + this.numPlaceholders, false));
        if (bl) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    protected ASTType toASTType(ILocation iLocation, int n) {
        String[] stringArray = new String[this.numPlaceholders];
        int n2 = 0;
        while (n2 < this.numPlaceholders) {
            stringArray[n2] = "$" + (n + n2);
            ++n2;
        }
        ASTType[] aSTTypeArray = new ASTType[this.indexTypes.length];
        int n3 = 0;
        while (n3 < this.indexTypes.length) {
            aSTTypeArray[n3] = this.indexTypes[n3].toASTType(iLocation, n + this.numPlaceholders);
            ++n3;
        }
        ASTType aSTType = this.valueType.toASTType(iLocation, n + this.numPlaceholders);
        return new ArrayType(iLocation, this, stringArray, aSTTypeArray, aSTType);
    }

    @Override
    public boolean isFinite() {
        return this.isFinite;
    }
}

