/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.AbstractAnnotations;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.IndexedStatement;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVar;
import java.util.HashMap;
import java.util.HashSet;

public abstract class ReachDefBaseAnnotation
extends AbstractAnnotations {
    private static final long serialVersionUID = 1L;

    protected String[] getFieldNames() {
        return new String[]{"Def", "Use"};
    }

    protected Object getFieldValue(String string) {
        switch (string) {
            case "Def": {
                return this.prettyPrintDefUse(this.getDefs());
            }
            case "Use": {
                return this.prettyPrintDefUse(this.getUse());
            }
        }
        return null;
    }

    protected abstract HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> getDefs();

    protected abstract HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> getUse();

    private String prettyPrintDefUse(HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap) {
        if (hashMap.isEmpty()) {
            return "Empty";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ScopedBoogieVar scopedBoogieVar : hashMap.keySet()) {
            stringBuilder.append(scopedBoogieVar.getIdentifier()).append(": {");
            HashSet<IndexedStatement> hashSet = hashMap.get(scopedBoogieVar);
            if (hashSet.isEmpty()) continue;
            for (IndexedStatement indexedStatement : hashMap.get(scopedBoogieVar)) {
                if (indexedStatement.getKey() != null) {
                    stringBuilder.append(indexedStatement.getKey()).append(" ");
                }
                stringBuilder.append(BoogiePrettyPrinter.print((Statement)indexedStatement.getStatement())).append(", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            stringBuilder.append("}, ");
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getDefs().hashCode() + 131 * this.getUse().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ReachDefBaseAnnotation reachDefBaseAnnotation = (ReachDefBaseAnnotation)((Object)object);
        return this.compareMap(this.getDefs(), reachDefBaseAnnotation.getDefs()) && this.compareMap(this.getUse(), reachDefBaseAnnotation.getUse());
    }

    private boolean compareMap(HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap, HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap2) {
        if (hashMap != null && hashMap2 != null) {
            for (ScopedBoogieVar scopedBoogieVar : hashMap.keySet()) {
                HashSet<IndexedStatement> hashSet = hashMap.get(scopedBoogieVar);
                HashSet<IndexedStatement> hashSet2 = hashMap2.get(scopedBoogieVar);
                if (hashSet != null && hashSet2 != null && hashSet.size() == hashSet2.size()) {
                    for (IndexedStatement indexedStatement : hashSet) {
                        if (hashSet2.contains(indexedStatement)) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return "Def: " + this.getDefAsString() + " Use: " + this.getUseAsString();
    }

    public String getDefAsString() {
        return this.prettyPrintDefUse(this.getDefs());
    }

    public String getUseAsString() {
        return this.prettyPrintDefUse(this.getUse());
    }

    protected HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> copy(HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap) {
        if (hashMap == null) {
            return null;
        }
        HashMap<ScopedBoogieVar, HashSet<IndexedStatement>> hashMap2 = new HashMap<ScopedBoogieVar, HashSet<IndexedStatement>>();
        for (ScopedBoogieVar scopedBoogieVar : hashMap.keySet()) {
            HashSet<IndexedStatement> hashSet = hashMap.get(scopedBoogieVar);
            if (hashSet == null) continue;
            HashSet<IndexedStatement> hashSet2 = new HashSet<IndexedStatement>(hashSet);
            hashMap2.put(scopedBoogieVar, hashSet2);
        }
        return hashMap2;
    }
}

