/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.SuffixedDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AddInitializingEdgesIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final BasicIcfg<OUTLOC> mResultIcfg;
    final TransformedIcfgBuilder<INLOC, OUTLOC> mBuilder;
    private final UnmodifiableTransFormula mInitializingTransformula;
    private final IIcfg<INLOC> mInputIcfg;

    public AddInitializingEdgesIcfgTransformer(ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, IIcfg<INLOC> iIcfg, UnmodifiableTransFormula unmodifiableTransFormula, String string) {
        this.mInitializingTransformula = unmodifiableTransFormula;
        IdentityTransformer identityTransformer = new IdentityTransformer(cfgSmtToolkit);
        this.mResultIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        this.mBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(iLogger, iLocationFactory, icfgTransformationBacktranslator, identityTransformer, iIcfg, this.mResultIcfg);
        this.mInputIcfg = iIcfg;
        this.process(iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz);
    }

    private void process(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz) {
        this.processLocationsOmitInitEdges(iIcfg.getInitialNodes(), this.mBuilder);
        this.mBuilder.finish();
    }

    private void processLocationsOmitInitEdges(Set<INLOC> set, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder) {
        IcfgLocation icfgLocation;
        Object object2;
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        HashRelation hashRelation = new HashRelation();
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(set);
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation icfgLocation2 = icfgLocationIterator.next();
            block1: for (IcfgEdge icfgEdge2 : icfgLocation2.getOutgoingEdges()) {
                if (set.contains(icfgLocation2)) {
                    hashSet.add(icfgEdge2);
                    continue;
                }
                for (Object object2 : icfgLocation2.getIncomingEdges()) {
                    if (!set.contains(object2.getSource())) continue;
                    hashRelation.addPair(object2, (Object)icfgEdge2);
                    continue block1;
                }
                object2 = transformedIcfgBuilder.createNewLocation((IcfgLocation)icfgEdge2.getTarget());
                icfgLocation = transformedIcfgBuilder.createNewLocation(icfgLocation2);
                if (icfgEdge2 instanceof IIcfgReturnTransition) {
                    arrayList.add(new Triple((Object)icfgLocation, object2, (Object)icfgEdge2));
                    continue;
                }
                transformedIcfgBuilder.createNewTransition(icfgLocation, (IcfgLocation)object2, icfgEdge2);
            }
        }
        assert (hashSet.stream().map(icfgEdge -> (IcfgLocation)icfgEdge.getTarget()).collect(Collectors.toSet()).size() == hashSet.size()) : "two init edges leading to the same location??";
        for (IcfgEdge icfgEdge3 : hashSet) {
            IcfgEdge icfgEdge4;
            IcfgLocation icfgLocation3;
            if (icfgEdge3 instanceof IcfgCallTransition) {
                icfgLocation3 = (IcfgLocation)icfgEdge3.getTarget();
                assert (icfgLocation3.getIncomingEdges().size() == 1);
                object2 = this.mBuilder.createNewLocation((IcfgLocation)icfgEdge3.getSource());
                icfgLocation = icfgEdge3.getSucceedingProcedure();
                icfgEdge4 = this.splitLocation((INLOC)icfgLocation3, (String)icfgLocation);
                this.mBuilder.createNewTransition((IcfgLocation)object2, (IcfgLocation)icfgEdge4.getFirst(), icfgEdge3);
                this.mBuilder.createNewInternalTransition((IcfgLocation)icfgEdge4.getFirst(), (IcfgLocation)icfgEdge4.getSecond(), this.mInitializingTransformula, false);
                for (IcfgEdge icfgEdge5 : hashRelation.getImage((Object)icfgEdge3)) {
                    this.mBuilder.createNewTransition((IcfgLocation)icfgEdge4.getSecond(), (IcfgLocation)this.mBuilder.createNewLocation((IcfgLocation)icfgEdge5.getTarget()), icfgEdge5);
                }
                continue;
            }
            if (icfgEdge3 instanceof IcfgInternalTransition) {
                IcfgEdge icfgEdge5;
                icfgLocation3 = (IcfgLocation)icfgEdge3.getSource();
                object2 = (IcfgLocation)icfgEdge3.getTarget();
                icfgLocation = this.splitLocation(icfgLocation3, icfgEdge3.getSucceedingProcedure());
                this.mBuilder.createNewInternalTransition((IcfgLocation)icfgLocation.getFirst(), (IcfgLocation)icfgLocation.getSecond(), this.mInitializingTransformula, false);
                this.mBuilder.createNewTransition((IcfgLocation)icfgLocation.getSecond(), (IcfgLocation)this.mBuilder.createNewLocation((IcfgLocation)object2), icfgEdge3);
                icfgEdge5 = hashRelation.getImage((Object)icfgEdge3).iterator();
                while (icfgEdge5.hasNext()) {
                    icfgEdge4 = (IcfgEdge)icfgEdge5.next();
                    this.mBuilder.createNewTransition(this.mBuilder.createNewLocation((IcfgLocation)object2), this.mBuilder.createNewLocation((IcfgLocation)icfgEdge4.getTarget()), icfgEdge4);
                }
                continue;
            }
            throw new AssertionError((Object)"init edge is neither call nor internal transition");
        }
        arrayList.forEach(triple -> {
            IcfgEdge icfgEdge = transformedIcfgBuilder.createNewTransition((IcfgLocation)triple.getFirst(), (IcfgLocation)triple.getSecond(), (IcfgEdge)triple.getThird());
        });
    }

    private Pair<OUTLOC, OUTLOC> splitLocation(INLOC INLOC, String string) {
        boolean bl = this.mInputIcfg.getLocationsOfInterest().contains(INLOC);
        boolean bl2 = !this.mInputIcfg.getProcedureEntryNodes().isEmpty() && ((IcfgLocation)this.mInputIcfg.getProcedureEntryNodes().get(string)).equals(INLOC);
        OUTLOC OUTLOC = this.createAndAddNewLocation(INLOC, this.mInputIcfg.getInitialNodes().contains(INLOC), false, bl2, false, false, (DebugIdentifier)new SuffixedDebugIdentifier(INLOC.getDebugIdentifier(), "_split-1"), bl);
        boolean bl3 = !this.mInputIcfg.getProcedureExitNodes().isEmpty() && ((IcfgLocation)this.mInputIcfg.getProcedureExitNodes().get(string)).equals(INLOC);
        OUTLOC OUTLOC2 = this.createAndAddNewLocation(INLOC, false, ((Set)this.mInputIcfg.getProcedureErrorNodes().get(string)).contains(INLOC), false, bl3, this.mInputIcfg.getLoopLocations().contains(INLOC), (DebugIdentifier)new SuffixedDebugIdentifier(INLOC.getDebugIdentifier(), "_split-2"), bl);
        Pair pair = new Pair(OUTLOC, OUTLOC2);
        return pair;
    }

    private OUTLOC createAndAddNewLocation(INLOC INLOC, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, DebugIdentifier debugIdentifier, boolean bl6) {
        BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, INLOC.getProcedure(), false, ((BoogieIcfgLocation)INLOC).getBoogieASTNode());
        this.mResultIcfg.addLocation((IcfgLocation)boogieIcfgLocation, bl, bl2, bl3, bl4, bl5, bl6);
        return (OUTLOC)boogieIcfgLocation;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

