/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.AutomatonFreeRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementStrategy;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class ConditionalCommutativityChecker<L extends IAction> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final IIndependenceRelation<IPredicate, L> mIndependenceRelation;
    private final ISymbolicIndependenceRelation<L, IPredicate> mSymbolicRelation;
    private final boolean mPassContextToSymbolicRelation;
    private final PredicateFactory mPredicateFactory;
    private final ICopyActionFactory<L> mCopyFactory;
    private final Function<Counterexample<L>, IRefinementStrategy<L>> mBuildStrategy;
    private final Statistics mStatistics = new Statistics();

    public ConditionalCommutativityChecker(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IIndependenceRelation<IPredicate, L> iIndependenceRelation, Function<Counterexample<L>, IRefinementStrategy<L>> function, PredicateFactory predicateFactory, ICopyActionFactory<L> iCopyActionFactory) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mManagedScript = managedScript;
        this.mIndependenceRelation = iIndependenceRelation;
        this.mSymbolicRelation = this.mIndependenceRelation.getSymbolicRelation();
        if (this.mSymbolicRelation == null) {
            throw new UnsupportedOperationException("Given independence relation does not offer a symbolic counterpart");
        }
        this.mPassContextToSymbolicRelation = this.mSymbolicRelation.isConditional();
        this.mBuildStrategy = function;
        this.mPredicateFactory = predicateFactory;
        this.mCopyFactory = iCopyActionFactory;
    }

    public Result<L> checkConditionalCommutativity(Word<L> word, List<?> list, IPredicate iPredicate, L l, L l2) {
        this.mStatistics.startCheck();
        try {
            Result<L> result = this.checkConditionalCommutativityInternal(word, list, iPredicate, l, l2);
            return result;
        }
        finally {
            this.mStatistics.stopCheck();
        }
    }

    private Result<L> checkConditionalCommutativityInternal(Word<L> word, List<?> list, IPredicate iPredicate, L l, L l2) {
        IIndependenceRelation.Dependence dependence = this.mIndependenceRelation.isIndependent((Object)iPredicate, l, l2);
        if (dependence == IIndependenceRelation.Dependence.INDEPENDENT) {
            return new Result(ResultType.ALREADY_INDEPENDENT);
        }
        IPredicate iPredicate2 = this.generateCondition(iPredicate, l, l2);
        if (iPredicate2 == null) {
            return new Result(ResultType.NO_CONDITION_FOUND);
        }
        return this.proveCommutativityCondition(word, list, l, iPredicate2);
    }

    private IPredicate generateCondition(IPredicate iPredicate, L l, L l2) {
        this.mStatistics.startConditionCalculation();
        try {
            if (this.mPassContextToSymbolicRelation && iPredicate != null) {
                IPredicate iPredicate2 = (IPredicate)this.mSymbolicRelation.getCommutativityCondition((Object)iPredicate, l, l2);
                return iPredicate2;
            }
            IPredicate iPredicate3 = (IPredicate)this.mSymbolicRelation.getCommutativityCondition(null, l, l2);
            return iPredicate3;
        }
        finally {
            this.mStatistics.stopConditionCalculation();
        }
    }

    private Result<L> proveCommutativityCondition(Word<L> word, List<?> list, L l, IPredicate iPredicate) {
        IPredicate iPredicate2 = this.mPredicateFactory.not(iPredicate);
        UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaBuilder.constructTransFormulaFromPredicate((IPredicate)iPredicate2, (ManagedScript)this.mManagedScript);
        if (!QuantifierUtils.isQuantifierFree((Term)unmodifiableTransFormula.getFormula())) {
            this.mStatistics.reportQuantifiedCondition();
            this.mLogger.warn("Quantified commutativity condition: %s", new Object[]{unmodifiableTransFormula.getFormula()});
        }
        L l2 = this.mCopyFactory.copy(l, unmodifiableTransFormula, null);
        Word word2 = word.concatenate(new Word((Object[])new IAction[]{l2}));
        ArrayList arrayList = new ArrayList(list);
        arrayList.add(new Object());
        Counterexample counterexample = new Counterexample(word2, arrayList);
        IRefinementStrategy<L> iRefinementStrategy = this.mBuildStrategy.apply(counterexample);
        AutomatonFreeRefinementEngine automatonFreeRefinementEngine = new AutomatonFreeRefinementEngine(this.mServices, this.mLogger, iRefinementStrategy);
        IRefinementEngineResult iRefinementEngineResult = automatonFreeRefinementEngine.getResult();
        this.mStatistics.reportTraceCheck(iRefinementEngineResult);
        return switch (iRefinementEngineResult.getCounterexampleFeasibility()) {
            case Script.LBool.UNKNOWN -> new Result(ResultType.UNKNOWN_CHECK);
            case Script.LBool.SAT -> new Result(ResultType.CONDITION_NOT_SATISFIED);
            case Script.LBool.UNSAT -> {
                if (!iRefinementEngineResult.somePerfectSequenceFound()) {
                    yield new Result(ResultType.PROOF_IMPERFECT);
                }
                yield new Result<L>(this.postProcessRefinementResult(iRefinementEngineResult));
            }
            default -> throw new MatchException(null, null);
        };
    }

    private IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> postProcessRefinementResult(IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> iRefinementEngineResult) {
        QualifiedTracePredicates qualifiedTracePredicates2;
        HashMap<QualifiedTracePredicates, QualifiedTracePredicates> hashMap = new HashMap<QualifiedTracePredicates, QualifiedTracePredicates>();
        ArrayList<QualifiedTracePredicates> arrayList = new ArrayList<QualifiedTracePredicates>();
        for (QualifiedTracePredicates qualifiedTracePredicates2 : (Collection)iRefinementEngineResult.getInfeasibilityProof()) {
            QualifiedTracePredicates qualifiedTracePredicates3 = hashMap.computeIfAbsent(qualifiedTracePredicates2, ConditionalCommutativityChecker::postProcessPredicates);
            arrayList.add(qualifiedTracePredicates3);
        }
        qualifiedTracePredicates2 = new ArrayList();
        for (QualifiedTracePredicates qualifiedTracePredicates4 : iRefinementEngineResult.getUsedTracePredicates()) {
            QualifiedTracePredicates qualifiedTracePredicates5 = hashMap.computeIfAbsent(qualifiedTracePredicates4, ConditionalCommutativityChecker::postProcessPredicates);
            qualifiedTracePredicates2.add(qualifiedTracePredicates5);
        }
        return new IRefinementEngineResult.BasicRefinementEngineResult(iRefinementEngineResult.getCounterexampleFeasibility(), arrayList, null, iRefinementEngineResult.somePerfectSequenceFound(), (List)qualifiedTracePredicates2, new Lazy(() -> iRefinementEngineResult.getHoareTripleChecker()), new Lazy(() -> iRefinementEngineResult.getPredicateUnifier()));
    }

    private static QualifiedTracePredicates postProcessPredicates(QualifiedTracePredicates qualifiedTracePredicates) {
        int n = qualifiedTracePredicates.getPredicates().size();
        IPredicate iPredicate = (IPredicate)qualifiedTracePredicates.getPredicates().get(n - 1);
        ArrayList arrayList = new ArrayList(qualifiedTracePredicates.getPredicates().subList(0, n - 1));
        TracePredicates tracePredicates = new TracePredicates(qualifiedTracePredicates.getTracePredicates().getPrecondition(), iPredicate, arrayList);
        return new QualifiedTracePredicates(tracePredicates, qualifiedTracePredicates.getOrigin(), qualifiedTracePredicates.isPerfect());
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public static final class Result<L extends IAction> {
        private final ResultType mType;
        private final IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> mRefinementResult;

        private Result(ResultType resultType) {
            this.mType = resultType;
            this.mRefinementResult = null;
            assert (!this.isSuccess()) : "successful result must have refinement result";
        }

        private Result(IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> iRefinementEngineResult) {
            this.mType = ResultType.SUCCESS;
            this.mRefinementResult = Objects.requireNonNull(iRefinementEngineResult);
        }

        public boolean isSuccess() {
            return this.mType == ResultType.SUCCESS;
        }

        public ResultType getType() {
            return this.mType;
        }

        public IRefinementEngineResult<L, Collection<QualifiedTracePredicates>> getRefinementResult() {
            assert (this.mRefinementResult != null) : "No proof of commutativity found";
            return this.mRefinementResult;
        }
    }

    public static enum ResultType {
        ALREADY_INDEPENDENT,
        NO_CONDITION_FOUND,
        CONDITION_NOT_SATISFIED,
        UNKNOWN_CHECK,
        PROOF_IMPERFECT,
        SUCCESS;

    }

    private static class Statistics
    extends AbstractStatisticsDataProvider {
        private final TimeTracker mOverallTime = new TimeTracker();
        private final TimeTracker mConditionCalculationTime = new TimeTracker();
        private int mConditionCalculations;
        private int mQuantifiedConditions;
        private int mTraceChecks;
        private int mUnknownTraceChecks;
        private int mUnsatisfiedConditions;
        private int mImperfectProofs;

        public Statistics() {
            this.declareTimeTracker("CheckTime", this.mOverallTime);
            this.declareTimeTracker("ConditionCalculationTime", this.mConditionCalculationTime);
            this.declareCounter("ConditionCalculations", () -> this.mConditionCalculations);
            this.declareCounter("QuantifiedConditions", () -> this.mQuantifiedConditions);
            this.declareCounter("TraceChecks", () -> this.mTraceChecks);
            this.declareCounter("UnknownTraceChecks", () -> this.mUnknownTraceChecks);
            this.declareCounter("UnsatisfiedConditions", () -> this.mUnsatisfiedConditions);
            this.declareCounter("ImperfectProofs", () -> this.mImperfectProofs);
        }

        private void startCheck() {
            this.mOverallTime.start();
        }

        private void stopCheck() {
            this.mOverallTime.stop();
        }

        private void startConditionCalculation() {
            ++this.mConditionCalculations;
            this.mConditionCalculationTime.start();
        }

        private void stopConditionCalculation() {
            this.mConditionCalculationTime.stop();
        }

        private void reportQuantifiedCondition() {
            ++this.mQuantifiedConditions;
        }

        private void reportTraceCheck(IRefinementEngineResult<?, ?> iRefinementEngineResult) {
            ++this.mTraceChecks;
            Script.LBool lBool = iRefinementEngineResult.getCounterexampleFeasibility();
            if (lBool == Script.LBool.UNKNOWN) {
                ++this.mUnknownTraceChecks;
            } else if (lBool == Script.LBool.SAT) {
                ++this.mUnsatisfiedConditions;
            } else if (lBool == Script.LBool.UNSAT && !iRefinementEngineResult.somePerfectSequenceFound()) {
                ++this.mImperfectProofs;
            }
        }
    }
}

