/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.translation;

import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IToString;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;

public class AtomicTraceElement<TE> {
    private final TE mElement;
    private final TE mStep;
    private final IToString<TE> mToStringFunc;
    private final EnumSet<StepInfo> mStepInfo;
    private final IRelevanceInformation mRelevanceInformation;
    private final String mPrecedingProcedure;
    private final String mSucceedingProcedure;
    private final Integer mThreadId;
    private final Integer mForkedThreadId;
    private final Integer mJoinedThreadId;

    private AtomicTraceElement(TE TE, TE TE2, EnumSet<StepInfo> enumSet, IToString<TE> iToString, IRelevanceInformation iRelevanceInformation, String string, String string2, Integer n, Integer n2, Integer n3) {
        assert (TE != null);
        assert (TE2 != null);
        assert (enumSet != null);
        assert (iToString != null);
        assert (enumSet.size() <= 1 || !enumSet.contains((Object)StepInfo.NONE)) : "You cannot combine NONE with other values: " + String.valueOf(TE);
        assert (!enumSet.isEmpty());
        assert (!enumSet.contains((Object)StepInfo.FORK) || n2 != null) : "If this step is a fork, you must have a forked thread id: " + String.valueOf(TE);
        assert (!enumSet.contains((Object)StepInfo.JOIN) || n3 != null) : "If this step is a join, you must have a joined thread id: " + String.valueOf(TE);
        assert (AtomicTraceElement.hasAnyStepInfo(enumSet, StepInfo.PROC_CALL, StepInfo.PROC_RETURN) || n != null || Objects.equals(string, string2)) : "You must have same procedures except when you have threads or when this is a call or a return: " + String.valueOf(TE);
        this.mElement = TE;
        this.mStep = TE2;
        this.mStepInfo = enumSet;
        this.mPrecedingProcedure = string;
        this.mSucceedingProcedure = string2;
        this.mToStringFunc = iToString;
        this.mRelevanceInformation = iRelevanceInformation;
        this.mThreadId = n;
        this.mForkedThreadId = n2;
        this.mJoinedThreadId = n3;
    }

    public TE getTraceElement() {
        return this.mElement;
    }

    public TE getStep() {
        return this.mStep;
    }

    public boolean hasStepInfo(StepInfo stepInfo) {
        return this.mStepInfo.contains((Object)stepInfo);
    }

    public boolean hasAnyStepInfo(StepInfo ... stepInfoArray) {
        return AtomicTraceElement.hasAnyStepInfo(this.getStepInfo(), stepInfoArray);
    }

    public static boolean hasAnyStepInfo(EnumSet<StepInfo> enumSet, StepInfo ... stepInfoArray) {
        if (stepInfoArray == null || stepInfoArray.length == 0) {
            return true;
        }
        StepInfo[] stepInfoArray2 = stepInfoArray;
        int n = stepInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StepInfo stepInfo = stepInfoArray2[n2];
            if (enumSet.contains((Object)stepInfo)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public EnumSet<StepInfo> getStepInfo() {
        return EnumSet.copyOf(this.mStepInfo);
    }

    public boolean hasThreadId() {
        return this.mThreadId != null;
    }

    public int getThreadId() {
        return this.mThreadId;
    }

    public boolean isMainThread() {
        return this.mThreadId == 0;
    }

    public int getForkedThreadId() {
        return this.mForkedThreadId;
    }

    public int getJoinedThreadId() {
        return this.mJoinedThreadId;
    }

    public IRelevanceInformation getRelevanceInformation() {
        return this.mRelevanceInformation;
    }

    public String getPrecedingProcedure() {
        return this.mPrecedingProcedure;
    }

    public String getSucceedingProcedure() {
        return this.mSucceedingProcedure;
    }

    public String toString() {
        IRelevanceInformation iRelevanceInformation;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mStepInfo.contains((Object)StepInfo.NONE)) {
            stringBuilder.append(this.mToStringFunc.toString(this.getTraceElement()));
        } else {
            stringBuilder.append(this.getStepInfo());
            stringBuilder.append(" ");
            stringBuilder.append(this.mToStringFunc.toString(this.getStep()));
        }
        if (this.hasThreadId()) {
            stringBuilder.append(" ");
            stringBuilder.append(this.getThreadId());
        }
        if ((iRelevanceInformation = this.getRelevanceInformation()) != null) {
            stringBuilder.append(" ");
            stringBuilder.append(iRelevanceInformation);
        }
        return stringBuilder.toString();
    }

    public static final class AtomicTraceElementBuilder<TE> {
        private TE mElement;
        private TE mStep;
        private IToString<TE> mToStringFunc;
        private IRelevanceInformation mRelevanceInformation;
        private String mPrecedingProcedure;
        private String mSucceedingProcedure;
        private Integer mThreadId;
        private EnumSet<StepInfo> mStepInfo;
        private Integer mForkedThreadId;
        private Integer mJoinedThreadId;

        public AtomicTraceElementBuilder() {
            this.mToStringFunc = object -> object.toString();
            this.mStepInfo = EnumSet.of(StepInfo.NONE);
        }

        private AtomicTraceElementBuilder(AtomicTraceElement<TE> atomicTraceElement) {
            this.mToStringFunc = atomicTraceElement.mToStringFunc;
            this.mStepInfo = EnumSet.copyOf(atomicTraceElement.mStepInfo);
            this.mPrecedingProcedure = atomicTraceElement.mPrecedingProcedure;
            this.mSucceedingProcedure = atomicTraceElement.mSucceedingProcedure;
            this.mStep = atomicTraceElement.mStep;
            this.mElement = atomicTraceElement.mElement;
            this.mThreadId = atomicTraceElement.mThreadId;
            this.mRelevanceInformation = atomicTraceElement.mRelevanceInformation;
            this.mForkedThreadId = atomicTraceElement.mForkedThreadId;
            this.mJoinedThreadId = atomicTraceElement.mJoinedThreadId;
        }

        public static <TE> AtomicTraceElementBuilder<TE> from(AtomicTraceElement<TE> atomicTraceElement) {
            return new AtomicTraceElementBuilder<TE>(atomicTraceElement);
        }

        public static <TE> AtomicTraceElementBuilder<TE> fromReplaceElementAndStep(AtomicTraceElement<?> atomicTraceElement, TE TE) {
            AtomicTraceElementBuilder<TE> atomicTraceElementBuilder = new AtomicTraceElementBuilder<TE>().setStepAndElement(TE).setStepInfo(atomicTraceElement.getStepInfo()).setRelevanceInformation(atomicTraceElement.getRelevanceInformation()).setProcedures(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement.getSucceedingProcedure());
            if (atomicTraceElement.hasThreadId()) {
                atomicTraceElementBuilder.setThreadId(atomicTraceElement.getThreadId());
            }
            if (atomicTraceElement.hasStepInfo(StepInfo.FORK)) {
                atomicTraceElementBuilder.setForkedThreadId(atomicTraceElement.getForkedThreadId());
            }
            if (atomicTraceElement.hasStepInfo(StepInfo.JOIN)) {
                atomicTraceElementBuilder.setJoinedThreadId(atomicTraceElement.getJoinedThreadId());
            }
            return atomicTraceElementBuilder;
        }

        public static <TE> AtomicTraceElementBuilder<TE> fromReplaceElementAndStep(AtomicTraceElement<?> atomicTraceElement, TE TE, TE TE2) {
            AtomicTraceElementBuilder<TE> atomicTraceElementBuilder = new AtomicTraceElementBuilder<TE>().setElement(TE).setStep(TE2).setStepInfo(atomicTraceElement.getStepInfo()).setRelevanceInformation(atomicTraceElement.getRelevanceInformation()).setProcedures(atomicTraceElement.getPrecedingProcedure(), atomicTraceElement.getSucceedingProcedure());
            if (atomicTraceElement.hasThreadId()) {
                atomicTraceElementBuilder.setThreadId(atomicTraceElement.getThreadId());
            }
            if (atomicTraceElement.hasStepInfo(StepInfo.FORK)) {
                atomicTraceElementBuilder.setForkedThreadId(atomicTraceElement.getForkedThreadId());
            }
            if (atomicTraceElement.hasStepInfo(StepInfo.JOIN)) {
                atomicTraceElementBuilder.setJoinedThreadId(atomicTraceElement.getJoinedThreadId());
            }
            return atomicTraceElementBuilder;
        }

        public AtomicTraceElement<TE> build() {
            return new AtomicTraceElement<TE>(this.mElement, this.mStep, this.mStepInfo, this.mToStringFunc, this.mRelevanceInformation, this.mPrecedingProcedure, this.mSucceedingProcedure, this.mThreadId, this.mForkedThreadId, this.mJoinedThreadId);
        }

        public AtomicTraceElementBuilder<TE> setElement(TE TE) {
            this.mElement = TE;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStep(TE TE) {
            this.mStep = TE;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStepAndElement(TE TE) {
            this.mStep = TE;
            this.mElement = TE;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setToStringFunc(IToString<TE> iToString) {
            this.mToStringFunc = Objects.requireNonNull(iToString);
            return this;
        }

        public AtomicTraceElementBuilder<TE> addStepInfo(StepInfo ... stepInfoArray) {
            if (stepInfoArray == null || stepInfoArray.length == 0) {
                return this;
            }
            if (stepInfoArray.length == 1 && stepInfoArray[0] == StepInfo.NONE) {
                this.mStepInfo = EnumSet.of(StepInfo.NONE);
                return this;
            }
            if (this.mStepInfo.contains((Object)StepInfo.NONE)) {
                this.mStepInfo.clear();
            }
            StepInfo[] stepInfoArray2 = stepInfoArray;
            int n = stepInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                StepInfo stepInfo = stepInfoArray2[n2];
                if (stepInfo == StepInfo.NONE) {
                    throw new IllegalArgumentException("Cannot combine NONE with any other value");
                }
                this.mStepInfo.add(stepInfo);
                ++n2;
            }
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStepInfo(StepInfo ... stepInfoArray) {
            if (stepInfoArray == null || stepInfoArray.length == 0) {
                this.mStepInfo = EnumSet.of(StepInfo.NONE);
                return this;
            }
            this.mStepInfo.clear();
            Collections.addAll(this.mStepInfo, stepInfoArray);
            if (this.mStepInfo.size() > 1 && this.mStepInfo.contains((Object)StepInfo.NONE)) {
                throw new IllegalArgumentException("Cannot combine NONE with any other value");
            }
            return this;
        }

        public AtomicTraceElementBuilder<TE> setStepInfo(EnumSet<StepInfo> enumSet) {
            return this.setStepInfo(enumSet.toArray(new StepInfo[enumSet.size()]));
        }

        public AtomicTraceElementBuilder<TE> setRelevanceInformation(IRelevanceInformation iRelevanceInformation) {
            this.mRelevanceInformation = iRelevanceInformation;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setProcedures(String string, String string2) {
            this.mPrecedingProcedure = string;
            this.mSucceedingProcedure = string2;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setThreadId(int n) {
            this.mThreadId = n;
            return this;
        }

        public Integer getForkedThreadId() {
            return this.mForkedThreadId;
        }

        public AtomicTraceElementBuilder<TE> setForkedThreadId(int n) {
            this.mForkedThreadId = n;
            return this;
        }

        public AtomicTraceElementBuilder<TE> setJoinedThreadId(int n) {
            this.mJoinedThreadId = n;
            return this;
        }
    }

    public static enum StepInfo {
        NONE("NONE"),
        CONDITION_EVAL_TRUE("COND TRUE"),
        CONDITION_EVAL_FALSE("COND FALSE"),
        PROC_CALL("CALL"),
        PROC_RETURN("RET"),
        ARG_EVAL("ARG"),
        EXPR_EVAL("EXPR"),
        FUNC_CALL("FCALL"),
        FORK("FORK"),
        JOIN("JOIN");

        private final String mText;

        private StepInfo(String string2) {
            this.mText = string2;
        }

        public String toString() {
            return this.mText;
        }
    }
}

