/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class AssignmentStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(AssignmentStatement.class);
    LeftHandSide[] lhs;
    Expression[] rhs;

    public AssignmentStatement(ILocation iLocation, LeftHandSide[] leftHandSideArray, Expression[] expressionArray) {
        super(iLocation);
        this.lhs = leftHandSideArray;
        this.rhs = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid AssignmentStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AssignmentStatement").append('[');
        if (this.lhs == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.lhs.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.lhs[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.rhs == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.rhs.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.rhs[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public LeftHandSide[] getLhs() {
        return this.lhs;
    }

    public Expression[] getRhs() {
        return this.rhs;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.lhs != null) {
            list.addAll(Arrays.asList(this.lhs));
        }
        if (this.rhs != null) {
            list.addAll(Arrays.asList(this.rhs));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.lhs != null) {
                boogieASTNodeArray = this.lhs;
                n2 = this.lhs.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((LeftHandSide)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.rhs != null) {
                boogieASTNodeArray = this.rhs;
                n2 = this.rhs.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Expression)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<Expression[]> arrayList = new ArrayList<Expression[]>();
        if (this.lhs != null) {
            LeftHandSide[] leftHandSideArray = this.lhs;
            n = this.lhs.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = leftHandSideArray[n2];
                object = ((LeftHandSide)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((Expression[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.rhs != null) {
            object = this.rhs;
            int n3 = this.rhs.length;
            n = 0;
            while (n < n3) {
                Expression expression = object[n];
                Expression expression2 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression2 != expression;
                ((ArrayList)object2).add(expression2);
                ++n;
            }
        }
        if (bl) {
            return new AssignmentStatement(this.loc, arrayList.toArray(new LeftHandSide[0]), ((ArrayList)object2).toArray(new Expression[0]));
        }
        return this;
    }
}

