/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IVasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Qvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractionJoin;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QvasrsSummarizer {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;

    public QvasrsSummarizer(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
    }

    public QvasrsAbstraction computeQvasrsAbstraction(UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        Object object;
        Object object2;
        Object object32;
        Term term3;
        Set<Term> set = QvasrUtils.splitDisjunction(unmodifiableTransFormula.getFormula());
        HashSet<Term> hashSet = new HashSet<Term>();
        for (Term term2 : set) {
            UnmodifiableTransFormula unmodifiableTransFormula2 = QvasrUtils.buildFormula(unmodifiableTransFormula, term2, this.mScript);
            hashSet.add(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula2, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices).getFormula());
        }
        set = hashSet;
        set = QvasrUtils.checkDisjoint(set, this.mScript, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry entry : unmodifiableTransFormula.getOutVars().entrySet()) {
            if (unmodifiableTransFormula.getInVars().containsKey(entry.getKey())) {
                hashMap.put((Term)entry.getValue(), (Term)unmodifiableTransFormula.getInVars().get(entry.getKey()));
                continue;
            }
            hashMap.put((Term)entry.getValue(), (Term)entry.getValue());
        }
        HashSet<Triple> hashSet2 = new HashSet<Triple>();
        int n = unmodifiableTransFormula.getAssignedVars().size();
        Rational[][] rationalArray = QvasrUtils.getIdentityMatrix(n);
        QvasrAbstraction qvasrAbstraction = new QvasrAbstraction(rationalArray, new Qvasr());
        for (Term term3 : set) {
            object32 = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term3);
            for (Term term4 : set) {
                Term term5 = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{object32, unmodifiableTransFormula.getFormula(), term4});
                object2 = QvasrUtils.buildFormula(unmodifiableTransFormula, term5, this.mScript);
                object = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)object2.getFormula());
                Set<Term> set2 = QvasrUtils.splitDisjunction((Term)object);
                Object object4 = new QvasrAbstraction(rationalArray, new Qvasr());
                for (Term term6 : set2) {
                    this.mLogger.warn((Object)term6.toStringDirect());
                    UnmodifiableTransFormula unmodifiableTransFormula3 = QvasrUtils.buildFormula(unmodifiableTransFormula, term6, this.mScript);
                    QvasrAbstraction qvasrAbstraction2 = QvasrAbstractor.computeAbstraction(this.mServices, this.mScript, unmodifiableTransFormula3);
                    object4 = (QvasrAbstraction)QvasrAbstractionJoin.join(this.mScript, qvasrAbstraction, qvasrAbstraction2).getThird();
                }
                Triple<Rational[][], Rational[][], QvasrAbstraction> triple = QvasrAbstractionJoin.join(this.mScript, qvasrAbstraction, (QvasrAbstraction)object4);
                Pair pair = new Pair((Object)term3, (Object)term4);
                hashSet2.add(new Triple((Object)pair, ((QvasrAbstraction)object4).getVasr(), (Object)((Rational[][])triple.getSecond())));
                qvasrAbstraction = (QvasrAbstraction)QvasrAbstractionJoin.join(this.mScript, qvasrAbstraction, (QvasrAbstraction)object4).getThird();
            }
        }
        term3 = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (Object object32 : unmodifiableTransFormula.getOutVars().keySet()) {
            if (unmodifiableTransFormula.getInVars().containsKey(object32)) {
                term3.put(object32, (TermVariable)unmodifiableTransFormula.getInVars().get(object32));
            } else if (unmodifiableTransFormula.getOutVars().containsKey(object32)) {
                term3.put(object32, (TermVariable)unmodifiableTransFormula.getOutVars().get(object32));
            }
            if (!unmodifiableTransFormula.getOutVars().containsKey(object32)) continue;
            hashMap2.put(object32, (TermVariable)unmodifiableTransFormula.getOutVars().get(object32));
        }
        object32 = new QvasrsAbstraction(qvasrAbstraction, set, (Map<IProgramVar, TermVariable>)term3, hashMap2);
        for (Term term4 : hashSet2) {
            Term term7 = (Term)((Pair)term4.getFirst()).getFirst();
            object2 = (Term)((Pair)term4.getFirst()).getSecond();
            object = QvasrAbstractionJoin.image((IVasr)term4.getSecond(), (Rational[][])term4.getThird());
            for (Pair<Rational[], Rational[]> pair : ((Qvasr)object).getTransformer()) {
                Triple triple = new Triple((Object)term7, pair, object2);
                if (!this.checkIfTransitionIsAbsent((Triple<Term, Pair<Rational[], Rational[]>, Term>)triple, (QvasrsAbstraction)object32)) continue;
                ((QvasrsAbstraction)object32).addTransition((Triple<Term, Pair<Rational[], Rational[]>, Term>)triple);
            }
        }
        if (bl) {
            Term term4;
            term4 = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices);
            ((QvasrsAbstraction)object32).setPreState(term4.getFormula());
            HashMap hashMap3 = new HashMap();
            for (Map.Entry entry : unmodifiableTransFormula.getInVars().entrySet()) {
                if (!unmodifiableTransFormula.getOutVars().containsKey(entry.getKey())) continue;
                hashMap3.put((Term)entry.getValue(), (Term)unmodifiableTransFormula.getOutVars().get(entry.getKey()));
            }
            Term term8 = Substitution.apply((ManagedScript)this.mScript, (Map)hashMap3, (Term)term4.getFormula());
            ((QvasrsAbstraction)object32).setPostState(SmtUtils.not((Script)this.mScript.getScript(), (Term)term8));
        }
        return object32;
    }

    private final boolean checkIfTransitionIsAbsent(Triple<Term, Pair<Rational[], Rational[]>, Term> triple, QvasrsAbstraction qvasrsAbstraction) {
        boolean bl = true;
        block0: for (Triple<Term, Pair<Rational[], Rational[]>, Term> triple2 : qvasrsAbstraction.getTransitions()) {
            if (!QvasrUtils.checkTermEquiv(this.mScript, (Term)triple2.getFirst(), (Term)triple.getFirst()) && !QvasrUtils.checkTermEquiv(this.mScript, (Term)triple2.getThird(), (Term)triple.getThird())) continue;
            int n = 0;
            while (n < ((Rational[])((Pair)triple2.getSecond()).getFirst()).length) {
                if (((Rational[])((Pair)triple.getSecond()).getFirst())[n] != ((Rational[])((Pair)triple2.getSecond()).getFirst())[n] || ((Rational[])((Pair)triple.getSecond()).getSecond())[n] != ((Rational[])((Pair)triple2.getSecond()).getSecond())[n]) continue block0;
                bl = false;
                ++n;
            }
        }
        return bl;
    }

    private final Term substituteVars(Term term, Map<IProgramVar, TermVariable> map) {
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            hashMap.put(entry.getKey().getTermVariable(), entry.getValue());
        }
        return Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term);
    }
}

