/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.PredicateTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;

public class TermTransferringIndependenceRelation<L extends IAction>
implements IIndependenceRelation<IPredicate, L> {
    private static final boolean ABSTRACT_TF_WITH_BRANCH_ENCODERS = false;
    private final IIndependenceRelation<IPredicate, L> mUnderlying;
    private final TransferrerWithVariableCache mTransferrer;
    private final PredicateTransferrer mPredicateTransferrer;
    private final ICopyActionFactory<L> mCopyFactory;
    private final boolean mTransferOnlyConditions;

    public TermTransferringIndependenceRelation(IIndependenceRelation<IPredicate, L> iIndependenceRelation, TransferrerWithVariableCache transferrerWithVariableCache, PredicateTransferrer predicateTransferrer, ICopyActionFactory<L> iCopyActionFactory, boolean bl) {
        this.mUnderlying = iIndependenceRelation;
        this.mTransferrer = transferrerWithVariableCache;
        this.mPredicateTransferrer = predicateTransferrer;
        this.mCopyFactory = iCopyActionFactory;
        this.mTransferOnlyConditions = bl;
        assert (!bl || this.mUnderlying.isConditional()) : "Nothing to transfer";
        assert (bl || this.mCopyFactory != null) : "cannot transfer letters without factory";
    }

    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    public boolean isConditional() {
        return this.mUnderlying.isConditional();
    }

    public IIndependenceRelation.Dependence isIndependent(IPredicate iPredicate, L l, L l2) {
        L l3 = this.transfer(l);
        L l4 = this.transfer(l2);
        IPredicate iPredicate2 = iPredicate == null ? null : this.mPredicateTransferrer.transferPredicate(iPredicate);
        return this.mUnderlying.isIndependent((Object)iPredicate2, l3, l4);
    }

    public ISymbolicIndependenceRelation<L, IPredicate> getSymbolicRelation() {
        ISymbolicIndependenceRelation iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new SymbolicTransferringIndependence(iSymbolicIndependenceRelation);
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mUnderlying.getStatistics();
    }

    private final L transfer(L l) {
        if (this.mTransferOnlyConditions) {
            return l;
        }
        UnmodifiableTransFormula unmodifiableTransFormula = this.mTransferrer.transferTransFormula(l.getTransformula());
        UnmodifiableTransFormula unmodifiableTransFormula2 = null;
        return this.mCopyFactory.copy(l, unmodifiableTransFormula, unmodifiableTransFormula2);
    }

    private class SymbolicTransferringIndependence
    implements ISymbolicIndependenceRelation<L, IPredicate> {
        private final ISymbolicIndependenceRelation<L, IPredicate> mUnderlyingSymbolic;

        public SymbolicTransferringIndependence(ISymbolicIndependenceRelation<L, IPredicate> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        public IPredicate getCommutativityCondition(IPredicate iPredicate, L l, L l2) {
            Object l3 = TermTransferringIndependenceRelation.this.transfer(l);
            Object l4 = TermTransferringIndependenceRelation.this.transfer(l2);
            IPredicate iPredicate2 = !this.isConditional() || iPredicate == null ? null : TermTransferringIndependenceRelation.this.mPredicateTransferrer.transferPredicate(iPredicate);
            IPredicate iPredicate3 = (IPredicate)this.mUnderlyingSymbolic.getCommutativityCondition((Object)iPredicate2, l3, l4);
            if (iPredicate3 == null) {
                return null;
            }
            return TermTransferringIndependenceRelation.this.mPredicateTransferrer.backTransferPredicate(iPredicate3);
        }

        public boolean isSymmetric() {
            return TermTransferringIndependenceRelation.this.mUnderlying.isSymmetric();
        }

        public boolean isConditional() {
            return this.mUnderlyingSymbolic.isConditional();
        }
    }
}

