/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.LazyInt;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitSubSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.CanonicalLatticeForMaps;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.UpsideDownLattice;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VarAbsConstraints<L extends IAction> {
    private final LazyInt mHash;
    private final Map<L, BitSubSet<IProgramVar>> mInConstr;
    private final Map<L, BitSubSet<IProgramVar>> mOutConstr;
    private final BitSubSet<IProgramVar> mEmpty;

    VarAbsConstraints(Map<L, BitSubSet<IProgramVar>> map, Map<L, BitSubSet<IProgramVar>> map2, BitSubSet<IProgramVar> bitSubSet) {
        this.mInConstr = map;
        this.mOutConstr = map2;
        this.mHash = new LazyInt(() -> HashUtils.hashJenkins((int)17, (Object[])new Object[]{this.mInConstr, this.mOutConstr}));
        assert (bitSubSet.isEmpty());
        this.mEmpty = bitSubSet;
    }

    public BitSubSet<IProgramVar> getInConstraints(L l) {
        if (this.mInConstr.containsKey(l)) {
            return this.mInConstr.get(l);
        }
        return this.mEmpty;
    }

    public BitSubSet<IProgramVar> getOutConstraints(L l) {
        if (this.mOutConstr.containsKey(l)) {
            return this.mOutConstr.get(l);
        }
        return this.mEmpty;
    }

    public VarAbsConstraints<L> withModifiedConstraints(L l, BitSubSet<IProgramVar> bitSubSet, BitSubSet<IProgramVar> bitSubSet2) {
        HashMap<L, BitSubSet<IProgramVar>> hashMap = new HashMap<L, BitSubSet<IProgramVar>>(this.mInConstr);
        hashMap.put(l, bitSubSet);
        HashMap<L, BitSubSet<IProgramVar>> hashMap2 = new HashMap<L, BitSubSet<IProgramVar>>(this.mOutConstr);
        hashMap2.put(l, bitSubSet2);
        return new VarAbsConstraints<L>(hashMap, hashMap2, this.mEmpty);
    }

    public int hashCode() {
        return this.mHash.get();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VarAbsConstraints varAbsConstraints = (VarAbsConstraints)object;
        return Objects.equals(this.mInConstr, varAbsConstraints.mInConstr) && Objects.equals(this.mOutConstr, varAbsConstraints.mOutConstr);
    }

    public static final class Lattice<L extends IAction>
    implements ILattice<VarAbsConstraints<L>> {
        private final BitSubSet.Factory<IProgramVar> mFactory;
        private final UpsideDownLattice<Map<L, BitSubSet<IProgramVar>>> mMapLattice;
        private final VarAbsConstraints<L> mBottom;

        public Lattice(Set<L> set, BitSubSet.Factory<IProgramVar> factory) {
            this.mFactory = factory;
            this.mMapLattice = new UpsideDownLattice((ILattice)new CanonicalLatticeForMaps(factory, set));
            this.mBottom = new VarAbsConstraints((Map)this.mMapLattice.getBottom(), (Map)this.mMapLattice.getBottom(), (BitSubSet<IProgramVar>)factory.empty());
        }

        public IPartialComparator.ComparisonResult compare(VarAbsConstraints<L> varAbsConstraints, VarAbsConstraints<L> varAbsConstraints2) {
            return IPartialComparator.ComparisonResult.aggregate((IPartialComparator.ComparisonResult)this.mMapLattice.compare(varAbsConstraints.mInConstr, varAbsConstraints2.mInConstr), (IPartialComparator.ComparisonResult)this.mMapLattice.compare(varAbsConstraints.mOutConstr, varAbsConstraints2.mOutConstr));
        }

        public VarAbsConstraints<L> getBottom() {
            return this.mBottom;
        }

        public VarAbsConstraints<L> getTop() {
            return new VarAbsConstraints(Collections.emptyMap(), Collections.emptyMap(), (BitSubSet<IProgramVar>)this.mFactory.empty());
        }

        public VarAbsConstraints<L> supremum(VarAbsConstraints<L> varAbsConstraints, VarAbsConstraints<L> varAbsConstraints2) {
            return new VarAbsConstraints((Map)this.mMapLattice.supremum(varAbsConstraints.mInConstr, varAbsConstraints2.mInConstr), (Map)this.mMapLattice.supremum(varAbsConstraints.mOutConstr, varAbsConstraints2.mOutConstr), (BitSubSet<IProgramVar>)this.mFactory.empty());
        }

        public VarAbsConstraints<L> infimum(VarAbsConstraints<L> varAbsConstraints, VarAbsConstraints<L> varAbsConstraints2) {
            return new VarAbsConstraints((Map)this.mMapLattice.infimum(varAbsConstraints.mInConstr, varAbsConstraints2.mInConstr), (Map)this.mMapLattice.infimum(varAbsConstraints.mOutConstr, varAbsConstraints2.mOutConstr), (BitSubSet<IProgramVar>)this.mFactory.empty());
        }
    }
}

