/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLResultExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Assertion;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.AtLabelExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BaseAddrExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BlockLengthExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CastExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeAnnotStmt;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Ensures;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FieldAccessExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FreeableExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GhostDeclaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GhostUpdate;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GlobalGhostDeclaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.MallocableExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.NotDefinedExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.NullPointer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.OldValueExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Requires;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.SizeOfExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.SyntacticNamingExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ValidExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class ACSLPrettyPrinter {
    public static String print(ACSLNode aCSLNode) {
        ACSLNode aCSLNode2 = aCSLNode;
        Objects.requireNonNull(aCSLNode2);
        ACSLNode aCSLNode3 = aCSLNode2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CodeAnnotStmt.class, Assertion.class, Expression.class, GhostDeclaration.class, GlobalGhostDeclaration.class, GhostUpdate.class, LoopInvariant.class, Requires.class, Ensures.class}, (Object)aCSLNode3, 0)) {
            case 0: {
                CodeAnnotStmt codeAnnotStmt = (CodeAnnotStmt)aCSLNode3;
                return ACSLPrettyPrinter.print(codeAnnotStmt.getCodeStmt());
            }
            case 1: {
                Assertion assertion = (Assertion)aCSLNode3;
                return "//@ assert " + ACSLPrettyPrinter.printExpression(assertion.getFormula()) + ";";
            }
            case 2: {
                Expression expression = (Expression)aCSLNode3;
                return ACSLPrettyPrinter.printExpression(expression);
            }
            case 3: {
                GhostDeclaration ghostDeclaration = (GhostDeclaration)aCSLNode3;
                return ACSLPrettyPrinter.printGhostDeclaration(ghostDeclaration.getType(), ghostDeclaration.getIdentifier(), ghostDeclaration.getExpr());
            }
            case 4: {
                GlobalGhostDeclaration globalGhostDeclaration = (GlobalGhostDeclaration)aCSLNode3;
                return ACSLPrettyPrinter.printGhostDeclaration(globalGhostDeclaration.getType(), globalGhostDeclaration.getIdentifier(), globalGhostDeclaration.getExpr());
            }
            case 5: {
                GhostUpdate ghostUpdate = (GhostUpdate)aCSLNode3;
                return String.format("//@ ghost %s = %s;", ghostUpdate.getIdentifier(), ACSLPrettyPrinter.printExpression(ghostUpdate.getExpr()));
            }
            case 6: {
                LoopInvariant loopInvariant = (LoopInvariant)aCSLNode3;
                return "//@ loop invariant " + ACSLPrettyPrinter.printExpression(loopInvariant.getFormula()) + ";";
            }
            case 7: {
                Requires requires = (Requires)aCSLNode3;
                return "//@ requires " + ACSLPrettyPrinter.printExpression(requires.getFormula()) + ";";
            }
            case 8: {
                Ensures ensures = (Ensures)aCSLNode3;
                return "//@ ensures " + ACSLPrettyPrinter.printExpression(ensures.getFormula()) + ";";
            }
        }
        return aCSLNode.toString();
    }

    private static String printGhostDeclaration(ACSLType aCSLType, String string, Expression expression) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//@ ghost ").append(aCSLType.getTypeName()).append(' ').append(string);
        if (expression != null) {
            stringBuilder.append(" = ").append(ACSLPrettyPrinter.printExpression(expression));
        }
        return stringBuilder.append(';').toString();
    }

    private static String printExpression(Expression expression2) {
        Expression expression3 = expression2;
        Objects.requireNonNull(expression3);
        Expression expression4 = expression3;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ACSLResultExpression.class, ArrayAccessExpression.class, AtLabelExpression.class, BaseAddrExpression.class, BinaryExpression.class, BlockLengthExpression.class, BooleanLiteral.class, CastExpression.class, FieldAccessExpression.class, FreeableExpression.class, FunctionApplication.class, IdentifierExpression.class, IfThenElseExpression.class, IntegerLiteral.class, MallocableExpression.class, NotDefinedExpression.class, NullPointer.class, OldValueExpression.class, QuantifierExpression.class, RealLiteral.class, SizeOfExpression.class, StringLiteral.class, SyntacticNamingExpression.class, UnaryExpression.class, ValidExpression.class}, (Object)expression4, 0)) {
            case 0 -> {
                ACSLResultExpression var2_2 = (ACSLResultExpression)expression4;
                yield "\\result";
            }
            case 1 -> {
                ArrayAccessExpression var3_3 = (ArrayAccessExpression)expression4;
                yield "%s[%s]".formatted(ACSLPrettyPrinter.printExpression(var3_3.getArray()), ACSLPrettyPrinter.printExpression(var3_3.getIndex()));
            }
            case 2 -> {
                AtLabelExpression var4_4 = (AtLabelExpression)expression4;
                yield "\\at(%s, %s)".formatted(ACSLPrettyPrinter.printExpression(var4_4.getExpression()), var4_4.getLabel());
            }
            case 3 -> {
                BaseAddrExpression var5_5 = (BaseAddrExpression)expression4;
                yield "\\base_addr{%s}".formatted(ACSLPrettyPrinter.printExpression(var5_5.getExpression()));
            }
            case 4 -> {
                BinaryExpression var6_6 = (BinaryExpression)expression4;
                yield ACSLPrettyPrinter.printBinaryExpression(var6_6);
            }
            case 5 -> {
                BlockLengthExpression var7_7 = (BlockLengthExpression)expression4;
                yield "\\block_length{%s}".formatted(ACSLPrettyPrinter.printExpression(var7_7.getExpression()));
            }
            case 6 -> {
                BooleanLiteral var8_8 = (BooleanLiteral)expression4;
                yield "\\" + var8_8.getValue();
            }
            case 7 -> {
                CastExpression var9_9 = (CastExpression)expression4;
                yield "(%s) %s".formatted(var9_9.getCastedType().getTypeName(), ACSLPrettyPrinter.printExpression(var9_9.getExpression()));
            }
            case 8 -> {
                FieldAccessExpression var10_10 = (FieldAccessExpression)expression4;
                yield "(%s).%s".formatted(ACSLPrettyPrinter.printExpression(var10_10.getStruct()), var10_10.getField());
            }
            case 9 -> {
                FreeableExpression var11_11 = (FreeableExpression)expression4;
                yield "\\freeable{%s}".formatted(ACSLPrettyPrinter.printExpression(var11_11.getExpression()));
            }
            case 10 -> {
                FunctionApplication var12_12 = (FunctionApplication)expression4;
                yield "%s(%s)".formatted(var12_12.getIdentifier(), Arrays.stream(var12_12.getArguments()).map(expression -> ACSLPrettyPrinter.printExpression(expression)).collect(Collectors.joining(", ")));
            }
            case 11 -> {
                IdentifierExpression var13_13 = (IdentifierExpression)expression4;
                yield var13_13.getIdentifier();
            }
            case 12 -> {
                IfThenElseExpression var14_14 = (IfThenElseExpression)expression4;
                yield "(%s ? %s : %s)".formatted(ACSLPrettyPrinter.printExpression(var14_14.getCondition()), ACSLPrettyPrinter.printExpression(var14_14.getThenPart()), ACSLPrettyPrinter.printExpression(var14_14.getElsePart()));
            }
            case 13 -> {
                IntegerLiteral var15_15 = (IntegerLiteral)expression4;
                yield var15_15.getValue();
            }
            case 14 -> {
                MallocableExpression var16_16 = (MallocableExpression)expression4;
                yield "\\mallocable{%s}".formatted(ACSLPrettyPrinter.printExpression(var16_16.getExpression()));
            }
            case 15 -> {
                NotDefinedExpression var17_17 = (NotDefinedExpression)expression4;
                throw new AssertionError((Object)"NotDefinedExpression should not be shown as a string, it should be only used for unsupported ACSL expressions.");
            }
            case 16 -> {
                NullPointer var18_18 = (NullPointer)expression4;
                yield "\\null";
            }
            case 17 -> {
                OldValueExpression var19_19 = (OldValueExpression)expression4;
                yield "\\old(%s)".formatted(ACSLPrettyPrinter.printExpression(var19_19.getExpression()));
            }
            case 18 -> {
                QuantifierExpression var20_20 = (QuantifierExpression)expression4;
                yield ACSLPrettyPrinter.printQuantifierExpression(var20_20);
            }
            case 19 -> {
                RealLiteral var21_21 = (RealLiteral)expression4;
                yield var21_21.getValue();
            }
            case 20 -> {
                SizeOfExpression var22_22 = (SizeOfExpression)expression4;
                yield "sizeof(%s)".formatted(ACSLPrettyPrinter.printExpression(var22_22.getExpression()));
            }
            case 21 -> {
                StringLiteral var23_23 = (StringLiteral)expression4;
                yield "\"%s\"".formatted(var23_23.getValue());
            }
            case 22 -> {
                SyntacticNamingExpression var24_24 = (SyntacticNamingExpression)expression4;
                yield "%s : %s".formatted(var24_24.getIdentifier(), ACSLPrettyPrinter.printExpression(var24_24.getExpression()));
            }
            case 23 -> {
                UnaryExpression var25_25 = (UnaryExpression)expression4;
                yield ACSLPrettyPrinter.printUnaryExpression(var25_25);
            }
            case 24 -> {
                ValidExpression var26_26 = (ValidExpression)expression4;
                yield "\\valid(%s)".formatted(ACSLPrettyPrinter.printExpression(var26_26.getExpression()));
            }
            default -> throw new MatchException(null, null);
        };
    }

    private static String printQuantifierExpression(QuantifierExpression quantifierExpression) {
        String string = quantifierExpression.isUniversal() ? "\\forall" : "\\exists";
        String string2 = Arrays.stream(quantifierExpression.getVariables()).map(declaration -> declaration.getType().getTypeName() + " " + declaration.getName()).collect(Collectors.joining(", "));
        return "%s %s; %s".formatted(string, string2, ACSLPrettyPrinter.printExpression(quantifierExpression.getSubformula()));
    }

    private static String printUnaryExpression(UnaryExpression unaryExpression) {
        String string = switch (unaryExpression.getOperator()) {
            case UnaryExpression.Operator.ADDROF -> "&";
            case UnaryExpression.Operator.LOGICCOMPLEMENT -> "~";
            case UnaryExpression.Operator.LOGICNEG -> "!";
            case UnaryExpression.Operator.MINUS -> "-";
            case UnaryExpression.Operator.PLUS -> "+";
            case UnaryExpression.Operator.POINTER -> "*";
            case UnaryExpression.Operator.LTLGLOBALLY, UnaryExpression.Operator.LTLFINALLY, UnaryExpression.Operator.LTLNEXT -> throw new AssertionError((Object)("Unhandled operator " + String.valueOf((Object)unaryExpression.getOperator())));
            default -> throw new MatchException(null, null);
        };
        return string + ACSLPrettyPrinter.printExpression(unaryExpression.getExpr());
    }

    private static String printBinaryExpression(BinaryExpression binaryExpression) {
        String string = switch (binaryExpression.getOperator()) {
            case BinaryExpression.Operator.ARITHDIV -> "/";
            case BinaryExpression.Operator.ARITHMINUS -> "-";
            case BinaryExpression.Operator.ARITHMOD -> "%";
            case BinaryExpression.Operator.ARITHMUL -> "*";
            case BinaryExpression.Operator.ARITHPLUS -> "+";
            case BinaryExpression.Operator.BITAND -> "&";
            case BinaryExpression.Operator.BITIFF -> "<-->";
            case BinaryExpression.Operator.BITIMPLIES -> "-->";
            case BinaryExpression.Operator.BITOR -> "|";
            case BinaryExpression.Operator.BITXOR -> "^";
            case BinaryExpression.Operator.COMPEQ -> "==";
            case BinaryExpression.Operator.COMPGEQ -> ">=";
            case BinaryExpression.Operator.COMPGT -> ">";
            case BinaryExpression.Operator.COMPLEQ -> "<=";
            case BinaryExpression.Operator.COMPLT -> "<";
            case BinaryExpression.Operator.COMPNEQ -> "!=";
            case BinaryExpression.Operator.LOGICAND -> "&&";
            case BinaryExpression.Operator.LOGICIFF -> "<==>";
            case BinaryExpression.Operator.LOGICIMPLIES -> "==>";
            case BinaryExpression.Operator.LOGICOR -> "||";
            case BinaryExpression.Operator.LOGICXOR -> "^^";
            case BinaryExpression.Operator.BITSHIFTLEFT -> "<<";
            case BinaryExpression.Operator.BITSHIFTRIGHT -> ">>";
            case BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT, BinaryExpression.Operator.LTLUNTIL, BinaryExpression.Operator.LTLRELEASE, BinaryExpression.Operator.LTLWEAKUNTIL -> throw new AssertionError((Object)("Unhandled operator " + String.valueOf((Object)binaryExpression.getOperator())));
            default -> throw new MatchException(null, null);
        };
        String string2 = ACSLPrettyPrinter.printExpression(binaryExpression.getLeft());
        String string3 = ACSLPrettyPrinter.printExpression(binaryExpression.getRight());
        return String.format("(%s %s %s)", string2, string, string3);
    }
}

