/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SparseMapBuilder<K, V> {
    private static final String MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED = "Map cannot be modified after the result was returned.";
    private boolean mConstructionFinished;
    private Map<K, V> mMap = Collections.emptyMap();

    public V put(K k, V v) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException(MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED);
        }
        if (this.mMap.isEmpty()) {
            this.mMap = Collections.singletonMap(k, v);
            return null;
        }
        if (this.mMap.size() == 1) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.mMap);
            this.mMap = hashMap;
        }
        return this.mMap.put(k, v);
    }

    public Map<K, V> getBuiltMap() {
        this.mConstructionFinished = true;
        return this.mMap;
    }

    public void clear() {
        if (this.mConstructionFinished) {
            throw new IllegalStateException(MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED);
        }
        this.mMap = Collections.emptyMap();
    }

    public boolean containsKey(Object object) {
        return this.mMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mMap.containsValue(object);
    }

    public V get(Object object) {
        return this.mMap.get(object);
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public V remove(Object object) {
        V v;
        if (this.mConstructionFinished) {
            throw new IllegalStateException(MAP_CANNOT_BE_MODIFIED_AFTER_THE_RESULT_WAS_RETURNED);
        }
        if (this.mMap.containsKey(object)) {
            if (this.mMap.size() == 2) {
                v = this.mMap.remove(object);
                Map.Entry<K, V> entry = this.mMap.entrySet().iterator().next();
                this.mMap = Collections.singletonMap(entry.getKey(), entry.getValue());
            } else if (this.mMap.size() == 1) {
                v = this.mMap.get(object);
                this.mMap = Collections.emptyMap();
            } else {
                v = this.mMap.remove(object);
            }
        } else {
            v = null;
        }
        return v;
    }

    public int size() {
        return this.mMap.size();
    }
}

