/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.chctoboogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornUtilConstants;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Term2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GenerateBoogieAstHelper {
    private final ILocation mLocation;
    private final HcSymbolTable mHcSymbolTable;
    private final TypeSortTranslator mTypeSortTanslator;
    private final Term2Expression mTerm2Expression;
    private final HcPredicateSymbol mBottomPredSym;
    private final String mNameOfEntryPointProc;
    private final Map<Sort, String> mArraySortToDummyVarName;

    public GenerateBoogieAstHelper(ILocation iLocation, HcSymbolTable hcSymbolTable, Term2Expression term2Expression, TypeSortTranslator typeSortTranslator, String string) {
        this.mLocation = iLocation;
        this.mHcSymbolTable = hcSymbolTable;
        this.mNameOfEntryPointProc = string;
        this.mTypeSortTanslator = typeSortTranslator;
        this.mTerm2Expression = term2Expression;
        this.mBottomPredSym = this.mHcSymbolTable.getFalseHornClausePredicateSymbol();
        this.mArraySortToDummyVarName = new LinkedHashMap<Sort, String>();
    }

    ILocation getLoc() {
        return this.mLocation;
    }

    String predSymToMethodName(HcPredicateSymbol hcPredicateSymbol) {
        return this.mHcSymbolTable.getMethodNameForPredSymbol(hcPredicateSymbol);
    }

    List<Statement> addIteBranch(ILocation iLocation, List<Statement> list, List<Statement> list2, Expression expression) {
        if (list == null) {
            return list2;
        }
        if (list.size() == 1 && list.get(0) instanceof IfStatement) {
            Statement[] statementArray = new Statement[]{list.get(0)};
            IfStatement ifStatement = new IfStatement(iLocation, expression, list2.toArray(new Statement[list2.size()]), statementArray);
            return Collections.singletonList(ifStatement);
        }
        IfStatement ifStatement = new IfStatement(iLocation, expression, list2.toArray(new Statement[list2.size()]), list.toArray(new Statement[list.size()]));
        return Collections.singletonList(ifStatement);
    }

    ASTType getCorrespondingAstType(ILocation iLocation, Sort sort2) {
        if (sort2.getName().equals("Int")) {
            return new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_INT, "int");
        }
        if (sort2.getName().equals("Real")) {
            return new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_REAL, "real");
        }
        if (sort2.getName().equals("Bool")) {
            return new PrimitiveType(iLocation, (IBoogieType)BoogieType.TYPE_BOOL, "bool");
        }
        if (sort2.isArraySort()) {
            List<Sort> list = Arrays.asList(sort2.getArguments());
            List list2 = list.stream().map(sort -> this.getCorrespondingAstType(iLocation, (Sort)sort)).collect(Collectors.toList());
            IBoogieType iBoogieType = this.mTypeSortTanslator.getType(sort2);
            return new ArrayType(iLocation, iBoogieType, new String[0], list2.subList(0, list2.size() - 1).toArray(new ASTType[list2.size() - 1]), (ASTType)list2.get(list2.size() - 1));
        }
        throw new AssertionError((Object)"case not implemented");
    }

    VarList[] getInParamsForHeadPredSymbol(ILocation iLocation, HcPredicateSymbol hcPredicateSymbol, boolean bl) {
        VarList[] varListArray = new VarList[hcPredicateSymbol.getArity()];
        List list = this.mHcSymbolTable.getHcHeadVarsForPredSym(hcPredicateSymbol, bl);
        int n = 0;
        while (n < hcPredicateSymbol.getArity()) {
            VarList varList;
            HcHeadVar hcHeadVar = (HcHeadVar)list.get(n);
            Sort sort = hcHeadVar.getTermVariable().getSort();
            ASTType aSTType = this.getCorrespondingAstType(iLocation, sort);
            varListArray[n] = varList = new VarList(iLocation, new String[]{hcHeadVar.getGloballyUniqueId()}, aSTType);
            ++n;
        }
        return varListArray;
    }

    VarList[] getInParamsForSorts(ILocation iLocation, Sort[] sortArray) {
        VarList[] varListArray = new VarList[sortArray.length];
        int n = 0;
        while (n < sortArray.length) {
            VarList varList;
            Sort sort = sortArray[n];
            ASTType aSTType = this.getCorrespondingAstType(iLocation, sort);
            varListArray[n] = varList = new VarList(iLocation, new String[]{"in_" + n}, aSTType);
            ++n;
        }
        return varListArray;
    }

    public String getNameOfMainEntryPointProc() {
        return this.mNameOfEntryPointProc;
    }

    public List<Declaration> getAuxDeclarations() {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.getDeclarationsForSkolemFunctions());
        arrayList.addAll(this.getDeclarationsForArrayDummyVars());
        return arrayList;
    }

    private List<Declaration> getDeclarationsForArrayDummyVars() {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (Map.Entry<Sort, String> entry : this.mArraySortToDummyVarName.entrySet()) {
            arrayList.add((Declaration)new VariableDeclaration(this.mLocation, new Attribute[0], new VarList[]{new VarList(this.mLocation, new String[]{entry.getValue()}, this.getType(entry.getKey()).toASTType(this.mLocation))}));
        }
        return arrayList;
    }

    public List<Declaration> getDeclarationsForSkolemFunctions() {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (Triple triple : this.mHcSymbolTable.getSkolemFunctions()) {
            VarList[] varListArray = this.getInParamsForSorts(this.getLoc(), (Sort[])triple.getSecond());
            VarList varList = this.getInParamsForSorts(this.getLoc(), new Sort[]{(Sort)triple.getThird()})[0];
            FunctionDeclaration functionDeclaration = new FunctionDeclaration(this.getLoc(), new Attribute[0], (String)triple.getFirst(), new String[0], varListArray, varList);
            arrayList.add((Declaration)functionDeclaration);
        }
        return arrayList;
    }

    void updateLocalVarDecs(List<VariableDeclaration> list, Set<HcVar> set, ILocation iLocation) {
        for (HcVar hcVar : set) {
            String string = hcVar.getGloballyUniqueId();
            Sort sort = hcVar.getSort();
            VarList varList = new VarList(iLocation, new String[]{string}, this.getCorrespondingAstType(iLocation, sort));
            list.add(new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{varList}));
        }
    }

    public Expression translate(Term term) {
        return this.mTerm2Expression.translate(term);
    }

    public HcPredicateSymbol getBottomPredSym() {
        return this.mBottomPredSym;
    }

    public BoogieType getType(Sort sort) {
        return (BoogieType)this.mTypeSortTanslator.getType(sort);
    }

    public HcSymbolTable getSymbolTable() {
        return this.mHcSymbolTable;
    }

    public VariableLHS[] toVariableLhss(Collection<? extends HcVar> collection, DeclarationInformation declarationInformation) {
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>();
        for (HcVar hcVar : collection) {
            arrayList.add(ExpressionFactory.constructVariableLHS((ILocation)this.getLoc(), (BoogieType)((BoogieType)this.mTypeSortTanslator.getType(hcVar.getSort())), (String)hcVar.getGloballyUniqueId(), (DeclarationInformation)declarationInformation));
        }
        return arrayList.toArray(new VariableLHS[arrayList.size()]);
    }

    public Expression getDummyArgForArraySort(Sort sort) {
        Object object = this.mArraySortToDummyVarName.get(sort);
        if (object == null) {
            object = "#dummy~" + HornUtilConstants.sanitzeSortNameForBoogie((Sort)sort);
            this.mArraySortToDummyVarName.put(sort, (String)object);
        }
        return ExpressionFactory.constructIdentifierExpression((ILocation)this.mLocation, (BoogieType)this.getType(sort), (String)object, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
    }
}

