/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.BPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ImplicationMap<T extends IPredicate>
implements IImplicationGraph<T> {
    private final ManagedScript mMgdScript;
    private final BPredicateUnifier mUnifier;
    private final Map<T, Set<T>> mDescendants;
    private final Map<T, Set<T>> mAncestors;
    private final boolean mRandom;

    protected ImplicationMap(ManagedScript managedScript, BPredicateUnifier bPredicateUnifier, T t, T t2, boolean bl) {
        this.mMgdScript = managedScript;
        this.mUnifier = bPredicateUnifier;
        this.mDescendants = new HashMap<T, Set<T>>();
        this.mAncestors = new HashMap<T, Set<T>>();
        this.mRandom = bl;
        this.mDescendants.put(t, new HashSet());
        this.mDescendants.put(t2, new HashSet());
        this.mAncestors.put(t, new HashSet());
        this.mAncestors.put(t2, new HashSet());
        this.mDescendants.get(t).add(t2);
        this.mAncestors.get(t2).add(t);
    }

    protected Map<T, Set<T>> getDescendantsMap() {
        return this.mDescendants;
    }

    protected Map<T, Set<T>> getAncestorsMap() {
        return this.mAncestors;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IPredicate iPredicate : this.mDescendants.keySet()) {
            stringBuilder.append("\n " + String.valueOf(iPredicate) + "is covered by:" + String.valueOf(this.mDescendants.get(iPredicate)));
        }
        return stringBuilder.toString();
    }

    @Override
    public IncrementalPlicationChecker.Validity isCovered(IPredicate iPredicate, IPredicate iPredicate2) {
        if (this.getCoveringPredicates(iPredicate).contains(iPredicate2)) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    @Override
    public Set<IPredicate> getCoveredPredicates(IPredicate iPredicate2) {
        Set<IPredicate> set = this.mAncestors.get(iPredicate2);
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>(set.size() + 1);
        set.forEach(iPredicate -> {
            boolean bl = hashSet.add((IPredicate)iPredicate);
        });
        hashSet.add(iPredicate2);
        return hashSet;
    }

    @Override
    public Set<IPredicate> getCoveringPredicates(IPredicate iPredicate2) {
        Set<IPredicate> set = this.mDescendants.get(iPredicate2);
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>(set.size() + 1);
        set.forEach(iPredicate -> {
            boolean bl = hashSet.add((IPredicate)iPredicate);
        });
        hashSet.add(iPredicate2);
        return hashSet;
    }

    @Override
    public IPartialComparator<IPredicate> getPartialComparator() {
        return (iPredicate, iPredicate2) -> {
            if (!this.mUnifier.isRepresentative((IPredicate)iPredicate) || !this.mUnifier.isRepresentative((IPredicate)iPredicate2)) {
                throw new AssertionError((Object)"predicates unknown to predicate unifier");
            }
            if (iPredicate.equals(iPredicate2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (this.getCoveringPredicates((IPredicate)iPredicate).contains(iPredicate2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            if (this.getCoveringPredicates((IPredicate)iPredicate2).contains(iPredicate)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
    }

    @Override
    public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean unifyPredicate(T t) {
        Set<Object> set;
        HashMap hashMap;
        HashMap<T, Set<T>> hashMap2 = new HashMap<T, Set<T>>(this.mDescendants);
        HashSet hashSet = new HashSet();
        while (!hashMap2.isEmpty()) {
            hashMap = this.chosePivot(hashMap2.keySet(), true);
            Set object2 = (Set)hashMap2.remove(hashMap);
            if (this.internImplication(t, hashMap)) {
                hashSet.add(hashMap);
                hashSet.addAll(object2);
                object2.forEach(iPredicate -> {
                    Object v = hashMap2.remove(iPredicate);
                });
                continue;
            }
            this.mAncestors.get(hashMap).forEach(iPredicate -> {
                Object v = hashMap2.remove(iPredicate);
            });
        }
        hashMap = new HashMap();
        this.mAncestors.get(hashSet.iterator().next()).forEach(iPredicate -> {
            Set<T> set = hashMap.put(iPredicate, this.mAncestors.get(iPredicate));
        });
        for (IPredicate iPredicate3 : hashSet) {
            set = new HashSet(hashMap.keySet());
            for (IPredicate iPredicate4 : set) {
                if (this.mAncestors.get(iPredicate3).contains(iPredicate4)) continue;
                hashMap.remove(iPredicate4);
            }
        }
        HashSet<Object> hashSet2 = new HashSet<Object>();
        while (!hashMap.isEmpty()) {
            Iterator<Object> iterator = this.chosePivot(hashMap.keySet(), false);
            set = (Set)hashMap.remove(iterator);
            if (this.internImplication(iterator, t)) {
                hashSet2.add(iterator);
                hashSet2.addAll(set);
                set.forEach(iPredicate -> {
                    Object v = hashMap.remove(iPredicate);
                });
                continue;
            }
            this.mDescendants.get(iterator).forEach(iPredicate -> {
                Object v = hashMap.remove(iPredicate);
            });
        }
        hashSet2.forEach(iPredicate2 -> {
            boolean bl = this.mDescendants.get(iPredicate2).add(t);
        });
        hashSet.forEach(iPredicate2 -> {
            boolean bl = this.mAncestors.get(iPredicate2).add(t);
        });
        this.mDescendants.put(t, hashSet);
        this.mAncestors.put(t, hashSet2);
        return true;
    }

    private boolean internImplication(T t, T t2) {
        if (t.equals(t2)) {
            return true;
        }
        if (this.mDescendants.containsKey(t) && this.mDescendants.containsKey(t2)) {
            return this.getCoveringPredicates((IPredicate)t).contains(t2);
        }
        Term term = t.getClosedFormula();
        Term term2 = t2.getClosedFormula();
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        Term term3 = this.mMgdScript.term((Object)this, "and", new Term[]{term, this.mMgdScript.term((Object)this, "not", new Term[]{term2})});
        this.mMgdScript.push((Object)this, 1);
        try {
            this.mMgdScript.assertTerm((Object)this, term3);
            Script.LBool lBool = this.mMgdScript.checkSat((Object)this);
            if (lBool == Script.LBool.UNSAT) {
                return true;
            }
            if (lBool == Script.LBool.SAT) {
                return false;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide implication of predicates");
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    private T chosePivot(Set<T> set, boolean bl) {
        if (this.mRandom) {
            return (T)((IPredicate)set.iterator().next());
        }
        int n = 0;
        IPredicate iPredicate = (IPredicate)set.iterator().next();
        for (IPredicate iPredicate2 : set) {
            int n2 = this.mAncestors.get(iPredicate2).size();
            int n3 = this.mDescendants.get(iPredicate2).size();
            if (bl) {
                ++n3;
            } else {
                ++n2;
            }
            int n4 = n2 * n3 / (n2 + n3);
            if (n4 < n) continue;
            n = n4;
            iPredicate = iPredicate2;
        }
        return (T)iPredicate;
    }

    @Override
    public Collection<T> removeImpliedVerticesFromCollection(Collection<T> collection) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        block0: for (IPredicate iPredicate : collection) {
            for (IPredicate iPredicate2 : collection) {
                if (!this.mAncestors.get(iPredicate).contains(iPredicate2)) continue;
                hashSet.remove(iPredicate);
                continue block0;
            }
        }
        return hashSet;
    }

    @Override
    public Collection<T> removeImplyingVerticesFromCollection(Collection<T> collection) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        block0: for (IPredicate iPredicate : collection) {
            for (IPredicate iPredicate2 : collection) {
                if (!this.mDescendants.get(iPredicate).contains(iPredicate2)) continue;
                hashSet.remove(iPredicate);
                continue block0;
            }
        }
        return hashSet;
    }
}

