/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.concurrency;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.abstraction.ICopyActionFactory;

public class IcfgCopyFactory
implements ICopyActionFactory<IcfgEdge> {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final IcfgEdgeBuilder mEdgeBuilder;

    public IcfgCopyFactory(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) {
        this.mEdgeBuilder = new IcfgEdgeBuilder(cfgSmtToolkit, iUltimateServiceProvider, SIMPLIFICATION_TECHNIQUE);
    }

    public IcfgEdge copy(IcfgEdge icfgEdge, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2) {
        if (unmodifiableTransFormula2 == null) {
            if (icfgEdge instanceof IcfgForkThreadCurrentTransition) {
                return this.mEdgeBuilder.constructForkCurrentTransition((IcfgForkThreadCurrentTransition)icfgEdge, unmodifiableTransFormula, false);
            }
            if (icfgEdge instanceof IcfgForkThreadOtherTransition) {
                return this.mEdgeBuilder.constructForkOtherTransition((IcfgForkThreadOtherTransition)icfgEdge, unmodifiableTransFormula, false);
            }
            if (icfgEdge instanceof IcfgJoinThreadCurrentTransition) {
                return this.mEdgeBuilder.constructJoinCurrentTransition((IcfgJoinThreadCurrentTransition)icfgEdge, unmodifiableTransFormula, false);
            }
            if (icfgEdge instanceof IcfgJoinThreadOtherTransition) {
                return this.mEdgeBuilder.constructJoinOtherTransition((IcfgJoinThreadOtherTransition)icfgEdge, unmodifiableTransFormula, false);
            }
            return this.mEdgeBuilder.constructInternalTransition(icfgEdge, (IcfgLocation)icfgEdge.getSource(), (IcfgLocation)icfgEdge.getTarget(), unmodifiableTransFormula);
        }
        if (!(icfgEdge instanceof IActionWithBranchEncoders)) {
            throw new IllegalArgumentException("TF with branch encoders given for action without branch encoders: " + String.valueOf(icfgEdge));
        }
        return this.mEdgeBuilder.constructInternalTransition(icfgEdge, (IcfgLocation)icfgEdge.getSource(), (IcfgLocation)icfgEdge.getTarget(), unmodifiableTransFormula, unmodifiableTransFormula2, false);
    }
}

