/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.ISuccessorTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import java.util.Collection;
import java.util.Set;

public class SimpleSuccessorTransitionProvider<LETTER, PLACE>
implements ISuccessorTransitionProvider<LETTER, PLACE> {
    private final Collection<Transition<LETTER, PLACE>> mTransitions;

    public SimpleSuccessorTransitionProvider(Collection<Transition<LETTER, PLACE>> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("need at least one transition");
        }
        this.mTransitions = collection;
        assert (PetriNetUtils.similarPredecessorPlaces(collection)) : "not all transitions have similar predecessor places";
    }

    @Override
    public Set<PLACE> getPredecessorPlaces() {
        return this.mTransitions.iterator().next().getPredecessors();
    }

    @Override
    public Collection<Transition<LETTER, PLACE>> getTransitions() {
        return this.mTransitions;
    }

    public String toString() {
        return this.getPredecessorPlaces().toString();
    }
}

