/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ParallelComposer
extends BaseBlockEncoder<IcfgLocation> {
    private int mEdgesRemoved = 0;
    private final IcfgEdgeBuilder mEdgeBuilder;

    public ParallelComposer(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mEdgeBuilder = icfgEdgeBuilder;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        this.mLogger.info((Object)"Creating parallel compositions");
        ArrayDeque<IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        arrayDeque.addAll(basicIcfg.getInitialNodes());
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            if (!hashSet.add(icfgLocation)) continue;
            List list = icfgLocation.getOutgoingEdges();
            HashMap hashMap = new HashMap();
            list.stream().forEach(icfgEdge -> {
                Map<IcfgLocation, List<IcfgEdge>> map2 = ParallelComposer.addToPartition(hashMap, icfgEdge);
            });
            for (Map.Entry entry : hashMap.entrySet()) {
                IcfgLocation icfgLocation2 = (IcfgLocation)entry.getKey();
                arrayDeque.add(icfgLocation2);
                List list2 = (List)entry.getValue();
                int n = list2.size();
                if (n <= 1) continue;
                Map map = this.mEdgeBuilder.constructBranchIndicatorToEdgeMapping(list2);
                IcfgInternalTransition icfgInternalTransition = this.mEdgeBuilder.constructParallelComposition(icfgLocation, icfgLocation2, map);
                this.rememberEdgeMapping((IIcfgTransition<IcfgLocation>)icfgInternalTransition, map);
                icfgLocation.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition);
                icfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition);
                list2.stream().forEach(ParallelComposer::disconnect);
                this.mEdgesRemoved += n;
            }
        }
        return basicIcfg;
    }

    private static Map<IcfgLocation, List<IcfgEdge>> addToPartition(Map<IcfgLocation, List<IcfgEdge>> map, IcfgEdge icfgEdge) {
        if (!(icfgEdge instanceof IIcfgInternalTransition)) {
            return map;
        }
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
        List<IcfgEdge> list = map.get(icfgLocation);
        if (list == null) {
            ArrayList<IcfgEdge> arrayList = new ArrayList<IcfgEdge>();
            arrayList.add(icfgEdge);
            map.put(icfgLocation, arrayList);
        } else {
            list.add(icfgEdge);
        }
        return map;
    }

    private static void disconnect(IcfgEdge icfgEdge) {
        icfgEdge.disconnectSource();
        icfgEdge.disconnectTarget();
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mEdgesRemoved > 0;
    }
}

