/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;

public class EqualityProxy {
    private static final TrueEqualityProxy TRUE = new TrueEqualityProxy();
    private static final FalseEqualityProxy FALSE = new FalseEqualityProxy();
    final Clausifier mClausifier;
    final Term mLhs;
    final Term mRhs;

    public static TrueEqualityProxy getTrueProxy() {
        return TRUE;
    }

    public static FalseEqualityProxy getFalseProxy() {
        return FALSE;
    }

    public EqualityProxy(Clausifier clausifier, Term term, Term term2) {
        this.mClausifier = clausifier;
        this.mLhs = term;
        this.mRhs = term2;
    }

    public LAEquality createLAEquality() {
        Polynomial polynomial = new Polynomial(this.mLhs);
        polynomial.add(Rational.MONE, this.mRhs);
        return this.mClausifier.getLASolver().createEquality(this.mClausifier.createMutableAffinTerm(polynomial, null));
    }

    public Rational computeNormFactor(Term term, Term term2) {
        Polynomial polynomial = new Polynomial(term);
        polynomial.add(Rational.MONE, term2);
        return polynomial.getGcd().inverse();
    }

    public CCEquality createCCEquality(Term term, Term term2) {
        Rational rational;
        LAEquality lAEquality;
        CCEquality cCEquality2;
        assert (term.getSort().isNumericSort());
        CCTerm cCTerm = this.mClausifier.getCCTerm(term);
        CCTerm cCTerm2 = this.mClausifier.getCCTerm(term2);
        assert (cCTerm != null && cCTerm2 != null);
        DPLLAtom dPLLAtom = this.getLiteral(null);
        if (dPLLAtom instanceof CCEquality) {
            cCEquality2 = (CCEquality)dPLLAtom;
            lAEquality = cCEquality2.getLASharedData();
            if (lAEquality == null) {
                rational = this.computeNormFactor(this.mLhs, this.mRhs);
                lAEquality = this.createLAEquality();
                lAEquality.addDependentAtom(cCEquality2);
                cCEquality2.setLASharedData(lAEquality, rational);
            }
        } else {
            lAEquality = (LAEquality)dPLLAtom;
        }
        for (CCEquality cCEquality2 : lAEquality.getDependentEqualities()) {
            assert (cCEquality2.getLASharedData() == lAEquality);
            if (cCEquality2.getLhs() == cCTerm && cCEquality2.getRhs() == cCTerm2) {
                return cCEquality2;
            }
            if (cCEquality2.getRhs() != cCTerm || cCEquality2.getLhs() != cCTerm2) continue;
            return cCEquality2;
        }
        cCEquality2 = this.mClausifier.getCClosure().createCCEquality(this.mClausifier.getStackLevel(), cCTerm, cCTerm2);
        rational = this.computeNormFactor(term, term2);
        lAEquality.addDependentAtom(cCEquality2);
        cCEquality2.setLASharedData(lAEquality, rational);
        return cCEquality2;
    }

    private DPLLAtom createAtom(Term term, SourceAnnotation sourceAnnotation) {
        boolean bl;
        this.mClausifier.addTermAxioms(this.mLhs, sourceAnnotation);
        this.mClausifier.addTermAxioms(this.mRhs, sourceAnnotation);
        CCTerm cCTerm = this.mClausifier.getCCTerm(this.mLhs);
        CCTerm cCTerm2 = this.mClausifier.getCCTerm(this.mRhs);
        boolean bl2 = this.mClausifier.getLATerm(this.mLhs) != null;
        boolean bl3 = bl = this.mClausifier.getLATerm(this.mRhs) != null;
        if (cCTerm == null && cCTerm2 == null) {
            if ((this.mClausifier.getCClosure() == null || bl2) && !bl) {
                this.mClausifier.createLinVar(this.mRhs, sourceAnnotation);
                bl = true;
            }
            if ((this.mClausifier.getCClosure() == null || bl) && !bl2) {
                this.mClausifier.createLinVar(this.mLhs, sourceAnnotation);
                bl2 = true;
            }
        }
        if (bl2 && bl) {
            return this.createLAEquality();
        }
        CCTerm cCTerm3 = this.mClausifier.createCCTerm(this.mLhs, sourceAnnotation);
        CCTerm cCTerm4 = this.mClausifier.createCCTerm(this.mRhs, sourceAnnotation);
        DPLLAtom dPLLAtom = (DPLLAtom)this.mClausifier.getILiteral(term);
        if (dPLLAtom != null) {
            return dPLLAtom;
        }
        return this.mClausifier.getCClosure().createCCEquality(this.mClausifier.getStackLevel(), cCTerm3, cCTerm4);
    }

    public DPLLAtom getLiteral(SourceAnnotation sourceAnnotation) {
        Term term = this.mLhs.getTheory().term("=", new Term[]{this.mLhs, this.mRhs});
        DPLLAtom dPLLAtom = (DPLLAtom)this.mClausifier.getILiteral(term);
        if (dPLLAtom == null) {
            dPLLAtom = this.createAtom(term, sourceAnnotation);
            this.mClausifier.getLogger().debug("Created Equality: %s", dPLLAtom);
            this.mClausifier.setTermFlags(term, this.mClausifier.getTermFlags(term) | 4 | 8);
            this.mClausifier.setLiteral(term, dPLLAtom);
        }
        return dPLLAtom;
    }

    public String toString() {
        PrintTerm printTerm = new PrintTerm();
        StringBuilder stringBuilder = new StringBuilder();
        printTerm.append((Appendable)stringBuilder, this.mLhs);
        stringBuilder.append(" == ");
        printTerm.append((Appendable)stringBuilder, this.mRhs);
        return stringBuilder.toString();
    }

    public static final class FalseEqualityProxy
    extends EqualityProxy {
        private FalseEqualityProxy() {
            super(null, null, null);
        }

        @Override
        public DPLLAtom getLiteral(SourceAnnotation sourceAnnotation) {
            throw new InternalError("Should never be called");
        }
    }

    public static final class TrueEqualityProxy
    extends EqualityProxy {
        private TrueEqualityProxy() {
            super(null, null, null);
        }

        @Override
        public DPLLAtom getLiteral(SourceAnnotation sourceAnnotation) {
            throw new InternalError("Should never be called");
        }
    }
}

