/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeometricNonTerminationArgument
extends NonTerminationArgument
implements Serializable {
    private static final long serialVersionUID = 4606815082909883553L;
    private final Map<IProgramVar, Rational> mStateInit;
    private final Map<IProgramVar, Rational> mStateHonda;
    private final List<Map<IProgramVar, Rational>> mGEVs;
    private final List<Rational> mLambdas;
    private final List<Rational> mNus;

    public GeometricNonTerminationArgument(Map<IProgramVar, Rational> map, Map<IProgramVar, Rational> map2, List<Map<IProgramVar, Rational>> list, List<Rational> list2, List<Rational> list3) {
        assert (map != null);
        this.mStateInit = map;
        assert (map2 != null);
        this.mStateHonda = map2;
        assert (list != null);
        this.mGEVs = list;
        assert (list2 != null);
        this.mLambdas = list2;
        assert (list3 != null);
        this.mNus = list3;
        assert (this.mGEVs.size() == list2.size());
        assert (this.mGEVs.size() == list3.size() + 1 || this.mGEVs.isEmpty());
    }

    public GeometricNonTerminationArgument join(GeometricNonTerminationArgument geometricNonTerminationArgument) {
        for (IProgramVar object2 : this.mStateInit.keySet()) {
            if (geometricNonTerminationArgument.mStateInit.containsKey(object2)) assert (this.mStateInit.get(object2).equals((Object)geometricNonTerminationArgument.mStateInit.get(object2)));
        }
        for (IProgramVar iProgramVar : this.mStateHonda.keySet()) {
            if (geometricNonTerminationArgument.mStateHonda.containsKey(iProgramVar)) assert (this.mStateHonda.get(iProgramVar).equals((Object)geometricNonTerminationArgument.mStateHonda.get(iProgramVar)));
        }
        HashMap<IProgramVar, Rational> hashMap = new HashMap<IProgramVar, Rational>();
        HashMap hashMap2 = new HashMap();
        ArrayList<Map<IProgramVar, Rational>> arrayList = new ArrayList<Map<IProgramVar, Rational>>();
        ArrayList<Rational> arrayList2 = new ArrayList<Rational>();
        ArrayList<Rational> arrayList3 = new ArrayList<Rational>();
        hashMap.putAll(this.mStateInit);
        hashMap.putAll(geometricNonTerminationArgument.mStateInit);
        hashMap2.putAll(this.mStateHonda);
        hashMap2.putAll(geometricNonTerminationArgument.mStateHonda);
        arrayList.addAll(this.mGEVs);
        arrayList.addAll(geometricNonTerminationArgument.mGEVs);
        arrayList2.addAll(this.mLambdas);
        arrayList2.addAll(geometricNonTerminationArgument.mLambdas);
        arrayList3.addAll(this.mNus);
        if (!this.mGEVs.isEmpty() && !geometricNonTerminationArgument.mGEVs.isEmpty()) {
            arrayList3.add(Rational.ZERO);
        }
        arrayList3.addAll(geometricNonTerminationArgument.mNus);
        return new GeometricNonTerminationArgument(hashMap, hashMap2, arrayList, arrayList2, arrayList3);
    }

    public Map<IProgramVar, Rational> getStateInit() {
        return Collections.unmodifiableMap(this.mStateInit);
    }

    public Map<IProgramVar, Rational> getStateHonda() {
        return Collections.unmodifiableMap(this.mStateHonda);
    }

    public int getNumberOfGEVs() {
        return this.mGEVs.size();
    }

    public List<Map<IProgramVar, Rational>> getGEVs() {
        ArrayList<Map<IProgramVar, Rational>> arrayList = new ArrayList<Map<IProgramVar, Rational>>();
        for (Map<IProgramVar, Rational> map : this.mGEVs) {
            arrayList.add(Collections.unmodifiableMap(map));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<Rational> getLambdas() {
        return Collections.unmodifiableList(this.mLambdas);
    }

    public List<Rational> getNus() {
        return Collections.unmodifiableList(this.mNus);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Non-Termination argument consisting of: ");
        stringBuilder.append("Initial state: ");
        stringBuilder.append(this.mStateInit);
        stringBuilder.append(" Honda state: ");
        stringBuilder.append(this.mStateHonda);
        stringBuilder.append(" Generalized eigenvectors: ");
        stringBuilder.append(this.mGEVs);
        stringBuilder.append(" Lambdas: ");
        stringBuilder.append(this.mLambdas);
        stringBuilder.append(" Nus: ");
        stringBuilder.append(this.mNus);
        return stringBuilder.toString();
    }
}

