/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ThreadIdManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.HeapLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTUnaryExpression;

public class PthreadLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final FlatSymbolTable mSymboltable;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final MemoryHandler mMemoryHandler;
    private final ITypeHandler mTypeHandler;
    private final TypeSizes mTypeSizes;
    private final ProcedureManager mProcedureManager;
    private final ThreadIdManager mThreadIdManager;

    public PthreadLibraryModel(FunctionModelHelper functionModelHelper, FlatSymbolTable flatSymbolTable, AuxVarInfoBuilder auxVarInfoBuilder, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, MemoryHandler memoryHandler, ITypeHandler iTypeHandler, TypeSizes typeSizes, ProcedureManager procedureManager) {
        this.mHelper = functionModelHelper;
        this.mSymboltable = flatSymbolTable;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mMemoryHandler = memoryHandler;
        this.mTypeHandler = iTypeHandler;
        this.mTypeSizes = typeSizes;
        this.mProcedureManager = procedureManager;
        this.mThreadIdManager = new ThreadIdManager(this.mAuxVarInfoBuilder, this.mExprResultTransformer, this.mExpressionTranslation, this.mMemoryHandler, this.mTypeHandler, this.mTypeSizes, null, flatSymbolTable);
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        return List.of(new ILibraryModel.FunctionModel("pthread_create", this::handlePthread_create), new ILibraryModel.FunctionModel("pthread_join", this::handlePthread_join), new ILibraryModel.FunctionModel("pthread_mutex_init", this::handlePthread_mutex_init), new ILibraryModel.FunctionModel("pthread_mutex_lock", this::handlePthread_mutex_lock), new ILibraryModel.FunctionModel("pthread_mutex_trylock", this::handlePthread_mutex_trylock), new ILibraryModel.FunctionModel("pthread_mutex_unlock", this::handlePthread_mutex_unlock), new ILibraryModel.FunctionModel("pthread_exit", this::handlePthread_exit), new ILibraryModel.FunctionModel("pthread_detach", this::handlePthread_detach), new ILibraryModel.FunctionModel("pthread_cond_init", this::handlePthread_success), new ILibraryModel.FunctionModel("pthread_cond_wait", this::handlePthread_cond_wait), new ILibraryModel.FunctionModel("pthread_cond_signal", this::handlePthread_success), new ILibraryModel.FunctionModel("pthread_cond_broadcast", this::handlePthread_success), new ILibraryModel.FunctionModel("pthread_cond_destroy", this::handlePthread_success), new ILibraryModel.FunctionModel("pthread_mutex_destroy", this::handlePthread_success), new ILibraryModel.FunctionModel("pthread_rwlock_rdlock", this::handlePthread_rwlock_rdlock), new ILibraryModel.FunctionModel("pthread_rwlock_wrlock", this::handlePthread_rwlock_wrlock), new ILibraryModel.FunctionModel("pthread_rwlock_unlock", this::handlePthread_rwlock_unlock));
    }

    @Override
    public Collection<String> getUnsupportedFunctions() {
        return List.of("pthread_attr_init", "pthread_attr_setdetachstate", "pthread_attr_destroy", "pthread_key_create", "pthread_getspecific", "pthread_setspecific", "pthread_rwlock_init");
    }

    private Result handlePthread_create(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        Expression[] expressionArray;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 4, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[2]);
        Object object = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[3]);
        ExpressionResult expressionResult3 = this.mExprResultTransformer.performImplicitConversion((ExpressionResult)object, CPointer.voidPointer(), iLocation);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3);
        object = this.getForkedProcedure(iASTFunctionCallExpression, iASTInitializerClauseArray[2], expressionResult2);
        CFunction cFunction = this.mProcedureManager.getCFunctionType((String)object);
        int n = cFunction.getParameterTypes().length;
        if (n == 0) {
            expressionArray = new Expression[]{};
        } else if (n == 1) {
            expressionArray = new Expression[]{expressionResult3.getLrValue().getValue()};
        } else {
            throw new UnsupportedSyntaxException(iLocation, "pthread_create calls function with more than one argument");
        }
        Expression[] expressionArray2 = this.mThreadIdManager.updateForkedThreadId(iASTInitializerClauseArray[0], iDispatcher, iLocation, (IASTNode)iASTFunctionCallExpression, expressionResultBuilder);
        ForkStatement forkStatement = new ForkStatement(iLocation, expressionArray2, (String)object, expressionArray);
        this.mProcedureManager.registerForkStatement(forkStatement);
        expressionResultBuilder.addStatement((Statement)forkStatement);
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        Object object2 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object2);
        IdentifierExpression identifierExpression = ((AuxVarInfo)object2).getExp();
        object2 = new RValue((Expression)identifierExpression, cPrimitive);
        expressionResultBuilder.setLrValue((LRValue)object2);
        return expressionResultBuilder.build();
    }

    private String getForkedProcedure(IASTFunctionCallExpression iASTFunctionCallExpression, IASTInitializerClause iASTInitializerClause, ExpressionResult expressionResult) {
        CASTIdExpression cASTIdExpression;
        String string;
        Object object;
        if (iASTInitializerClause instanceof CASTIdExpression) {
            object = (CASTIdExpression)iASTInitializerClause;
            string = object.getName().toString();
        } else if (iASTInitializerClause instanceof CASTUnaryExpression) {
            object = (CASTUnaryExpression)iASTInitializerClause;
            if (object.getOperator() != 5) {
                throw new UnsupportedOperationException("Third argument of pthread_create is: " + iASTInitializerClause.getClass().getSimpleName());
            }
            if (!(object.getOperand() instanceof CASTIdExpression)) {
                throw new UnsupportedOperationException("Third argument of pthread_create is: " + object.getOperand().getClass().getSimpleName());
            }
            cASTIdExpression = (CASTIdExpression)object.getOperand();
            string = cASTIdExpression.getName().toString();
        } else {
            throw new UnsupportedOperationException("Third argument of pthread_create is " + iASTInitializerClause.getClass().getSimpleName());
        }
        object = this.mSymboltable.applyMultiparseRenaming(iASTFunctionCallExpression.getContainingFilename(), string);
        if (!this.mProcedureManager.hasProcedure((String)object)) {
            throw new UnsupportedOperationException("cannot find function " + (String)object + " Ultimate does not support pthread_create in combination with function pointers");
        }
        cASTIdExpression = (IdentifierExpression)expressionResult.getLrValue().getValue();
        String string2 = cASTIdExpression.getIdentifier().substring(0, 9);
        if (!string2.equals("#funAddr~")) {
            throw new UnsupportedOperationException("unable to decode " + cASTIdExpression.getIdentifier());
        }
        String string3 = cASTIdExpression.getIdentifier().substring(9);
        return string3;
    }

    private Result handlePthread_success(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.setLrValue(new RValue(this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.ZERO), new CPrimitive(CPrimitive.CPrimitives.INT)));
        return expressionResultBuilder.build();
    }

    private Result handlePthread_join(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        Expression[] expressionArray = this.mThreadIdManager.getJoinedThreadId(iASTInitializerClauseArray[0], iDispatcher, iLocation, expressionResultBuilder);
        ExpressionResult expressionResult = (ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClauseArray[1]);
        Object object = this.mExprResultTransformer.performImplicitConversion(expressionResult, CPointer.voidPointer(), iLocation);
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
        LRValue lRValue = ((ExpressionResult)object).getLrValue();
        if (lRValue.isNullPointerConstant()) {
            expressionResult = new JoinStatement(iLocation, expressionArray, new VariableLHS[0]);
            expressionResultBuilder.addStatement((Statement)expressionResult);
        } else {
            object = CPointer.voidPointer();
            AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, (ICType)object, SFO.AUXVAR.RETURNED);
            expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
            expressionResult = new JoinStatement(iLocation, expressionArray, new VariableLHS[]{auxVarInfo.getLhs()});
            expressionResultBuilder.addStatement((Statement)expressionResult);
            HeapLValue heapLValue = lRValue instanceof HeapLValue ? (HeapLValue)lRValue : LRValueFactory.constructHeapLValue(this.mTypeHandler, lRValue.getValue(), (ICType)object, false, null);
            List<Statement> list = this.mMemoryHandler.getWriteCall(iLocation, heapLValue, (Expression)auxVarInfo.getExp(), (ICType)object, false);
            expressionResultBuilder.addStatements(list);
        }
        expressionResultBuilder.setLrValue(new RValue(this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.ZERO), new CPrimitive(CPrimitive.CPrimitives.INT)));
        return expressionResultBuilder.build();
    }

    private Result handlePthread_exit(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        this.mMemoryHandler.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX);
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.performImplicitConversion(expressionResult, CPointer.voidPointer(), iLocation);
        BoogieType boogieType = this.mTypeHandler.getBoogiePointerType();
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, this.mProcedureManager.getCurrentProcedureID());
        LeftHandSide[] leftHandSideArray = new LeftHandSide[]{new VariableLHS(iLocation, (IBoogieType)boogieType, "#res", declarationInformation)};
        AssignmentStatement assignmentStatement = new AssignmentStatement(iLocation, leftHandSideArray, new Expression[]{expressionResult2.getLrValue().getValue()});
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
        expressionResultBuilder.addStatement((Statement)new ReturnStatement(iLocation));
        return expressionResultBuilder.build();
    }

    private Result handlePthread_detach(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]));
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        this.mExpressionTranslation.addAssumeValueInRangeStatements(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive, expressionResultBuilder);
        return expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPrimitive)).build();
    }

    private Result handlePthread_cond_wait(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.createPthread_mutex_unlock(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        ExpressionResult expressionResult2 = this.createPthread_mutex_lock(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult2);
        expressionResultBuilder.setLrValue(new RValue(this.mTypeSizes.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.ZERO), new CPrimitive(CPrimitive.CPrimitives.INT)));
        return expressionResultBuilder.build();
    }

    private Result handlePthread_mutex_lock(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleLockCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, this.mMemoryHandler::constructPthreadMutexLockCall);
    }

    private Result handlePthread_mutex_unlock(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleLockCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, this.mMemoryHandler::constructPthreadMutexUnlockCall);
    }

    private Result handlePthread_mutex_trylock(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleLockCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, this.mMemoryHandler::constructPthreadMutexTryLockCall);
    }

    private Result handlePthread_rwlock_rdlock(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleLockCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, this.mMemoryHandler::constructPthreadRwLockReadLockCall);
    }

    private Result handlePthread_rwlock_wrlock(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleLockCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, this.mMemoryHandler::constructPthreadRwLockWriteLockCall);
    }

    private Result handlePthread_rwlock_unlock(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleLockCall(iDispatcher, iASTFunctionCallExpression, iLocation, string, this.mMemoryHandler::constructPthreadRwLockUnlockCall);
    }

    private ExpressionResult createPthread_mutex_lock(IDispatcher iDispatcher, ILocation iLocation, IASTInitializerClause iASTInitializerClause) {
        return this.handleLockCall(iDispatcher, iLocation, "pthread_mutex_lock", iASTInitializerClause, this.mMemoryHandler::constructPthreadMutexLockCall);
    }

    private ExpressionResult createPthread_mutex_unlock(IDispatcher iDispatcher, ILocation iLocation, IASTInitializerClause iASTInitializerClause) {
        return this.handleLockCall(iDispatcher, iLocation, "pthread_mutex_unlock", iASTInitializerClause, this.mMemoryHandler::constructPthreadMutexUnlockCall);
    }

    private ExpressionResult handleLockCall(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, ILockCallFactory iLockCallFactory) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        IASTInitializerClause iASTInitializerClause = iASTInitializerClauseArray[0];
        return this.handleLockCall(iDispatcher, iLocation, string, iASTInitializerClause, iLockCallFactory);
    }

    private ExpressionResult handleLockCall(IDispatcher iDispatcher, ILocation iLocation, String string, IASTInitializerClause iASTInitializerClause, ILockCallFactory iLockCallFactory) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClause);
        Expression expression = expressionResult.getLrValue().getValue();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement(iLockCallFactory.apply(iLocation, expression, auxVarInfo.getLhs()));
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), new CPrimitive(CPrimitive.CPrimitives.INT)));
        return expressionResultBuilder.build();
    }

    private Result handlePthread_mutex_init(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        this.mMemoryHandler.requireMemoryModelFeature(MemoryModelDeclarations.ULTIMATE_PTHREADS_MUTEX);
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        boolean bl = this.mMemoryHandler.isNullPointerLiteral(expressionResult2.getLrValue().getValue());
        if (!bl) {
            throw new UnsupportedSyntaxException(iLocation, "The second argument of the pthread_mutex_init is not a null pointer. This means that non-default attributes are used. We support only the default attributes.");
        }
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        BigInteger bigInteger = BigInteger.ZERO;
        Expression expression = expressionResult.getLrValue().getValue();
        AssignmentStatement assignmentStatement = this.mMemoryHandler.constructMutexArrayAssignment(iLocation, expression, false);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addStatement((Statement)assignmentStatement);
        expressionResultBuilder.setLrValue(new RValue(this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, bigInteger), new CPrimitive(CPrimitive.CPrimitives.INT)));
        return expressionResultBuilder.build();
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("pthread_t", this.mTypeHandler.getThreadIdType()), new ILibraryModel.TypeModel("__pthread_list_t", CPointer.voidPointer()), new ILibraryModel.TypeModel("pthread_mutex_t", new CPrimitive(CPrimitive.CPrimitives.INT)), new ILibraryModel.TypeModel("pthread_rwlock_t", new CPrimitive(CPrimitive.CPrimitives.INT)), new ILibraryModel.TypeModel("pthread_cond_t", new CPrimitive(CPrimitive.CPrimitives.INT)));
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        return List.of(new ILibraryModel.ConstantModel("PTHREAD_MUTEX_INITIALIZER", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, BigInteger.ZERO, new CPrimitive(CPrimitive.CPrimitives.INT))), new ILibraryModel.ConstantModel("PTHREAD_RWLOCK_INITIALIZER", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, BigInteger.ZERO, new CPrimitive(CPrimitive.CPrimitives.INT))), new ILibraryModel.ConstantModel("PTHREAD_COND_INITIALIZER", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, BigInteger.ZERO, new CPrimitive(CPrimitive.CPrimitives.INT))));
    }

    private static interface ILockCallFactory {
        public Statement apply(ILocation var1, Expression var2, VariableLHS var3);
    }
}

