/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ScopedLinkedHashMap<K, V>
extends AbstractMap<K, V> {
    private final LinkedHashMap<K, V> mMap = new LinkedHashMap();
    private HashMap<K, V>[] mHistory = new HashMap[5];
    int mCurScope = -1;
    private final boolean mShrink;

    public ScopedLinkedHashMap() {
        this(true);
    }

    public ScopedLinkedHashMap(boolean bl) {
        this.mShrink = bl;
    }

    private HashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    private void recordUndo(K k, V v) {
        HashMap<K, V> hashMap;
        if (this.mCurScope != -1 && !(hashMap = this.undoMap()).containsKey(k)) {
            hashMap.put(k, v);
        }
    }

    private void undoEntry(Map.Entry<K, V> entry) {
        if (entry.getValue() == null) {
            this.mMap.remove(entry.getKey());
        } else {
            this.mMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = (HashMap[])ScopeUtils.grow((Object[])this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new HashMap();
    }

    public void endScope() {
        for (Map.Entry<K, V> entry : this.undoMap().entrySet()) {
            this.undoEntry(entry);
        }
        this.mHistory[this.mCurScope--] = null;
        if (this.mShrink && ScopeUtils.shouldShrink((Object[])this.mHistory)) {
            this.mHistory = (HashMap[])ScopeUtils.shrink((Object[])this.mHistory);
        }
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new HashMap[5];
    }

    @Override
    public boolean containsKey(Object object) {
        return this.mMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.mMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.mMap.get(object);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = (this).ScopedLinkedHashMap.this.mMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedLinkedHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ScopedLinkedHashMap.this.mMap.size();
            }
        };
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        V v2 = this.mMap.put(k, v);
        this.recordUndo(k, v2);
        return v2;
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException("ScopedLinkedHashMap doesn't allow remove");
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }

    public boolean overwritesKeyInScope(Object object, int n) {
        assert (n != 0);
        return this.mHistory[n - 1].containsKey(object);
    }
}

