/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound.CompoundDomainPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound.CompoundDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound.CompoundDomainWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import java.util.List;
import java.util.stream.Collectors;

public class CompoundDomain
implements IAbstractDomain<CompoundDomainState, IcfgEdge> {
    private final IUltimateServiceProvider mServices;
    private final List<IAbstractDomain> mDomainList;
    private final BoogieIcfgContainer mRootAnnotation;
    private IAbstractStateBinaryOperator<CompoundDomainState> mWideningOperator;
    private IAbstractPostOperator<CompoundDomainState, IcfgEdge> mPostOperator;

    public CompoundDomain(IUltimateServiceProvider iUltimateServiceProvider, List<IAbstractDomain> list, BoogieIcfgContainer boogieIcfgContainer) {
        this.mServices = iUltimateServiceProvider;
        this.mDomainList = list;
        this.mRootAnnotation = boogieIcfgContainer;
    }

    public CompoundDomainState createTopState() {
        return new CompoundDomainState(this.mServices, this.mDomainList, false);
    }

    public CompoundDomainState createBottomState() {
        return new CompoundDomainState(this.mServices, this.mDomainList, true);
    }

    public IAbstractStateBinaryOperator<CompoundDomainState> getWideningOperator() {
        if (this.mWideningOperator == null) {
            this.mWideningOperator = new CompoundDomainWideningOperator(this.mServices);
        }
        return this.mWideningOperator;
    }

    public IAbstractPostOperator<CompoundDomainState, IcfgEdge> getPostOperator() {
        if (this.mPostOperator == null) {
            this.mPostOperator = new CompoundDomainPostOperator(this.mServices, this.mRootAnnotation);
        }
        return this.mPostOperator;
    }

    public String domainDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.domainDescription());
        stringBuilder.append(" [");
        stringBuilder.append(this.mDomainList.stream().map(iAbstractDomain -> iAbstractDomain.domainDescription()).collect(Collectors.joining(", ")));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void beforeFixpointComputation(Object ... objectArray) {
        for (IAbstractDomain iAbstractDomain : this.mDomainList) {
            iAbstractDomain.beforeFixpointComputation(objectArray);
        }
    }

    public boolean isAbstractable(Term term) {
        return this.mDomainList.stream().anyMatch(iAbstractDomain -> iAbstractDomain.isAbstractable(term));
    }
}

