/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraint;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingConstraintDrdCheck;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.PowersetIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class BarelyCoveredLevelRankingsGenerator<LETTER, STATE>
extends LevelRankingGenerator<LETTER, STATE, LevelRankingConstraintDrdCheck<LETTER, STATE>> {
    private static final boolean OMIT_NON_ACCEPTING_SINK = true;
    private static final boolean DEBUG_ENABLE_SUCCESS_GUIDE_OPTIMIZATION = false;
    private final boolean mAllowEmptyLevelRanking;
    private final boolean mAllowRankZero;
    private final boolean mRestrictToElasticLevelRankings;
    private final EnumSet<LevelRankingConstraint.VoluntaryRankDecrease> mVoluntaryRankDecrease;

    public BarelyCoveredLevelRankingsGenerator(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, int n, boolean bl, boolean bl2, boolean bl3, EnumSet<LevelRankingConstraint.VoluntaryRankDecrease> enumSet) {
        super(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, n);
        this.mAllowRankZero = bl;
        this.mAllowEmptyLevelRanking = bl2;
        this.mRestrictToElasticLevelRankings = bl3;
        this.mVoluntaryRankDecrease = enumSet;
    }

    @Override
    public Collection<LevelRankingState<LETTER, STATE>> generateLevelRankings(LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck, boolean bl) {
        if (!this.mAllowEmptyLevelRanking && levelRankingConstraintDrdCheck.isEmpty()) {
            return Collections.emptyList();
        }
        if (levelRankingConstraintDrdCheck.isNonAcceptingSink()) {
            return Collections.emptyList();
        }
        ArrayList<LevelRankingState<LETTER, STATE>> arrayList = new ArrayList<LevelRankingState<LETTER, STATE>>();
        ArrayList arrayList2 = new ArrayList();
        for (StateWithRankInfo powersetIterator2 : levelRankingConstraintDrdCheck.getDownStates()) {
            for (StateWithRankInfo stateWithRankInfo : levelRankingConstraintDrdCheck.getUpStates(powersetIterator2)) {
                DoubleDecker doubleDecker = new DoubleDecker(powersetIterator2, stateWithRankInfo);
                if (!this.evenRankAndNotFinal(levelRankingConstraintDrdCheck, doubleDecker)) continue;
                boolean bl2 = false;
                if (this.mVoluntaryRankDecrease.contains((Object)LevelRankingConstraint.VoluntaryRankDecrease.ALWAYS)) {
                    bl2 = true;
                }
                if (this.mVoluntaryRankDecrease.contains((Object)LevelRankingConstraint.VoluntaryRankDecrease.ALL_EVEN_PREDECESSORS_ARE_ACCEPTING)) {
                    bl2 |= LevelRankingConstraint.areAllEvenPredecessorsAccepting(doubleDecker, levelRankingConstraintDrdCheck);
                }
                if (this.mVoluntaryRankDecrease.contains((Object)LevelRankingConstraint.VoluntaryRankDecrease.ALLOWS_O_ESCAPE)) {
                    bl2 |= LevelRankingConstraint.allowsOEscape(doubleDecker, levelRankingConstraintDrdCheck);
                }
                if (this.mVoluntaryRankDecrease.contains((Object)LevelRankingConstraint.VoluntaryRankDecrease.PREDECESSOR_HAS_EMPTY_O)) {
                    bl2 |= LevelRankingConstraint.predecessorHasEmptyO(doubleDecker, levelRankingConstraintDrdCheck);
                }
                if (this.mVoluntaryRankDecrease.contains((Object)LevelRankingConstraint.VoluntaryRankDecrease.ALLOWS_O_ESCAPE_AND_ALL_EVEN_PREDECESSORS_ARE_ACCEPTING)) {
                    bl2 |= LevelRankingConstraint.allowsOEscape(doubleDecker, levelRankingConstraintDrdCheck) && levelRankingConstraintDrdCheck.allEvenPredecessorsAreAcceptingOrNotInO(doubleDecker.getDown(), doubleDecker.getUp().getState());
                }
                if (!bl2) continue;
                arrayList2.add(doubleDecker);
            }
        }
        PowersetIterator powersetIterator = new PowersetIterator(arrayList2);
        while (powersetIterator.hasNext()) {
            Set set = (Set)powersetIterator.next();
            LevelRankingState levelRankingState = this.computeLevelRanking(levelRankingConstraintDrdCheck, set);
            if (levelRankingState == null || this.mRestrictToElasticLevelRankings && !levelRankingState.isElastic()) continue;
            arrayList.add(levelRankingState);
        }
        return arrayList;
    }

    private boolean isSuccessGuided(LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck, Set<DoubleDecker<StateWithRankInfo<STATE>>> set) {
        if (set.isEmpty()) {
            return true;
        }
        for (StateWithRankInfo stateWithRankInfo : levelRankingConstraintDrdCheck.getDownStates()) {
            for (StateWithRankInfo stateWithRankInfo2 : levelRankingConstraintDrdCheck.getUpStates(stateWithRankInfo)) {
                if (!stateWithRankInfo2.isInO() || this.mOperand.isFinal(stateWithRankInfo2.getState()) || set.contains(new DoubleDecker(stateWithRankInfo, stateWithRankInfo2))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean evenRankAndNotFinal(LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck, DoubleDecker<StateWithRankInfo<STATE>> doubleDecker) {
        return LevelRankingState.isEven(levelRankingConstraintDrdCheck.getRank(doubleDecker.getDown(), doubleDecker.getUp().getState())) && !this.mOperand.isFinal(doubleDecker.getUp().getState());
    }

    private LevelRankingState<LETTER, STATE> computeLevelRanking(LevelRankingConstraintDrdCheck<LETTER, STATE> levelRankingConstraintDrdCheck, Set<DoubleDecker<StateWithRankInfo<STATE>>> set) {
        LevelRankingState levelRankingState = new LevelRankingState(this.mOperand);
        for (StateWithRankInfo stateWithRankInfo : levelRankingConstraintDrdCheck.getDownStates()) {
            for (StateWithRankInfo stateWithRankInfo2 : levelRankingConstraintDrdCheck.getUpStates(stateWithRankInfo)) {
                int n;
                boolean bl;
                Pair<Integer, Boolean> pair = this.getRankAndInO(set, stateWithRankInfo, stateWithRankInfo2, bl = stateWithRankInfo2.isInO(), n = stateWithRankInfo2.getRank());
                if (pair == null) {
                    return null;
                }
                levelRankingState.addRank(stateWithRankInfo, stateWithRankInfo2.getState(), (Integer)pair.getFirst(), (Boolean)pair.getSecond());
            }
        }
        return levelRankingState;
    }

    private Pair<Integer, Boolean> getRankAndInO(Set<DoubleDecker<StateWithRankInfo<STATE>>> set, StateWithRankInfo<STATE> stateWithRankInfo, StateWithRankInfo<STATE> stateWithRankInfo2, boolean bl, int n) {
        Pair pair;
        if (LevelRankingState.isOdd(n)) {
            if (this.mOperand.isFinal(stateWithRankInfo2.getState())) {
                if (!this.mAllowRankZero && n == 1) {
                    return null;
                }
                int n2 = n - 1;
                boolean bl2 = bl;
                pair = new Pair((Object)n2, (Object)bl2);
            } else {
                int n3 = n;
                boolean bl3 = false;
                pair = new Pair((Object)n3, (Object)bl3);
            }
        } else {
            assert (LevelRankingState.isEven(n));
            if (n > 0 && set.contains(new DoubleDecker<StateWithRankInfo<STATE>>(stateWithRankInfo, stateWithRankInfo2))) {
                int n4 = n - 1;
                boolean bl4 = false;
                pair = new Pair((Object)n4, (Object)bl4);
            } else {
                int n5 = n;
                boolean bl5 = bl;
                pair = new Pair((Object)n5, (Object)bl5);
            }
        }
        return pair;
    }
}

