/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic.LiteralCollection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalLiteralWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalSimpleWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.interval.IntervalPostOperator;
import java.util.function.Supplier;

public class IntervalDomain
implements IAbstractDomain<IntervalDomainState, IcfgEdge> {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IAbstractStateBinaryOperator<IntervalDomainState> mWideningOperator;
    private final LiteralCollection mLiteralCollection;
    private IAbstractPostOperator<IntervalDomainState, IcfgEdge> mPostOperator;

    public IntervalDomain(ILogger iLogger, LiteralCollection literalCollection, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mLiteralCollection = literalCollection;
        this.mServices = iUltimateServiceProvider;
    }

    public IntervalDomainState createTopState() {
        return new IntervalDomainState(this.mLogger, false);
    }

    public IntervalDomainState createBottomState() {
        return new IntervalDomainState(this.mLogger, true);
    }

    public IAbstractStateBinaryOperator<IntervalDomainState> getWideningOperator() {
        if (this.mWideningOperator == null) {
            IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
            String string = iPreferenceProvider.getString("Interval Widening operator");
            if (string.equals(IntervalDomainPreferences.VALUE_WIDENING_OPERATOR_SIMPLE)) {
                this.mWideningOperator = new IntervalSimpleWideningOperator();
            } else if (string.equals(IntervalDomainPreferences.VALUE_WIDENING_OPERATOR_LITERALS)) {
                IntervalLiteralWideningOperator intervalLiteralWideningOperator = new IntervalLiteralWideningOperator(this.mLiteralCollection);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Using the following literals during widening: " + String.valueOf(this.mLiteralCollection)));
                }
                this.mWideningOperator = intervalLiteralWideningOperator;
            } else {
                throw new UnsupportedOperationException("The widening operator " + string + " is not implemented.");
            }
        }
        return this.mWideningOperator;
    }

    public IAbstractPostOperator<IntervalDomainState, IcfgEdge> getPostOperator() {
        if (this.mPostOperator == null) {
            IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
            int n = iPreferenceProvider.getInt("Parallel states before merging");
            Supplier<IntervalDomainState> supplier = this::createTopState;
            Supplier<IntervalDomainState> supplier2 = this::createBottomState;
            this.mPostOperator = new IntervalPostOperator(this.mLogger, n, supplier, supplier2);
        }
        return this.mPostOperator;
    }
}

