/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner;

import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphEdgeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNode;
import java.util.Map;

public class InlinerStatistic {
    private final Map<String, CallGraphNode> mCallGraph;
    private int mCallsInlined = 0;
    private int mStatementsFlattened = 0;

    public InlinerStatistic(Map<String, CallGraphNode> map) {
        this.mCallGraph = map;
    }

    public void incrementStatementsFlattened() {
        ++this.mStatementsFlattened;
    }

    public void incrementCallsInlined() {
        this.incrementStatementsFlattened();
        ++this.mCallsInlined;
    }

    public int numberOfProcedures() {
        return this.mCallGraph.size();
    }

    public int numberOfCallGraphEdges() {
        int n = 0;
        for (CallGraphNode callGraphNode : this.mCallGraph.values()) {
            n += callGraphNode.getOutgoingEdgeLabels().size();
        }
        return n;
    }

    public int numberOfCallGraphEdgesWithInlineFlag() {
        int n = 0;
        for (CallGraphNode callGraphNode : this.mCallGraph.values()) {
            for (CallGraphEdgeLabel callGraphEdgeLabel : callGraphNode.getOutgoingEdgeLabels()) {
                if (!callGraphEdgeLabel.getInlineFlag()) continue;
                ++n;
            }
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("procedures = ").append(this.numberOfProcedures());
        stringBuilder.append(", calls = ").append(this.numberOfCallGraphEdges());
        stringBuilder.append(", calls flagged for inlining = ").append(this.numberOfCallGraphEdgesWithInlineFlag());
        stringBuilder.append(", calls inlined = ").append(this.mCallsInlined);
        stringBuilder.append(", statements flattened = ").append(this.mStatementsFlattened);
        return stringBuilder.toString();
    }
}

