/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.RewriteEqualityTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;

public class RewriteEquality
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replaces a = b with (a <= b /\\ a >= b) and a != b with (a > b \\/ a < b)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        Term term = modifiableTransFormula.getFormula();
        Term term2 = modifiableTransFormula2.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript managedScript) {
        return new RewriteEqualityTransformer(managedScript.getScript());
    }
}

