/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.nontermination;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.FixpointCheck;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.InfiniteFixpointRepetitionWithExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;

public class FixpointCheck2<L extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final CfgSmtToolkit mCsToolkit;
    private final NestedWord<L> mStem;
    private final TransFormula mLoop;
    private final FixpointCheck.HasFixpoint mResult;
    private InfiniteFixpointRepetitionWithExecution<L> mTerminationArgument;

    public FixpointCheck2(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, BasicPredicateFactory basicPredicateFactory, NestedWord<L> nestedWord, UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mCsToolkit = cfgSmtToolkit;
        this.mStem = nestedWord;
        this.mLoop = unmodifiableTransFormula;
        BasicPredicate basicPredicate = basicPredicateFactory.newPredicate(cfgSmtToolkit.getManagedScript().getScript().term("true", new Term[0]));
        IPredicate iPredicate = FixpointCheck2.constructNegatedLoopPredicate(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), basicPredicateFactory, this.mLoop);
        SortedMap sortedMap = Collections.emptySortedMap();
        TraceCheck traceCheck = new TraceCheck((IPredicate)basicPredicate, iPredicate, sortedMap, new Counterexample(this.mStem), iUltimateServiceProvider, cfgSmtToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, true, false);
        switch (traceCheck.isCorrect()) {
            case SAT: {
                this.mResult = FixpointCheck.HasFixpoint.YES;
                if (!traceCheck.providesRcfgProgramExecution()) {
                    throw new AssertionError((Object)"TraceCheck has to provide an execution");
                }
                this.mTerminationArgument = new InfiniteFixpointRepetitionWithExecution(traceCheck.getRcfgProgramExecution());
                break;
            }
            case UNKNOWN: {
                this.mResult = FixpointCheck.HasFixpoint.UNKNOWN;
                break;
            }
            case UNSAT: {
                this.mResult = FixpointCheck.HasFixpoint.NO;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static IPredicate constructNegatedLoopPredicate(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, TransFormula transFormula) {
        Term term = TransFormulaUtils.renameInvarsToDefaultVars((TransFormula)transFormula, (ManagedScript)managedScript, (Term)transFormula.getFormula());
        Term term2 = TransFormulaUtils.renameOutvarsToDefaultVars((TransFormula)transFormula, (ManagedScript)managedScript, (Term)term);
        Term term3 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, (Collection)transFormula.getAuxVars(), (Term)term2);
        Term term4 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term3, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        return basicPredicateFactory.newPredicate(SmtUtils.not((Script)managedScript.getScript(), (Term)term4));
    }

    public FixpointCheck.HasFixpoint getResult() {
        return this.mResult;
    }

    public InfiniteFixpointRepetitionWithExecution<L> getTerminationArgument() {
        return this.mTerminationArgument;
    }
}

