/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AssignableTest;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.TestFileInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import java.util.Collections;

public class AutomataScriptInterpreterObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private IElement mGraphrootOfUltimateModelOfLastPrintedAutomaton;
    private final IUltimateServiceProvider mServices;

    public AutomataScriptInterpreterObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        assert (iUltimateServiceProvider != null);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public boolean process(IElement iElement) {
        AssignableTest.initPrimitiveTypes();
        TestFileInterpreter testFileInterpreter = new TestFileInterpreter(this.mServices);
        testFileInterpreter.interpretTestFile((AtsASTNode)iElement);
        IAutomaton<String, String> iAutomaton = testFileInterpreter.getLastPrintedAutomaton();
        if (iAutomaton == null) {
            iAutomaton = this.getDummyAutomatonWithMessage();
        }
        try {
            this.mGraphrootOfUltimateModelOfLastPrintedAutomaton = iAutomaton.transformToUltimateModel(new AutomataLibraryServices(this.mServices));
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            this.mLogger.warn((Object)"Nothing visualized because of timeout");
        }
        return false;
    }

    public void finish() {
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public boolean performedChanges() {
        return false;
    }

    IElement getUltimateModelOfLastPrintedAutomaton() {
        return this.mGraphrootOfUltimateModelOfLastPrintedAutomaton;
    }

    public IAutomaton<String, String> getDummyAutomatonWithMessage() {
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), new VpAlphabet(Collections.emptySet()), (IEmptyStackStateFactory)new StringFactory());
        nestedWordAutomaton.addState(true, false, (Object)"Use the print keyword in .ats file to select an automaton for visualization");
        return nestedWordAutomaton;
    }
}

