/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqtotest.req;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.reqtotest.graphtransformer.FakeBoogieVar;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Req2TestReqSymbolTable
implements IReqSymbolTable,
ITerm2ExpressionSymbolTable {
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final Map<String, BoogieType> mId2Type = new LinkedHashMap<String, BoogieType>();
    private final Map<String, IdentifierExpression> mId2IdExpr = new LinkedHashMap<String, IdentifierExpression>();
    private final Map<String, Expression> mConst2Val = new LinkedHashMap<String, Expression>();
    private final ILogger mLogger;
    private final Set<String> mStateVars;
    private final Set<String> mConstVars;
    private final Set<String> mInputVars;
    private final Set<String> mHiddenVars;
    private final Set<String> mOutputVars;
    private final Set<String> mAuxVars;
    private final Set<String> mClockVars;
    private final Set<String> mHistoryVars;
    private final ILocation mDummyLocation;

    public Req2TestReqSymbolTable(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mStateVars = new LinkedHashSet<String>();
        this.mConstVars = new LinkedHashSet<String>();
        this.mInputVars = new LinkedHashSet<String>();
        this.mHiddenVars = new LinkedHashSet<String>();
        this.mOutputVars = new LinkedHashSet<String>();
        this.mAuxVars = new LinkedHashSet<String>();
        this.mClockVars = new LinkedHashSet<String>();
        this.mHistoryVars = new LinkedHashSet<String>();
        this.mDummyLocation = new BoogieLocation("", -1, -1, -1, -1);
    }

    public List<Declaration> constructVariableDeclarations() {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(this.constructVariableDeclarations(this.mConstVars));
        arrayList.addAll(this.constructVariableDeclarations(this.mStateVars));
        arrayList.addAll(this.constructVariableDeclarations(this.mAuxVars));
        arrayList.addAll(this.constructVariableDeclarations(this.mClockVars));
        return arrayList;
    }

    public boolean isConstVar(String string) {
        return this.mConstVars.contains(string);
    }

    public boolean isInput(String string) {
        return this.mInputVars.contains(string);
    }

    public boolean isObservable(String string) {
        return this.isInput(string) || this.isOutput(string);
    }

    public boolean isAuxVar(String string) {
        return this.mAuxVars.contains(string);
    }

    public Set<String> getHiddenVars() {
        return this.mHiddenVars;
    }

    public Set<String> getOutputVars() {
        return this.mOutputVars;
    }

    public Set<String> getInputVars() {
        return this.mInputVars;
    }

    public Set<String> getConstVars() {
        return this.mConstVars;
    }

    public Set<String> getAuxVars() {
        return this.mAuxVars;
    }

    public Set<String> getHistoryVars() {
        return this.mHistoryVars;
    }

    public Set<String> getClockVars() {
        return this.mClockVars;
    }

    public boolean isOutput(String string) {
        return this.mOutputVars.contains(string);
    }

    public void updateVariableCategoryInput(String string) {
        this.mInputVars.add(string);
        this.mOutputVars.remove(string);
        this.mHiddenVars.remove(string);
    }

    public void updateVariableCategoryOutput(String string) {
        this.mInputVars.remove(string);
        this.mOutputVars.add(string);
        this.mHiddenVars.remove(string);
    }

    public void updateVariableCategoryHidden(String string) {
        this.mInputVars.remove(string);
        this.mOutputVars.remove(string);
        this.mHiddenVars.add(string);
    }

    public void extractVariablesFromInit(DeclarationPattern declarationPattern) {
        BoogiePrimitiveType boogiePrimitiveType = Req2TestReqSymbolTable.toPrimitiveType(declarationPattern.getType());
        String string = declarationPattern.getId();
        if (boogiePrimitiveType == BoogieType.TYPE_ERROR) {
            throw new RuntimeException("Variable has not Type: " + declarationPattern.toString());
        }
        if (declarationPattern.getCategory() == DeclarationPattern.VariableCategory.CONST) {
            this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mConstVars);
            this.mConst2Val.put(string, declarationPattern.getExpression());
        } else if (declarationPattern.getCategory() == DeclarationPattern.VariableCategory.IN) {
            this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mStateVars);
            this.mInputVars.add(string);
        } else if (declarationPattern.getCategory() == DeclarationPattern.VariableCategory.OUT) {
            this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mStateVars);
            this.mOutputVars.add(string);
        } else if (declarationPattern.getCategory() == DeclarationPattern.VariableCategory.HIDDEN) {
            this.addVar(string, (BoogieType)boogiePrimitiveType, (PatternType<?>)declarationPattern, this.mStateVars);
            this.mHiddenVars.add(string);
        }
    }

    public List<Statement> constructConstantAssignments() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (String string : this.mConstVars) {
            arrayList.add((Statement)new AssignmentStatement(this.mDummyLocation, (LeftHandSide[])new VariableLHS[]{new VariableLHS(this.mDummyLocation, string)}, new Expression[]{this.mConst2Val.get(string)}));
        }
        return arrayList;
    }

    private List<Declaration> constructVariableDeclarations(Collection<String> collection) {
        List<? extends VarList> list = this.constructVarLists(collection);
        return list.stream().map(varList -> new VariableDeclaration(varList.getLocation(), EMPTY_ATTRIBUTES, new VarList[]{varList})).collect(Collectors.toList());
    }

    private List<? extends VarList> constructVarLists(Collection<String> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return collection.stream().map(this::constructVarlist).filter(varList -> varList != null).collect(Collectors.toList());
    }

    private VarList constructVarlist(String string) {
        BoogieType boogieType = this.mId2Type.get(string);
        IdentifierExpression identifierExpression = this.mId2IdExpr.get(string);
        if (boogieType == null || identifierExpression == null) {
            return null;
        }
        return new VarList(identifierExpression.getLocation(), new String[]{string}, boogieType.toASTType(identifierExpression.getLocation()));
    }

    private static BoogiePrimitiveType toPrimitiveType(String string) {
        switch (string.toLowerCase()) {
            case "bool": {
                return BoogieType.TYPE_BOOL;
            }
            case "real": {
                return BoogieType.TYPE_REAL;
            }
            case "int": {
                return BoogieType.TYPE_INT;
            }
        }
        return BoogieType.TYPE_ERROR;
    }

    public void addAuxVar(String string, BoogieType boogieType) {
        this.mAuxVars.add(string);
        this.addVar(string, boogieType);
    }

    public void addClockVar(String string, BoogieType boogieType) {
        this.mClockVars.add(string);
        this.addVar(string, boogieType);
    }

    private void addVar(String string, BoogieType boogieType, PatternType<?> patternType, Set<String> set) {
        if (!(boogieType != null || set.contains(string) && this.mId2Type.containsKey(string))) {
            throw new AssertionError();
        }
        if (set != null) {
            set.add(string);
        }
        this.addVar(string, boogieType);
    }

    private void addVar(String string, BoogieType boogieType) {
        BoogieType boogieType2 = this.mId2Type.put(string, boogieType);
        if (boogieType2 != null && boogieType2 != boogieType) {
            this.mId2Type.put(string, (BoogieType)BoogieType.TYPE_ERROR);
            return;
        }
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)this.mDummyLocation, (BoogieType)boogieType, (String)string, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        this.mId2IdExpr.put(string, identifierExpression);
    }

    public IdentifierExpression getIdentifierExpression(String string) {
        return this.mId2IdExpr.get(string);
    }

    public ProgramFunction getProgramFun(FunctionSymbol functionSymbol) {
        throw new UnsupportedOperationException();
    }

    public IProgramVar getProgramVar(TermVariable termVariable) {
        return new FakeBoogieVar((IBoogieType)this.mId2Type.get(termVariable.getName()), termVariable.getName());
    }

    public String translateToBoogieFunction(String string, IBoogieType iBoogieType) {
        throw new UnsupportedOperationException();
    }

    public ILocation getLocation(IProgramVar iProgramVar) {
        return this.mDummyLocation;
    }

    public DeclarationInformation getDeclarationInformation(IProgramVar iProgramVar) {
        throw new UnsupportedOperationException();
    }

    public String getPcName(PhaseEventAutomata phaseEventAutomata) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPrimedVars() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getEventVars() {
        throw new UnsupportedOperationException();
    }

    public String getDeltaVarName() {
        throw new UnsupportedOperationException();
    }

    public VariableLHS getVariableLhs(String string) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getStateVars() {
        throw new UnsupportedOperationException();
    }

    public String getPrimedVarId(String string) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getPcVars() {
        throw new UnsupportedOperationException();
    }

    public Collection<Declaration> getDeclarations() {
        throw new UnsupportedOperationException();
    }

    public Map<PatternType<?>, BoogieLocation> getLocations() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Expression> getConstToValue() {
        throw new UnsupportedOperationException();
    }

    public String getHistoryVarId(String string) {
        throw new UnsupportedOperationException();
    }

    public IBoogieType getFunctionReturnType(String string) {
        throw new UnsupportedOperationException();
    }

    public UnionFind<String> getVariableEquivalenceClasses() {
        throw new UnsupportedOperationException();
    }
}

