/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class OctMatrix {
    public static final BiPredicate<OctValue, OctValue> sRelationEqual = (octValue, octValue2) -> octValue.compareTo((OctValue)octValue2) == 0;
    public static final BiPredicate<OctValue, OctValue> sRelationLessThanOrEqual = (octValue, octValue2) -> octValue.compareTo((OctValue)octValue2) <= 0;
    public static final OctMatrix NEW = new OctMatrix(0);
    private static final Consumer<OctMatrix> sDefaultShortestPathClosure = OctMatrix::shortestPathClosurePrimitiveSparse;
    private final int mSize;
    private final OctValue[] mEntries;
    private OctMatrix mStrongClosure;
    private OctMatrix mTightClosure;

    public OctMatrix copy() {
        OctMatrix octMatrix = new OctMatrix(this.variables());
        System.arraycopy(this.mEntries, 0, octMatrix.mEntries, 0, this.mEntries.length);
        octMatrix.mStrongClosure = this.mStrongClosure == this ? octMatrix : this.mStrongClosure;
        octMatrix.mTightClosure = this.mTightClosure == this ? octMatrix : this.mTightClosure;
        return octMatrix;
    }

    public static OctMatrix parseBlockLowerTriangular(String string) {
        String[] stringArray = (string = string.trim()).length() > 0 ? string.split("\\s+") : new String[]{};
        int n = (int)Math.sqrt(1.0 + (double)(2 * stringArray.length)) - 1;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Number of entries does not match any 2x2 block lower triangular matrix.");
        }
        OctMatrix octMatrix = new OctMatrix(n / 2);
        int n2 = 0;
        while (n2 < stringArray.length) {
            octMatrix.mEntries[n2] = OctValue.parse(stringArray[n2]);
            ++n2;
        }
        return octMatrix;
    }

    public static OctMatrix random(int n) {
        return OctMatrix.random(n, Math.random());
    }

    public static OctMatrix random(int n, double d) {
        OctMatrix octMatrix = new OctMatrix(n);
        int n2 = 0;
        while (n2 < octMatrix.mSize) {
            int n3 = n2 | 1;
            int n4 = 0;
            while (n4 <= n3) {
                OctValue octValue = n2 == n4 ? OctValue.ZERO : (Math.random() < d ? OctValue.INFINITY : new OctValue(ThreadLocalRandom.current().nextInt(-10, 10)));
                octMatrix.set(n2, n4, octValue);
                ++n4;
            }
            ++n2;
        }
        return octMatrix;
    }

    public OctMatrix(int n) {
        this.mSize = n * 2;
        this.mEntries = new OctValue[OctMatrix.entriesInBlockLowerTriangular(n)];
    }

    private static int entriesInBlockLowerTriangular(int n) {
        return 2 * (n * n + n);
    }

    public void fill(OctValue octValue) {
        int n = 0;
        while (n < this.mEntries.length) {
            this.mEntries[n] = octValue;
            ++n;
        }
        this.mTightClosure = null;
        this.mStrongClosure = null;
    }

    public int getSize() {
        return this.mSize;
    }

    public int variables() {
        return this.mSize / 2;
    }

    public OctValue get(int n, int n2) {
        return this.mEntries[this.indexOf(n, n2)];
    }

    public void set(int n, int n2, OctValue octValue) {
        assert (octValue != null) : "null is not a valid matrix entry.";
        this.mTightClosure = null;
        this.mStrongClosure = null;
        this.mEntries[this.indexOf((int)n, (int)n2)] = octValue;
    }

    public void setMin(int n, int n2, OctValue octValue) {
        assert (octValue != null) : "null is not a valid matrix entry.";
        int n3 = this.indexOf(n, n2);
        if (octValue.compareTo(this.mEntries[n3]) < 0) {
            this.mEntries[n3] = octValue;
            this.mTightClosure = null;
            this.mStrongClosure = null;
        }
    }

    private boolean minimizeDiagonal() {
        int n = 0;
        while (n < this.mSize) {
            if (this.minimizeDiagonalEntry(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean minimizeDiagonalEntry(int n) {
        int n2 = OctMatrix.indexOfLower(n, n);
        int n3 = this.mEntries[n2].signum();
        if (n3 > 0) {
            this.mEntries[n2] = OctValue.ZERO;
            return false;
        }
        return n3 < 0;
    }

    private int indexOf(int n, int n2) {
        assert (n < this.mSize && n2 < this.mSize) : n + "," + n2 + " is not an index for matrix of size " + this.mSize + ".";
        if (n < n2) {
            return OctMatrix.indexOfLower(n2 ^ 1, n ^ 1);
        }
        return OctMatrix.indexOfLower(n, n2);
    }

    private static int indexOfLower(int n, int n2) {
        return n2 + (n + 1) * (n + 1) / 2;
    }

    public OctMatrix elementwiseOperation(OctMatrix octMatrix, BiFunction<OctValue, OctValue, OctValue> biFunction) {
        this.checkCompatibility(octMatrix);
        OctMatrix octMatrix2 = new OctMatrix(this.variables());
        int n = 0;
        while (n < this.mEntries.length) {
            octMatrix2.mEntries[n] = biFunction.apply(this.mEntries[n], octMatrix.mEntries[n]);
            ++n;
        }
        return octMatrix2;
    }

    public boolean elementwiseRelation(OctMatrix octMatrix, BiPredicate<OctValue, OctValue> biPredicate) {
        this.checkCompatibility(octMatrix);
        int n = 0;
        while (n < this.mEntries.length) {
            if (!biPredicate.test(this.mEntries[n], octMatrix.mEntries[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean elementwiseRelation(OctMatrix octMatrix, BiPredicate<OctValue, OctValue> biPredicate, int[] nArray) {
        if (nArray == null) {
            return this.elementwiseRelation(octMatrix, biPredicate);
        }
        this.checkCompatibility(octMatrix);
        int n = 0;
        while (n < this.variables()) {
            int n2 = 0;
            while (n2 <= n) {
                int n3 = nArray[n];
                int n4 = nArray[n2];
                if (!this.blockwiseRelation(n, n2, octMatrix, n3, n4, biPredicate)) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public boolean blockwiseRelation(int n, int n2, OctMatrix octMatrix, int n3, int n4, BiPredicate<OctValue, OctValue> biPredicate) {
        n *= 2;
        n2 *= 2;
        n3 *= 2;
        n4 *= 2;
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < 2) {
                if (!biPredicate.test(this.get(n + n6, n2 + n5), octMatrix.get(n3 + n6, n4 + n5))) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    private void checkCompatibility(OctMatrix octMatrix) {
        if (octMatrix.mSize != this.mSize) {
            throw new IllegalArgumentException("Incompatible matrices");
        }
    }

    public OctMatrix add(OctMatrix octMatrix) {
        return this.elementwiseOperation(octMatrix, OctValue::add);
    }

    public OctMatrix rearrange(int[] nArray) {
        int n;
        int n2;
        OctMatrix octMatrix = new OctMatrix(nArray.length);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            n2 = nArray[n5];
            n = n2 < 0 ? 1 : 0;
            hashMap.put(n5, n != 0 ? null : Integer.valueOf(n2));
            if (n5 == n2 && n3 == n5) {
                ++n3;
            }
            n4 = n != 0 ? ++n4 : 0;
            ++n5;
        }
        n5 = octMatrix.variables() - n4;
        n2 = OctMatrix.entriesInBlockLowerTriangular(n3);
        System.arraycopy(this.mEntries, 0, octMatrix.mEntries, 0, n2);
        octMatrix.copySelection(this, hashMap, n3, n5);
        n = OctMatrix.entriesInBlockLowerTriangular(n5);
        Arrays.fill(octMatrix.mEntries, n, octMatrix.mEntries.length, OctValue.INFINITY);
        return octMatrix;
    }

    public static OctMatrix min(OctMatrix octMatrix, OctMatrix octMatrix2) {
        return octMatrix.elementwiseOperation(octMatrix2, OctValue::min);
    }

    public static OctMatrix max(OctMatrix octMatrix, OctMatrix octMatrix2) {
        OctMatrix octMatrix3 = octMatrix.elementwiseOperation(octMatrix2, OctValue::max);
        if (octMatrix.mStrongClosure != null && octMatrix2.mStrongClosure != null) {
            octMatrix3.mStrongClosure = octMatrix3;
        }
        if (octMatrix.mTightClosure != null && octMatrix2.mTightClosure != null) {
            octMatrix3.mTightClosure = octMatrix3;
        }
        return octMatrix3;
    }

    public boolean isEqualTo(OctMatrix octMatrix) {
        if (this == octMatrix) {
            return true;
        }
        return this.elementwiseRelation(octMatrix, sRelationEqual);
    }

    public boolean isEqualTo(OctMatrix octMatrix, int[] nArray) {
        return this.elementwiseRelation(octMatrix, sRelationEqual, nArray);
    }

    public boolean isLessEqualThan(OctMatrix octMatrix) {
        return this.elementwiseRelation(octMatrix, sRelationLessThanOrEqual);
    }

    public OctMatrix cachedStrongClosure() {
        if (this.mStrongClosure != null) {
            return this.mStrongClosure;
        }
        return this.strongClosure(sDefaultShortestPathClosure);
    }

    public boolean hasCachedStrongClosure() {
        return this.mStrongClosure != null;
    }

    public OctMatrix strongClosure(Consumer<OctMatrix> consumer) {
        OctMatrix octMatrix = this.copy();
        boolean bl = octMatrix.minimizeDiagonal();
        if (!bl) {
            consumer.accept(octMatrix);
            octMatrix.strengtheningInPlace();
        }
        octMatrix.mStrongClosure = this.mStrongClosure = octMatrix;
        octMatrix.mTightClosure = this.mTightClosure;
        return octMatrix;
    }

    public OctMatrix cachedTightClosure() {
        if (this.mTightClosure != null) {
            return this.mTightClosure;
        }
        return this.tightClosure(sDefaultShortestPathClosure);
    }

    public boolean hasCachedTightClosure() {
        return this.mTightClosure != null;
    }

    public OctMatrix tightClosure(Consumer<OctMatrix> consumer) {
        OctMatrix octMatrix = this.copy();
        if (!octMatrix.minimizeDiagonal()) {
            consumer.accept(octMatrix);
            octMatrix.tighteningInPlace();
        }
        octMatrix.mStrongClosure = this.mStrongClosure;
        octMatrix.mTightClosure = this.mTightClosure = octMatrix;
        return octMatrix;
    }

    protected void shortestPathClosureNaiv() {
        int n = 0;
        while (n < this.mSize) {
            int n2 = 0;
            while (n2 < this.mSize) {
                OctValue octValue = this.get(n2, n);
                int n3 = 0;
                while (n3 < this.mSize) {
                    OctValue octValue2 = octValue.add(this.get(n, n3));
                    if (this.get(n2, n3).compareTo(octValue2) > 0) {
                        this.set(n2, n3, octValue2);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void shortestPathClosureFullSparse() {
        int n = 0;
        while (n < this.mSize) {
            List<Integer> list = this.indexFiniteEntriesInColumn(n);
            List<Integer> list2 = this.indexFiniteEntriesInRow(n);
            for (int n2 : list) {
                OctValue octValue = this.get(n2, n);
                for (int n3 : list2) {
                    OctValue octValue2 = this.get(n, n3);
                    OctValue octValue3 = octValue.add(octValue2);
                    if (this.get(n2, n3).compareTo(octValue3) <= 0) continue;
                    this.set(n2, n3, octValue3);
                }
            }
            ++n;
        }
    }

    private List<Integer> indexFiniteEntriesInColumn(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mSize);
        int n2 = 0;
        while (n2 < this.mSize) {
            if (!this.get(n2, n).isInfinity()) {
                arrayList.add(n2);
            }
            ++n2;
        }
        return arrayList;
    }

    private List<Integer> indexFiniteEntriesInRow(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mSize);
        int n2 = 0;
        while (n2 < this.mSize) {
            if (!this.get(n, n2).isInfinity()) {
                arrayList.add(n2);
            }
            ++n2;
        }
        return arrayList;
    }

    protected void shortestPathClosureSparse() {
        List<Integer> list = null;
        List<Integer> list2 = null;
        int n = 0;
        while (n < this.mSize) {
            int n2 = n ^ 1;
            if (n < n2) {
                list = this.indexFiniteEntriesInBlockColumn(n);
                list2 = this.indexFiniteEntriesInBlockRow(n);
            }
            Iterator iterator = list.iterator();
            block1: while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                OctValue octValue = this.get(n3, n);
                OctValue octValue2 = this.get(n3, n2);
                int n4 = n3 | 1;
                for (int n5 : list2) {
                    if (n5 > n4) continue block1;
                    OctValue octValue3 = this.get(n, n5);
                    OctValue octValue4 = this.get(n2, n5);
                    OctValue octValue5 = OctValue.min(octValue.add(octValue3), octValue2.add(octValue4));
                    if (this.get(n3, n5).compareTo(octValue5) <= 0) continue;
                    this.set(n3, n5, octValue5);
                }
            }
            ++n;
        }
    }

    private List<Integer> indexFiniteEntriesInBlockColumn(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mSize);
        int n2 = n ^ 1;
        int n3 = 0;
        while (n3 < this.mSize) {
            if (!this.get(n3, n).isInfinity() || !this.get(n3, n2).isInfinity()) {
                arrayList.add(n3);
            }
            ++n3;
        }
        return arrayList;
    }

    private List<Integer> indexFiniteEntriesInBlockRow(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mSize);
        int n2 = n ^ 1;
        int n3 = 0;
        while (n3 < this.mSize) {
            if (!this.get(n, n3).isInfinity() || !this.get(n2, n3).isInfinity()) {
                arrayList.add(n3);
            }
            ++n3;
        }
        return arrayList;
    }

    protected void shortestPathClosurePrimitiveSparse() {
        int[] nArray = null;
        int[] nArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.mSize) {
            int n3 = n2 ^ 1;
            if (n2 < n3) {
                nArray = new int[this.mSize];
                nArray2 = new int[this.mSize];
                n = this.primitiveIndexFiniteEntriesInBlockRowAndColumn(n2, nArray, nArray2);
            }
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray2[n4];
                OctValue octValue = this.get(n5, n2);
                OctValue octValue2 = this.get(n5, n3);
                int n6 = n5 | 1;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = nArray[n7];
                    if (n8 > n6) break;
                    OctValue octValue3 = this.get(n2, n8);
                    OctValue octValue4 = this.get(n3, n8);
                    OctValue octValue5 = OctValue.min(octValue.add(octValue3), octValue2.add(octValue4));
                    if (this.get(n5, n8).compareTo(octValue5) > 0) {
                        this.set(n5, n8, octValue5);
                    }
                    ++n7;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private int primitiveIndexFiniteEntriesInBlockRowAndColumn(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = n ^ 1;
        int n4 = 0;
        while (n4 < this.mSize) {
            if (!this.get(n4, n).isInfinity() || !this.get(n4, n3).isInfinity()) {
                nArray2[n2] = n4;
                nArray[n2] = n4 ^ 1;
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    protected void shortestPathClosureApron() {
        int n = 0;
        while (n < this.mSize) {
            int n2 = 0;
            while (n2 < this.mSize) {
                OctValue octValue = this.get(n2, n);
                OctValue octValue2 = this.get(n2, n ^ 1);
                int n3 = n2 | 1;
                int n4 = 0;
                while (n4 <= n3) {
                    OctValue octValue3 = this.get(n, n4);
                    OctValue octValue4 = this.get(n ^ 1, n4);
                    OctValue octValue5 = OctValue.min(octValue.add(octValue3), octValue2.add(octValue4));
                    if (this.get(n2, n4).compareTo(octValue5) > 0) {
                        this.set(n2, n4, octValue5);
                    }
                    ++n4;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void strengtheningInPlace() {
        int n = 2;
        while (n < this.mSize) {
            OctValue octValue = this.get(n, n ^ 1).half();
            int n2 = n - 2 | 1;
            int n3 = 0;
            while (n3 <= n2) {
                OctValue octValue2 = this.get(n3 ^ 1, n3).half();
                OctValue octValue3 = octValue.add(octValue2);
                if (this.get(n, n3).compareTo(octValue3) > 0) {
                    this.set(n, n3, octValue3);
                }
                ++n3;
            }
            ++n;
        }
    }

    private void tighteningInPlace() {
        int n = 0;
        while (n < this.mSize) {
            OctValue octValue = this.get(n, n ^ 1).half().floor();
            int n2 = n | 1;
            int n3 = 0;
            while (n3 <= n2) {
                OctValue octValue2 = this.get(n3 ^ 1, n3).half().floor();
                OctValue octValue3 = octValue.add(octValue2);
                if (this.get(n, n3).compareTo(octValue3) > 0) {
                    this.set(n, n3, octValue3);
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean hasNegativeSelfLoop() {
        int n = 0;
        while (n < this.mSize) {
            if (this.get(n, n).signum() < 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public OctMatrix widenSimple(OctMatrix octMatrix) {
        return this.elementwiseOperation(octMatrix, (octValue, octValue2) -> octValue.compareTo((OctValue)octValue2) >= 0 ? octValue : OctValue.INFINITY);
    }

    public OctMatrix widenExponential(OctMatrix octMatrix, OctValue octValue) {
        OctValue octValue2 = new OctValue(1);
        OctValue octValue3 = octValue2.add(octValue2).negate();
        OctValue octValue4 = octValue2.half();
        return this.elementwiseOperation(octMatrix, (octValue5, octValue6) -> {
            if (octValue5.compareTo((OctValue)octValue6) >= 0) {
                return octValue5;
            }
            if (octValue6.compareTo(octValue) > 0) {
                return OctValue.INFINITY;
            }
            OctValue octValue7 = octValue6.compareTo(octValue3) <= 0 ? octValue6.half() : (octValue6.signum() <= 0 ? OctValue.ZERO : (octValue6.compareTo(octValue4) <= 0 ? octValue2 : octValue6.add((OctValue)octValue6)));
            return OctValue.min(octValue7, octValue);
        });
    }

    public OctMatrix widenStepwise(OctMatrix octMatrix, WideningStepSupplier wideningStepSupplier) {
        return this.elementwiseOperation(octMatrix, (octValue, octValue2) -> {
            if (octValue.compareTo((OctValue)octValue2) >= 0) {
                return octValue;
            }
            return wideningStepSupplier.nextWideningStep((OctValue)octValue2);
        });
    }

    public OctMatrix addVariables(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot add " + n + " variables.");
        }
        if (n == 0) {
            return this;
        }
        OctMatrix octMatrix = new OctMatrix(this.variables() + n);
        System.arraycopy(this.mEntries, 0, octMatrix.mEntries, 0, this.mEntries.length);
        Arrays.fill(octMatrix.mEntries, this.mEntries.length, octMatrix.mEntries.length, OctValue.INFINITY);
        return octMatrix;
    }

    public OctMatrix removeVariable(int n) {
        return this.removeVariables(Collections.singleton(n));
    }

    public OctMatrix removeVariables(Set<Integer> set) {
        if (this.areVariablesLast(set)) {
            return this.removeLastVariables(set.size());
        }
        return this.removeArbitraryVariables(set);
    }

    private boolean areVariablesLast(Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set);
        Collections.sort(arrayList);
        int n = this.variables();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n2 < 0 || n2 >= this.variables()) {
                throw new IllegalArgumentException("Variable " + n2 + " does not exist.");
            }
            if (n2 + 1 == n) {
                n = n2;
                continue;
            }
            return false;
        }
        return true;
    }

    private OctMatrix removeLastVariables(int n) {
        if (n > this.variables()) {
            throw new IllegalArgumentException("Cannot remove more variables than exist.");
        }
        OctMatrix octMatrix = new OctMatrix(this.variables() - n);
        System.arraycopy(this.mEntries, 0, octMatrix.mEntries, 0, octMatrix.mEntries.length);
        return octMatrix;
    }

    private OctMatrix removeArbitraryVariables(Set<Integer> set) {
        OctMatrix octMatrix = new OctMatrix(this.variables() - set.size());
        int n = 0;
        int n2 = 0;
        while (n2 < this.mSize) {
            if (set.contains(n2 / 2)) {
                ++n2;
            } else {
                int n3 = n2 | 1;
                int n4 = 0;
                while (n4 <= n3) {
                    if (set.contains(n4 / 2)) {
                        ++n4;
                    } else {
                        octMatrix.mEntries[n] = this.get(n2, n4);
                        ++n;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return octMatrix;
    }

    protected void copySelection(OctMatrix octMatrix, Map<Integer, Integer> map, int n, int n2) {
        n = Math.min(0, n);
        n2 = Math.min(this.variables(), n2);
        assert (!this.containsTautology(octMatrix, map, n, n2)) : "Overwrite in place with same target and source is not necessary and may cause problems.";
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            int n3 = entry.getKey();
            if (n3 < n || n2 <= n3) continue;
            Integer n4 = entry.getValue();
            int n5 = n;
            while (n5 < n2) {
                if (n5 >= n3 || !map.containsKey(n5)) {
                    Integer n6 = map.get(n5);
                    if (n6 == null || n4 == null) {
                        this.setBlock(n5, n3, OctValue.INFINITY);
                    } else {
                        this.copyBlock(n5, n3, octMatrix, n6, n4);
                    }
                }
                ++n5;
            }
        }
    }

    private boolean containsTautology(OctMatrix octMatrix, Map<Integer, Integer> map, int n, int n2) {
        return octMatrix.mEntries == this.mEntries && map.entrySet().stream().anyMatch(entry -> n <= (Integer)entry.getKey() && (Integer)entry.getKey() < n2 && ((Integer)entry.getKey()).equals(entry.getValue()));
    }

    protected void copySelection(OctMatrix octMatrix, Map<Integer, Integer> map) {
        this.copySelection(octMatrix, map, 0, Integer.MAX_VALUE);
    }

    public OctMatrix appendSelection(OctMatrix octMatrix, Collection<Integer> collection) {
        OctMatrix octMatrix2 = this.addVariables(collection.size());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Integer n : collection) {
            int n2 = hashMap.size() + this.variables();
            Integer n3 = hashMap.put(n2, n);
            assert (n3 == null) : "Selection contained duplicate: " + String.valueOf(n);
        }
        octMatrix2.copySelection(octMatrix, hashMap);
        return octMatrix2;
    }

    protected void copyBlock(int n, int n2, OctMatrix octMatrix, int n3, int n4) {
        n *= 2;
        n2 *= 2;
        n3 *= 2;
        n4 *= 2;
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < 2) {
                this.set(n + n6, n2 + n5, octMatrix.get(n3 + n6, n4 + n5));
                ++n6;
            }
            ++n5;
        }
    }

    protected void setBlock(int n, int n2, OctValue octValue) {
        n *= 2;
        n2 *= 2;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 2) {
                this.set(n + n4, n2 + n3, octValue);
                ++n4;
            }
            ++n3;
        }
    }

    protected void assignVarCopy(int n, int n2) {
        if (n == n2) {
            return;
        }
        boolean bl = this.mStrongClosure == this;
        boolean bl2 = this.mTightClosure == this;
        int n3 = n * 2;
        int n4 = n2 * 2;
        int n5 = n3 + 1;
        int n6 = n4 + 1;
        this.minimizeDiagonalEntry(n4);
        this.minimizeDiagonalEntry(n4 + 1);
        int n7 = Math.min(n4, n3) + 2;
        System.arraycopy(this.mEntries, OctMatrix.indexOfLower(n4, 0), this.mEntries, OctMatrix.indexOfLower(n3, 0), n7);
        System.arraycopy(this.mEntries, OctMatrix.indexOfLower(n6, 0), this.mEntries, OctMatrix.indexOfLower(n5, 0), n7);
        int n8 = n7;
        while (n8 < this.mSize) {
            this.set(n8, n3, this.get(n8, n4));
            this.set(n8, n5, this.get(n8, n6));
            ++n8;
        }
        this.copyBlock(n, n, this, n2, n2);
        if (bl) {
            this.mStrongClosure = this;
        }
        if (bl2) {
            this.mTightClosure = this;
        }
    }

    protected void negateVar(int n) {
        int n2 = n * 2;
        int n3 = n2 + 1;
        int n4 = this.indexOf(n2, 0);
        int n5 = this.indexOf(n3, 0);
        int n6 = n2 + 2;
        OctValue[] octValueArray = new OctValue[n6];
        System.arraycopy(this.mEntries, n4, octValueArray, 0, n6);
        System.arraycopy(this.mEntries, n5, this.mEntries, n4, n6);
        System.arraycopy(octValueArray, 0, this.mEntries, n5, n6);
        int n7 = n2;
        while (n7 < this.mSize) {
            int n8 = OctMatrix.indexOfLower(n7, n2);
            int n9 = n8 + 1;
            OctValue octValue = this.mEntries[n8];
            this.mEntries[n8] = this.mEntries[n9];
            this.mEntries[n9] = octValue;
            ++n7;
        }
        if (this.mStrongClosure != this) {
            this.mStrongClosure = null;
        }
        if (this.mTightClosure != this) {
            this.mTightClosure = null;
        }
    }

    protected void incrementVar(int n, OctValue octValue) {
        int n2;
        int n3;
        int n4 = n * 2;
        int n5 = n4 + 1;
        int n6 = 0;
        while (n6 < this.mSize) {
            if (n6 / 2 != n) {
                n3 = this.indexOf(n6, n4);
                n2 = this.indexOf(n6, n5);
                this.mEntries[n3] = this.mEntries[n3].add(octValue);
                this.mEntries[n2] = this.mEntries[n2].subtract(octValue);
            }
            ++n6;
        }
        OctValue octValue2 = octValue.add(octValue);
        n3 = this.indexOf(n5, n4);
        n2 = this.indexOf(n4, n5);
        this.mEntries[n3] = this.mEntries[n3].add(octValue2);
        this.mEntries[n2] = this.mEntries[n2].subtract(octValue2);
        if (this.mStrongClosure != this) {
            this.mStrongClosure = null;
        }
        if (this.mTightClosure != this) {
            assert (octValue.isInfinity() || AbsIntUtil.isIntegral(octValue.getValue())) : "int incremented by real";
            this.mTightClosure = null;
        }
    }

    protected void assignVarConstant(int n, OctValue octValue) {
        this.havocVar(n);
        int n2 = n * 2;
        int n3 = n2 + 1;
        OctValue octValue2 = octValue.add(octValue);
        this.set(n2, n3, octValue2.negate());
        this.set(n3, n2, octValue2);
    }

    protected void assumeVarConstant(int n, OctValue octValue) {
        int n2 = n * 2;
        int n3 = n2 + 1;
        OctValue octValue2 = octValue.add(octValue);
        this.setMin(n2, n3, octValue2.negate());
        this.setMin(n3, n2, octValue2);
    }

    protected void assignVarInterval(int n, OctValue octValue, OctValue octValue2) {
        this.havocVar(n);
        int n2 = n * 2;
        int n3 = n2 + 1;
        this.set(n2, n3, octValue.add(octValue).negateIfNotInfinity());
        this.set(n3, n2, octValue2.add(octValue2));
    }

    protected void assumeVarInterval(int n, OctValue octValue, OctValue octValue2) {
        int n2 = n * 2;
        int n3 = n2 + 1;
        this.setMin(n2, n3, octValue.add(octValue).negateIfNotInfinity());
        this.setMin(n3, n2, octValue2.add(octValue2));
    }

    protected void assumeVarRelationLeConstant(int n, boolean bl, int n2, boolean bl2, OctValue octValue) {
        n *= 2;
        n2 *= 2;
        if (!bl) {
            n |= 1;
        }
        if (bl2) {
            n2 |= 1;
        }
        this.setMin(n, n2, octValue);
    }

    protected void havocVar(int n) {
        int n2 = n * 2;
        int n3 = n2 + 1;
        int n4 = 0;
        while (n4 < this.mSize) {
            OctValue octValue = OctValue.INFINITY;
            this.mEntries[this.indexOf((int)n4, (int)n3)] = octValue;
            this.mEntries[this.indexOf((int)n4, (int)n2)] = octValue;
            ++n4;
        }
        this.set(n2, n2, OctValue.ZERO);
        this.set(n3, n3, OctValue.ZERO);
    }

    public double infinityPercentageInBlockLowerHalf() {
        if (this.mEntries.length == 0) {
            return Double.NaN;
        }
        int n = 0;
        OctValue[] octValueArray = this.mEntries;
        int n2 = this.mEntries.length;
        int n3 = 0;
        while (n3 < n2) {
            OctValue octValue = octValueArray[n3];
            if (octValue.isInfinity()) {
                ++n;
            }
            ++n3;
        }
        return (double)n / (double)this.mEntries.length;
    }

    public List<Term> getTerm(Script script, Term[] termArray) {
        ArrayList<Term> arrayList = new ArrayList<Term>(this.variables() * this.variables());
        int n = 0;
        while (n < 2 * this.variables()) {
            Term term = OctMatrix.selectVar(script, n, termArray);
            int n2 = 0;
            while (n2 < (n / 2 + 1) * 2) {
                OctValue octValue = this.get(n, n2);
                if (n2 == n) {
                    if (octValue.signum() < 0) {
                        return Collections.singletonList(script.term("false", new Term[0]));
                    }
                } else {
                    Term term2 = OctMatrix.selectVar(script, n2, termArray);
                    arrayList.add(OctMatrix.createBoundedDiffTerm(script, term2, term, octValue));
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static Term selectVar(Script script, int n, Term[] termArray) {
        Term term = termArray[n / 2];
        if (n % 2 == 1) {
            return script.term("-", new Term[]{term});
        }
        return term;
    }

    private static Term createBoundedDiffTerm(Script script, Term term, Term term2, OctValue octValue) {
        Term term3;
        if (octValue.isInfinity()) {
            return script.term("true", new Term[0]);
        }
        Term term4 = term;
        boolean bl = SmtSortUtils.isIntSort((Sort)term4.getSort());
        Term term5 = term2;
        boolean bl2 = SmtSortUtils.isIntSort((Sort)term5.getSort());
        if (bl && bl2) {
            term3 = SmtUtils.constructIntValue((Script)script, (BigInteger)octValue.getValue().setScale(0, RoundingMode.FLOOR).toBigIntegerExact());
        } else {
            term3 = script.decimal(octValue.getValue());
            if (bl) {
                term = script.term("to_real", new Term[]{term});
            } else if (bl2) {
                term2 = script.term("to_real", new Term[]{term2});
            }
        }
        return SmtUtils.leq((Script)script, (Term)SmtUtils.minus((Script)script, (Term[])new Term[]{term, term2}), (Term)term3);
    }

    public String toString() {
        return this.toStringHalf();
    }

    public String toStringFull() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.mSize) {
            String string = "";
            int n2 = 0;
            while (n2 < this.mSize) {
                stringBuilder.append(string);
                stringBuilder.append(this.get(n, n2));
                string = "\t";
                ++n2;
            }
            stringBuilder.append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    public String toStringHalf() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 2;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.mEntries.length) {
            stringBuilder.append(this.mEntries[n3]);
            if (n3 == n2) {
                stringBuilder.append("\n");
                n2 = ++n * n / 2 - 1;
            } else {
                stringBuilder.append("\t");
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public Set<Integer> variablesWithConstraints() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        while (n < this.mSize) {
            int n2 = n | 1;
            int n3 = 0;
            while (n3 <= n2) {
                boolean bl;
                OctValue octValue = this.get(n, n3);
                boolean bl2 = bl = !octValue.isInfinity() || n == n3 && octValue.signum() < 0;
                if (bl) {
                    hashSet.add(n / 2);
                    hashSet.add(n3 / 2);
                }
                ++n3;
            }
            ++n;
        }
        return hashSet;
    }

    public static interface WideningStepSupplier {
        public OctValue nextWideningStep(OctValue var1);
    }
}

