/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class ForkStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(ForkStatement.class);
    Expression[] threadID;
    String procedureName;
    Expression[] arguments;

    public ForkStatement(ILocation iLocation, Expression[] expressionArray, String string, Expression[] expressionArray2) {
        super(iLocation);
        this.threadID = expressionArray;
        this.procedureName = string;
        this.arguments = expressionArray2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ForkStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ForkStatement").append('[');
        if (this.threadID == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.threadID.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.threadID[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append(this.procedureName);
        stringBuffer.append(',');
        if (this.arguments == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.arguments[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Expression[] getThreadID() {
        return this.threadID;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.threadID != null) {
            list.addAll(Arrays.asList(this.threadID));
        }
        if (this.arguments != null) {
            list.addAll(Arrays.asList(this.arguments));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            Expression expression;
            int n;
            int n2;
            Expression[] expressionArray;
            if (this.threadID != null) {
                expressionArray = this.threadID;
                n2 = this.threadID.length;
                n = 0;
                while (n < n2) {
                    expression = expressionArray[n];
                    expression.accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.arguments != null) {
                expressionArray = this.arguments;
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    expression = expressionArray[n];
                    expression.accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<Expression[]> arrayList = new ArrayList<Expression[]>();
        if (this.threadID != null) {
            Expression[] expressionArray = this.threadID;
            n = this.threadID.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = expressionArray[n2];
                object = ((Expression)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((Expression[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.arguments != null) {
            object = this.arguments;
            int n3 = this.arguments.length;
            n = 0;
            while (n < n3) {
                Expression expression = object[n];
                Expression expression2 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression2 != expression;
                ((ArrayList)object2).add(expression2);
                ++n;
            }
        }
        if (bl) {
            return new ForkStatement(this.loc, arrayList.toArray(new Expression[0]), this.procedureName, ((ArrayList)object2).toArray(new Expression[0]));
        }
        return this;
    }
}

