/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.util;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class MonitoredProcess
implements IStorable,
AutoCloseable {
    private static final int WAIT_FOR_EXIT_COMMAND_MILLIS = 200;
    private static final int WAIT_BETWEEN_CHECKS_MILLIS = 50;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final AtomicInteger sInstanceCounter = new AtomicInteger();
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final String mCommand;
    private final String mExitCommand;
    private final PipedInputStream mStdInStreamPipe;
    private final PipedInputStream mStdErrStreamPipe;
    private final AtomicBoolean mTimeoutAttached;
    private Thread mProcessRunner;
    private int mID;
    private Process mProcess;
    private volatile int mReturnCode;
    private final CompletableFuture<Process> mProcessOnExit;
    private final AtomicBoolean mIsKillProcessCalled;

    private MonitoredProcess(Process process, String string, String string2, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger) {
        this.mServices = Objects.requireNonNull(iUltimateServiceProvider);
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mProcess = Objects.requireNonNull(process);
        this.mProcessOnExit = this.mProcess.onExit();
        this.mCommand = string;
        this.mExitCommand = string2;
        this.mReturnCode = -1;
        this.mProcessRunner = null;
        this.mStdInStreamPipe = new PipedInputStream(2048);
        this.mStdErrStreamPipe = new PipedInputStream(2048);
        this.mTimeoutAttached = new AtomicBoolean(false);
        this.mIsKillProcessCalled = new AtomicBoolean(false);
    }

    public static MonitoredProcess exec(String[] stringArray, String string3, String string4, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        File file;
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Cannot execute empty argument");
        }
        if (iUltimateServiceProvider == null) {
            throw new NullPointerException("services may not be null");
        }
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(MonitoredProcess.class);
        if (string3 == null) {
            stringArray[0] = MonitoredProcess.findExecutableBinary(stringArray[0], iLogger);
            file = null;
        } else {
            file = new File(string3);
        }
        String string5 = Arrays.stream(stringArray).reduce((string, string2) -> string + " " + string2).orElseThrow(AssertionError::new);
        MonitoredProcess monitoredProcess = new MonitoredProcess(Runtime.getRuntime().exec(stringArray, null, file), string5, string4, iUltimateServiceProvider, iLogger);
        monitoredProcess.start(string3, iUltimateServiceProvider.getStorage(), string5);
        return monitoredProcess;
    }

    private static String findExecutableBinary(String string, ILogger iLogger) {
        String string2;
        File file = new File(string);
        if (file.exists()) {
            string2 = file.getAbsolutePath();
        } else {
            file = new File(Paths.get(System.getProperty("user.dir"), string).toString());
            if (file.exists() && file.canExecute()) {
                string2 = file.getAbsolutePath();
            } else {
                File file2 = CoreUtil.findExecutableBinaryOnPath((String)string);
                if (file2 == null) {
                    iLogger.error((Object)("Could not determine absolute path of external process, hoping that OS will resolve " + string));
                    string2 = string;
                } else {
                    string2 = file2.getAbsolutePath();
                }
            }
        }
        iLogger.info((Object)("No working directory specified, using " + string2));
        return string2;
    }

    public static MonitoredProcess exec(String string, String string2, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        return MonitoredProcess.exec(string.split(" "), null, string2, iUltimateServiceProvider);
    }

    private void start(String string, IToolchainStorage iToolchainStorage, String string2) {
        this.mID = sInstanceCounter.incrementAndGet();
        String string3 = MonitoredProcess.getKey(this.mID, string2);
        IStorable iStorable = iToolchainStorage.putStorable(string3, (IStorable)this);
        if (iStorable != null) {
            this.mLogger.warn((Object)("Destroyed unexpected old storable " + string3));
            iStorable.destroy();
        }
        ProcessRunner processRunner = new ProcessRunner(this);
        this.mProcessRunner = new Thread((Runnable)processRunner, String.format("MonitoredProcess %s %s", this.mID, string2));
        this.mLogger.info("Starting monitored process %s with %s (exit command is %s, workingDir is %s)", new Object[]{this.mID, this.mCommand, this.mExitCommand, string});
        this.mProcessRunner.start();
        processRunner.mEndOfSetup.acquireUninterruptibly();
    }

    public MonitoredProcessState waitfor() throws InterruptedException {
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        this.mProcessRunner.join();
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        return new MonitoredProcessState(true, false, this.mReturnCode);
    }

    public MonitoredProcessState waitfor(long l) throws InterruptedException {
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        this.mProcessRunner.join(l);
        if (this.mProcessRunner.getState() == Thread.State.TERMINATED) {
            return new MonitoredProcessState(false, false, this.mReturnCode);
        }
        return new MonitoredProcessState(true, false, this.mReturnCode);
    }

    public MonitoredProcessState impatientWaitUntilTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("millis has to be non-negative but was " + l);
        }
        this.mLogger.info("%s Waiting %s ms for monitored process", new Object[]{this.getLogStringPrefix(), l});
        MonitoredProcessState monitoredProcessState = null;
        try {
            monitoredProcessState = this.waitfor(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (monitoredProcessState == null || monitoredProcessState.isRunning()) {
            this.mLogger.warn("%s Timeout reached", new Object[]{this.getLogStringPrefix()});
            this.forceShutdown();
            try {
                this.mProcessRunner.join(200L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            return new MonitoredProcessState(this.mProcessRunner.getState() != Thread.State.TERMINATED, true, this.mReturnCode);
        }
        return monitoredProcessState;
    }

    public MonitoredProcessState impatientWaitUntilTimeout(long l) {
        MonitoredProcessState monitoredProcessState;
        if (l < 0L) {
            throw new IllegalArgumentException("gracePeriod must be non-negative");
        }
        this.mLogger.info("%s Waiting until timeout for monitored process", new Object[]{this.getLogStringPrefix()});
        IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
        while (iProgressMonitorService != null && iProgressMonitorService.continueProcessing()) {
            try {
                monitoredProcessState = this.waitfor(50L);
                if (monitoredProcessState.isRunning()) continue;
                return monitoredProcessState;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.mLogger.warn("%s Timeout while monitored process is still running, waiting %s ms for graceful end", new Object[]{this.getLogStringPrefix(), l});
        try {
            monitoredProcessState = this.waitfor(l);
            if (!monitoredProcessState.isRunning()) {
                return monitoredProcessState;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.forceShutdown();
        return new MonitoredProcessState(this.mProcessRunner.getState() != Thread.State.TERMINATED, true, this.mReturnCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCountdownToTermination(long l) {
        MonitoredProcess monitoredProcess = this;
        synchronized (monitoredProcess) {
            if (this.mTimeoutAttached.getAndSet(true)) {
                throw new ConcurrentModificationException("You tried to attach a timeout twice for the monitored process" + this.mID);
            }
            if (l <= 0L) {
                throw new IllegalArgumentException("millis must be larger than zero");
            }
            new Thread(() -> {
                MonitoredProcessState monitoredProcessState = this.impatientWaitUntilTime(l);
            }, "CountdownTimeout watcher for " + this.mID).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminationAfterTimeout(long l) {
        MonitoredProcess monitoredProcess = this;
        synchronized (monitoredProcess) {
            if (this.mTimeoutAttached.getAndSet(true)) {
                throw new ConcurrentModificationException("You tried to attach a timeout twice for the monitored process" + this.mID);
            }
            if (l < 0L) {
                throw new IllegalArgumentException("millis must be non-negative");
            }
            new Thread(() -> {
                MonitoredProcessState monitoredProcessState = this.impatientWaitUntilTimeout(l);
            }, "TimeoutWatcher for " + this.mID).start();
        }
    }

    public void forceShutdown() {
        Closeable closeable;
        Object object;
        if (!this.isRunning()) {
            return;
        }
        if (this.mExitCommand != null) {
            object = this.mProcess.getOutputStream();
            closeable = new OutputStreamWriter((OutputStream)object, Charset.defaultCharset());
            try {
                closeable.write(this.mExitCommand);
                closeable.close();
            }
            catch (IOException iOException) {
                this.mLogger.error("%s Exception during sending of exit command %s: %s", new Object[]{this.getLogStringPrefix(), this.mExitCommand, iOException.getMessage()});
            }
            try {
                this.mLogger.debug("%s About to join with the monitor thread... ", new Object[]{this.getLogStringPrefix()});
                this.mProcessRunner.join(200L);
                this.mLogger.debug("%s Successfully joined", new Object[]{this.getLogStringPrefix()});
            }
            catch (InterruptedException interruptedException) {
                this.mLogger.debug("%s Interrupted during join", new Object[]{this.getLogStringPrefix()});
                Thread.currentThread().interrupt();
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.mLogger.warn("%s Forcibly destroying the process", new Object[]{this.getLogStringPrefix()});
        object = new ArrayList(5);
        try {
            object.add(this.mProcess.getInputStream());
            object.add(this.mProcess.getErrorStream());
            object.add(this.mStdInStreamPipe);
            object.add(this.mStdErrStreamPipe);
            this.killProcess();
        }
        catch (NullPointerException nullPointerException) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn("%s Process already dead, possible race condition", new Object[]{this.getLogStringPrefix()});
            }
        }
        catch (Exception exception) {
            this.mLogger.fatal("%s Something unexpected happened: %s%n%s", new Object[]{this.getLogStringPrefix(), exception, CoreUtil.getStackTrace((Throwable)exception)});
            throw exception;
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            closeable = (InputStream)iterator.next();
            this.close(closeable);
        }
        this.mLogger.debug("%s Forcibly destroyed the process", new Object[]{this.getLogStringPrefix()});
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            this.mLogger.warn("%s An error occured during closing: %s", new Object[]{this.getLogStringPrefix(), iOException.getMessage()});
        }
    }

    public OutputStream getOutputStream() {
        return this.mProcess.getOutputStream();
    }

    public InputStream getErrorStream() {
        return this.mStdErrStreamPipe;
    }

    public InputStream getInputStream() {
        return this.mStdInStreamPipe;
    }

    public void destroy() {
        this.forceShutdown();
    }

    protected void finalize() throws Throwable {
        this.forceShutdown();
        super.finalize();
    }

    @Override
    public void close() throws Exception {
        this.forceShutdown();
    }

    private static String getKey(int n, String string) {
        return n + " " + string;
    }

    public boolean isRunning() {
        return !this.mProcessOnExit.isDone();
    }

    private String getLogStringPrefix() {
        return "[MP " + this.mCommand + " (" + this.mID + ")]";
    }

    private void killProcess() {
        if (this.mIsKillProcessCalled.getAndSet(true)) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("%s Called by %s, but is already killed", new Object[]{this.getLogStringPrefix(), ReflectionUtil.getCallerSignature((int)3)});
            }
            return;
        }
        if (this.isRunning()) {
            try {
                this.mProcess.destroyForcibly();
                this.mProcessOnExit.get(200L, TimeUnit.MILLISECONDS);
                this.mReturnCode = this.mProcess.exitValue();
                this.mLogger.info("%s Forceful destruction successful, exit code %d", new Object[]{this.getLogStringPrefix(), this.mReturnCode});
            }
            catch (InterruptedException interruptedException) {
                this.mLogger.fatal("%s Interrupted while destroying process, abandoning it", new Object[]{this.getLogStringPrefix()});
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                this.mLogger.fatal("%s Encounted %s destroying process, abandoning process. Exception: %s", new Object[]{this.getLogStringPrefix(), executionException.getClass().getSimpleName(), executionException});
            }
            catch (TimeoutException timeoutException) {
                this.mLogger.fatal("%s Could not destroy process within %s ms, abandoning it", new Object[]{this.getLogStringPrefix(), 200});
            }
        } else {
            this.mLogger.info("%s Ended with exit code %s", new Object[]{this.getLogStringPrefix(), this.mProcess.exitValue()});
            this.mReturnCode = this.mProcess.exitValue();
        }
        this.mProcess = null;
        this.removeFromStorage();
    }

    private void removeFromStorage() {
        IStorable iStorable = this.mServices.getStorage().removeStorable(MonitoredProcess.getKey(this.mID, this.mCommand));
        if (iStorable != null && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)(this.getLogStringPrefix() + " Removed from storage"));
        }
    }

    public String toString() {
        if (this.mExitCommand != null) {
            return String.format("MP %s (%s) with exit command %s", this.mCommand, this.mID, this.mExitCommand);
        }
        return String.format("MP %s (%s) without exit command", this.mCommand, this.mID);
    }

    public static final class MonitoredProcessState {
        private final boolean mIsRunning;
        private final int mReturnCode;
        private final boolean mIsKilled;

        private MonitoredProcessState(boolean bl, boolean bl2, int n) {
            this.mIsRunning = bl;
            this.mReturnCode = n;
            this.mIsKilled = bl2;
        }

        public boolean isRunning() {
            return this.mIsRunning;
        }

        public boolean isKilled() {
            return this.mIsKilled;
        }

        public int getReturnCode() {
            return this.mReturnCode;
        }
    }

    private final class PipePump
    implements Runnable {
        private final OutputStream mOutputStream;
        private final InputStreamReader mStreamReader;
        private final Semaphore mEndOfPumps;
        private final Semaphore mEndOfSetup;
        private final String mPumpName;

        private PipePump(OutputStream outputStream, InputStreamReader inputStreamReader, Semaphore semaphore, Semaphore semaphore2, String string) {
            this.mOutputStream = outputStream;
            this.mStreamReader = inputStreamReader;
            this.mEndOfPumps = semaphore2;
            this.mPumpName = string;
            this.mEndOfSetup = semaphore;
        }

        @Override
        public void run() {
            block13: {
                this.mEndOfSetup.release();
                try {
                    try {
                        int n = -1;
                        while ((n = this.mStreamReader.read()) != -1) {
                            this.mOutputStream.write(n);
                            this.mOutputStream.flush();
                        }
                    }
                    catch (IOException iOException) {
                        if (MonitoredProcess.this.mLogger.isWarnEnabled()) {
                            MonitoredProcess.this.mLogger.warn((Object)(MonitoredProcess.this.getLogStringPrefix() + " The stream was forcibly closed: " + this.mPumpName));
                        }
                        try {
                            this.mOutputStream.flush();
                            this.mOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            MonitoredProcess.this.mLogger.fatal((Object)(MonitoredProcess.this.getLogStringPrefix() + " During closing of the streams " + this.mPumpName + ", an error occured"));
                        }
                        this.mEndOfPumps.release();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.mOutputStream.flush();
                        this.mOutputStream.close();
                    }
                    catch (IOException iOException) {
                        MonitoredProcess.this.mLogger.fatal((Object)(MonitoredProcess.this.getLogStringPrefix() + " During closing of the streams " + this.mPumpName + ", an error occured"));
                    }
                    this.mEndOfPumps.release();
                    throw throwable;
                }
                try {
                    this.mOutputStream.flush();
                    this.mOutputStream.close();
                }
                catch (IOException iOException) {
                    MonitoredProcess.this.mLogger.fatal((Object)(MonitoredProcess.this.getLogStringPrefix() + " During closing of the streams " + this.mPumpName + ", an error occured"));
                }
                this.mEndOfPumps.release();
            }
        }
    }

    private final class ProcessRunner
    implements Runnable {
        private static final int INITIAL_SEMAPHORE_COUNT = -2;
        private final Semaphore mEndOfSetup;
        private final MonitoredProcess mMonitoredProcess;

        private ProcessRunner(MonitoredProcess monitoredProcess2) {
            this.mMonitoredProcess = monitoredProcess2;
            this.mEndOfSetup = new Semaphore(-2);
        }

        @Override
        public void run() {
            Semaphore semaphore = new Semaphore(2);
            ILogger iLogger = this.mMonitoredProcess.mLogger;
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream(MonitoredProcess.this.mStdInStreamPipe);
                PipedOutputStream pipedOutputStream2 = new PipedOutputStream(MonitoredProcess.this.mStdErrStreamPipe);
                this.setUpStreamBuffer(this.mMonitoredProcess.mProcess.getInputStream(), pipedOutputStream, semaphore, "stdIn");
                this.setUpStreamBuffer(this.mMonitoredProcess.mProcess.getErrorStream(), pipedOutputStream2, semaphore, "stdErr");
            }
            catch (IOException iOException) {
                if (iLogger.isErrorEnabled()) {
                    iLogger.error((Object)(MonitoredProcess.this.getLogStringPrefix() + " Failed during stream data buffering. Terminating abnormally."), (Throwable)iOException);
                }
                MonitoredProcess.this.killProcess();
                this.mEndOfSetup.release(3);
                return;
            }
            try {
                try {
                    this.mEndOfSetup.release();
                    iLogger.debug((Object)(MonitoredProcess.this.getLogStringPrefix() + " Finished thread setup"));
                    this.mMonitoredProcess.mReturnCode = this.mMonitoredProcess.mProcess.waitFor();
                    iLogger.debug((Object)(MonitoredProcess.this.getLogStringPrefix() + " Finished waiting for process"));
                    if (!semaphore.tryAcquire(2, 200L, TimeUnit.MILLISECONDS)) {
                        iLogger.warn((Object)(MonitoredProcess.this.getLogStringPrefix() + " Abandoning pump threads because process wont die"));
                    } else if (iLogger.isDebugEnabled()) {
                        iLogger.debug((Object)(MonitoredProcess.this.getLogStringPrefix() + " Finished waiting for pump threads"));
                        this.logUnreadPipeContent();
                        iLogger.debug((Object)(MonitoredProcess.this.getLogStringPrefix() + " Finished dumping unread pipe content"));
                    }
                }
                catch (InterruptedException interruptedException) {
                    iLogger.error((Object)(MonitoredProcess.this.getLogStringPrefix() + " Pump interrupted. Terminating abnormally."), (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                    MonitoredProcess.this.killProcess();
                    iLogger.debug((Object)(MonitoredProcess.this.getLogStringPrefix() + " Exiting monitor thread"));
                }
            }
            finally {
                MonitoredProcess.this.killProcess();
                iLogger.debug((Object)(MonitoredProcess.this.getLogStringPrefix() + " Exiting monitor thread"));
            }
        }

        private void logUnreadPipeContent() {
            String string = CoreUtil.convertStreamToString((InputStream)MonitoredProcess.this.getInputStream());
            String string2 = CoreUtil.convertStreamToString((InputStream)MonitoredProcess.this.getErrorStream());
            if (string.isEmpty() && string2.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MonitoredProcess.this.getLogStringPrefix()).append(CoreUtil.getPlatformLineSeparator());
            if (!string.isEmpty()) {
                stringBuilder.append("Unread content of stdout:").append(CoreUtil.getPlatformLineSeparator()).append(string);
            }
            if (!string2.isEmpty()) {
                if (!string.isEmpty()) {
                    stringBuilder.append(CoreUtil.getPlatformLineSeparator());
                }
                stringBuilder.append("Unread content of stderr:").append(CoreUtil.getPlatformLineSeparator()).append(string2);
            }
            MonitoredProcess.this.mLogger.debug((Object)stringBuilder);
        }

        private void setUpStreamBuffer(InputStream inputStream, OutputStream outputStream, Semaphore semaphore, String string) {
            semaphore.acquireUninterruptibly();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.defaultCharset());
            String string2 = "MonitoredProcess " + MonitoredProcess.this.mID + " StreamBuffer " + string;
            new Thread((Runnable)new PipePump(outputStream, inputStreamReader, this.mEndOfSetup, semaphore, string), string2).start();
        }
    }
}

