/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.rabin.Buchi2RabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;

public class ToRabin<LETTER, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final IRabinAutomaton<LETTER, STATE> mConversionAutomaton;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mBuchiAutomaton;

    public ToRabin(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        super(automataLibraryServices);
        this.mConversionAutomaton = new Buchi2RabinAutomaton<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider);
        this.mBuchiAutomaton = iNwaOutgoingLetterAndTransitionProvider;
    }

    @Override
    public IRabinAutomaton<LETTER, STATE> getResult() {
        return this.mConversionAutomaton;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataOperationCanceledException {
        return new IsEmpty(this.mServices, this.mConversionAutomaton).getResult() == new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mBuchiAutomaton).getResult();
    }
}

