/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.util;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicatedParallelEdgeIndexFunction<V, E>
implements EdgeIndexFunction<V, E> {
    protected Map<E, Integer> edge_index = new HashMap<E, Integer>();
    protected Predicate<E> predicate;

    private PredicatedParallelEdgeIndexFunction() {
    }

    public static <V, E> PredicatedParallelEdgeIndexFunction<V, E> getInstance() {
        return new PredicatedParallelEdgeIndexFunction<V, E>();
    }

    @Override
    public int getIndex(Graph<V, E> graph, E e) {
        if (this.predicate.evaluate(e)) {
            return 0;
        }
        Integer index = this.edge_index.get(e);
        if (index == null) {
            V v;
            Pair<V> endpoints = graph.getEndpoints(e);
            V u = endpoints.getFirst();
            index = u.equals(v = endpoints.getSecond()) ? Integer.valueOf(this.getIndex(graph, e, v)) : Integer.valueOf(this.getIndex(graph, e, u, v));
        }
        return index;
    }

    protected int getIndex(Graph<V, E> graph, E e, V v, V u) {
        HashSet commonEdgeSet = new HashSet(graph.getIncidentEdges(u));
        commonEdgeSet.retainAll(graph.getIncidentEdges(v));
        Iterator iterator = commonEdgeSet.iterator();
        while (iterator.hasNext()) {
            V second;
            Object edge = iterator.next();
            Pair<V> ep = graph.getEndpoints(edge);
            V first = ep.getFirst();
            if (first.equals(second = ep.getSecond())) {
                iterator.remove();
            }
            if (first.equals(v)) continue;
            iterator.remove();
        }
        int count = 0;
        for (Object other : commonEdgeSet) {
            if (e.equals(other)) continue;
            this.edge_index.put(other, count);
            ++count;
        }
        this.edge_index.put(e, count);
        return count;
    }

    protected int getIndex(Graph<V, E> graph, E e, V v) {
        HashSet commonEdgeSet = new HashSet();
        for (Object another : graph.getIncidentEdges(v)) {
            V u = graph.getOpposite(v, another);
            if (!u.equals(v)) continue;
            commonEdgeSet.add(another);
        }
        int count = 0;
        for (Object other : commonEdgeSet) {
            if (e.equals(other)) continue;
            this.edge_index.put(other, count);
            ++count;
        }
        this.edge_index.put(e, count);
        return count;
    }

    public Predicate<E> getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate<E> predicate) {
        this.predicate = predicate;
    }

    @Override
    public void reset(Graph<V, E> graph, E e) {
        Pair<V> endpoints = graph.getEndpoints(e);
        this.getIndex(graph, e, endpoints.getFirst());
        this.getIndex(graph, e, endpoints.getFirst(), endpoints.getSecond());
    }

    @Override
    public void reset() {
        this.edge_index.clear();
    }
}

