/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantconsolidation;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.DeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantconsolidation.PathProgramAutomatonConstructor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantconsolidation.PredicateFactoryForInterpolantConsolidation;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class InterpolantConsolidation<TC extends IInterpolantGenerator<LETTER>, LETTER extends IIcfgTransition<?>> {
    private static final boolean PRINT_DEBUG_INFORMATION = false;
    private static final boolean PRINT_DIFFERENCE_AUTOMATA = false;
    private static final boolean USE_CONSOLIDATION_IN_NON_EMPTY_CASE = false;
    private final TC mIpTc;
    private final NestedWord<LETTER> mTrace;
    private final IUltimateServiceProvider mServices;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;
    private final ILogger mLogger;
    private final InterpolantConsolidationBenchmarkGenerator mInterpolantConsolidationBenchmarkGenerator;
    private final boolean mInterpolantsConsolidationSuccessful;
    private final boolean mIsConsolidatedInterpolantsPerfectSequence;
    private IPredicate[] mConsolidatedInterpolants;

    public InterpolantConsolidation(CfgSmtToolkit cfgSmtToolkit, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, PredicateFactory predicateFactory, TC TC) throws AutomataOperationCanceledException {
        this.mIpTc = TC;
        this.mTrace = TraceCheckUtils.toNestedWord((List)this.mIpTc.getTrace());
        this.mCsToolkit = cfgSmtToolkit;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPredicateFactory = predicateFactory;
        this.mConsolidatedInterpolants = new IPredicate[this.mTrace.length() - 1];
        this.mInterpolantConsolidationBenchmarkGenerator = new InterpolantConsolidationBenchmarkGenerator();
        InterpolantComputationStatus interpolantComputationStatus = this.mIpTc.getInterpolantComputationStatus();
        this.mInterpolantsConsolidationSuccessful = interpolantComputationStatus.wasComputationSuccessful() ? this.computeInterpolants() : false;
        this.mIsConsolidatedInterpolantsPerfectSequence = this.computeIsConsolidatedInterpolantsPerfectSequence(this.mConsolidatedInterpolants);
    }

    private final boolean computeInterpolants() throws AutomataOperationCanceledException {
        Object object;
        Object object2;
        this.mInterpolantConsolidationBenchmarkGenerator.start("TimeOfConsolidation");
        PathProgramAutomatonConstructor<LETTER> pathProgramAutomatonConstructor = new PathProgramAutomatonConstructor<LETTER>();
        INestedWordAutomaton iNestedWordAutomaton = pathProgramAutomatonConstructor.constructAutomatonFromGivenPath(this.mTrace, this.mServices, this.mCsToolkit, this.mPredicateFactory, false);
        NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton = this.constructInterpolantAutomaton(this.mTrace, this.mCsToolkit, this.mPredicateFactory, false, this.mServices, (IInterpolantGenerator<LETTER>)this.mIpTc);
        IHoareTripleChecker iHoareTripleChecker = HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.mServices, (HoareTripleCheckerUtils.HoareTripleChecks)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, (CfgSmtToolkit)this.mCsToolkit, (IPredicateUnifier)this.mIpTc.getPredicateUnifier());
        DeterministicInterpolantAutomaton<LETTER> deterministicInterpolantAutomaton = new DeterministicInterpolantAutomaton<LETTER>(this.mServices, this.mCsToolkit, iHoareTripleChecker, nestedWordAutomaton, this.mIpTc.getPredicateUnifier(), false, false);
        PredicateFactoryForInterpolantConsolidation predicateFactoryForInterpolantConsolidation = new PredicateFactoryForInterpolantConsolidation(this.mServices, this.mCsToolkit, this.mPredicateFactory, false);
        PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata = new PredicateFactoryForInterpolantAutomata(this.mCsToolkit.getManagedScript(), this.mPredicateFactory, false);
        PowersetDeterminizer powersetDeterminizer = new PowersetDeterminizer(deterministicInterpolantAutomaton, true, (IDeterminizeStateFactory)predicateFactoryForInterpolantAutomata);
        try {
            object2 = new Difference(new AutomataLibraryServices(this.mServices), (ISinkStateFactory)predicateFactoryForInterpolantConsolidation, iNestedWordAutomaton, deterministicInterpolantAutomaton, (IStateDeterminizer)powersetDeterminizer, false);
            iHoareTripleChecker.releaseLock();
            object = new IsEmpty(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)object2.getResult());
            if (!object.getResult().booleanValue()) {
                TraceCheckSpWp traceCheckSpWp;
                boolean bl;
                this.mConsolidatedInterpolants = this.mIpTc instanceof TraceCheckSpWp ? ((bl = (traceCheckSpWp = (TraceCheckSpWp)this.mIpTc).isForwardSequencePerfect()) ? traceCheckSpWp.getForwardPredicates().toArray(new IPredicate[0]) : traceCheckSpWp.getBackwardPredicates().toArray(new IPredicate[0])) : this.mIpTc.getInterpolants();
                this.mInterpolantConsolidationBenchmarkGenerator.stop("TimeOfConsolidation");
                return false;
            }
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)"Timeout while computing interpolants");
            }
            throw automataOperationCanceledException;
        }
        catch (AutomataLibraryException automataLibraryException) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"Error while computing interpolants");
            }
            throw new AssertionError((Object)automataLibraryException);
        }
        object2 = pathProgramAutomatonConstructor.getPositionsToStates();
        object = predicateFactoryForInterpolantConsolidation.getLocationsToSetOfPredicates();
        Set set = nestedWordAutomaton.getStates();
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        this.mInterpolantConsolidationBenchmarkGenerator.incrementDiffAutomatonEmpty_Counter();
        this.mConsolidatedInterpolants = this.computeConsolidatedInterpolants((List<IPredicate>)object2, (Map<IPredicate, Set<IPredicate>>)object, set, hashSet, iHoareTripleChecker);
        assert (TraceCheckUtils.checkInterpolantsInductivityBackward(Arrays.asList(this.mConsolidatedInterpolants), this.mTrace, (IPredicate)this.mIpTc.getPrecondition(), (IPredicate)this.mIpTc.getPostcondition(), (Map)this.mIpTc.getPendingContexts(), (String)"CP", (CfgSmtToolkit)this.mCsToolkit, (ILogger)this.mLogger, (ManagedScript)this.mCsToolkit.getManagedScript())) : "invalid Hoare triple in consolidated interpolants";
        int n = (Integer)this.mInterpolantConsolidationBenchmarkGenerator.getValue("DisjunctionsGreaterOneCounter");
        return n > 0;
    }

    private Set<IPredicate> getDiffAutomatonGoodStates(INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, IPredicate iPredicate, Map<IPredicate, Integer> map) {
        Set<IPredicate> set;
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        LinkedList<IPredicate> linkedList = new LinkedList<IPredicate>();
        LinkedList<HashSet<IPredicate>> linkedList2 = new LinkedList<HashSet<IPredicate>>();
        linkedList.add(iPredicate);
        int n = 0;
        HashMap<Integer, HashSet<IPredicate>> hashMap = new HashMap<Integer, HashSet<IPredicate>>();
        while (!linkedList.isEmpty()) {
            Object object22;
            IPredicate iPredicate2 = (IPredicate)linkedList.removeFirst();
            if (!hashSet.contains(iPredicate2)) {
                hashSet.add(iPredicate2);
            } else {
                int n2 = map.get(iPredicate2);
                object22 = (IPredicate)hashMap.get(n2);
                if (object22 != null) {
                    object22.remove(iPredicate2);
                }
            }
            set = this.getPredecessorsOfState(iNestedWordAutomaton, iPredicate2);
            for (Object object22 : set) {
                if (iPredicate2.equals(object22)) continue;
                if (!hashSet.contains(object22)) {
                    linkedList2.addLast((HashSet<IPredicate>)object22);
                    continue;
                }
                Set<IPredicate> set2 = this.getPredecessorsOfState(iNestedWordAutomaton, (IPredicate)object22);
                if (hashSet.containsAll(set2)) continue;
                linkedList2.addLast((HashSet<IPredicate>)object22);
            }
            object22 = (Set)hashMap.get(n);
            if (object22 == null) {
                object22 = new IPredicate();
                object22.add(iPredicate2);
                hashMap.put(n, (HashSet<IPredicate>)object22);
            } else {
                object22.add(iPredicate2);
            }
            map.put(iPredicate2, n);
            if (!linkedList.isEmpty()) continue;
            for (IPredicate iPredicate3 : linkedList2) {
                linkedList.addLast(iPredicate3);
            }
            linkedList2.clear();
            ++n;
        }
        int n3 = 0;
        while (n3 < n) {
            set = (Set<IPredicate>)hashMap.get(n3);
            if (set != null && set.size() == 1) {
                hashSet.removeAll(set);
            }
            ++n3;
        }
        return hashSet;
    }

    private Set<IPredicate> getPredecessorsOfState(INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, IPredicate iPredicate) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors((Object)iPredicate)) {
            hashSet.add((IPredicate)incomingInternalTransition.getPred());
        }
        for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.callPredecessors((Object)iPredicate)) {
            hashSet.add((IPredicate)incomingInternalTransition.getPred());
        }
        for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.returnPredecessors((Object)iPredicate)) {
            hashSet.add((IPredicate)incomingInternalTransition.getLinPred());
        }
        return hashSet;
    }

    private IPredicate[] computeConsolidatedInterpolants(List<IPredicate> list, Map<IPredicate, Set<IPredicate>> map, Set<IPredicate> set, Set<IPredicate> set2, IHoareTripleChecker iHoareTripleChecker) {
        HashMap<IPredicate, IPredicate> hashMap = new HashMap<IPredicate, IPredicate>();
        IPredicate[] iPredicateArray = new IPredicate[this.mTrace.length() - 1];
        int n = 0;
        int n2 = 0;
        int n3 = this.mTrace.length() - 1;
        int n4 = 0;
        while (n4 < iPredicateArray.length) {
            IPredicate iPredicate = list.get(n4 + 1);
            if (!hashMap.containsKey(iPredicate)) {
                Set<IPredicate> set3 = map.get(iPredicate);
                assert (set3 != null) : "The set of predicates for the current location is null!";
                IPredicate[] iPredicateArray2 = set3.toArray(new IPredicate[set3.size()]);
                if (set3.size() > 1) {
                    ++n;
                    iPredicateArray[n4] = this.mIpTc.getPredicateUnifier().getOrConstructPredicateForDisjunction(set3);
                    if (!set.contains(iPredicateArray[n4])) {
                        ++n2;
                    }
                    hashMap.put(iPredicate, iPredicateArray[n4]);
                } else {
                    iPredicateArray[n4] = iPredicateArray2[0];
                }
                if (set.contains(iPredicateArray[n4])) {
                    --n3;
                }
                set2.add(iPredicateArray[n4]);
            } else {
                iPredicateArray[n4] = (IPredicate)hashMap.get(iPredicate);
            }
            ++n4;
        }
        n4 = set.size() - set2.size();
        this.mInterpolantConsolidationBenchmarkGenerator.setInterpolantConsolidationData(n, n2, n3, n4, iHoareTripleChecker.getStatistics());
        this.mInterpolantConsolidationBenchmarkGenerator.stop("TimeOfConsolidation");
        return iPredicateArray;
    }

    private void printArray(IPredicate[] iPredicateArray) {
        int n = 0;
        while (n < iPredicateArray.length) {
            this.mLogger.debug((Object)(Integer.toString(n) + ". " + iPredicateArray[n].toString()));
            ++n;
        }
    }

    public List<IPredicate> getInterpolantsOfType_I() {
        if (this.mIpTc instanceof TraceCheckSpWp) {
            TraceCheckSpWp traceCheckSpWp = (TraceCheckSpWp)this.mIpTc;
            if (traceCheckSpWp.wasForwardPredicateComputationRequested()) {
                return traceCheckSpWp.getForwardPredicates();
            }
            return Arrays.asList(traceCheckSpWp.getInterpolants());
        }
        return Arrays.asList(this.mIpTc.getInterpolants());
    }

    public List<IPredicate> getInterpolantsOfType_II() {
        if (this.mIpTc instanceof TraceCheckSpWp) {
            TraceCheckSpWp traceCheckSpWp = (TraceCheckSpWp)this.mIpTc;
            if (traceCheckSpWp.wasBackwardSequenceConstructed()) {
                return traceCheckSpWp.getBackwardPredicates();
            }
            return Arrays.asList(traceCheckSpWp.getInterpolants());
        }
        return Arrays.asList(this.mIpTc.getInterpolants());
    }

    public boolean consolidationSuccessful() {
        return this.mInterpolantsConsolidationSuccessful;
    }

    private NestedWordAutomaton<LETTER, IPredicate> constructInterpolantAutomaton(NestedWord<LETTER> nestedWord, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, boolean bl, IUltimateServiceProvider iUltimateServiceProvider, IInterpolantGenerator<LETTER> iInterpolantGenerator) {
        TraceCheckSpWp traceCheckSpWp;
        HashSet<IIcfgTransition> hashSet = new HashSet<IIcfgTransition>();
        HashSet<IIcfgTransition> hashSet2 = new HashSet<IIcfgTransition>();
        HashSet<IIcfgTransition> hashSet3 = new HashSet<IIcfgTransition>();
        int n = 0;
        while (n < nestedWord.length()) {
            if (nestedWord.isInternalPosition(n)) {
                hashSet.add((IIcfgTransition)nestedWord.getSymbol(n));
            } else if (nestedWord.isCallPosition(n)) {
                hashSet2.add((IIcfgTransition)nestedWord.getSymbol(n));
            } else if (nestedWord.isReturnPosition(n)) {
                hashSet3.add((IIcfgTransition)nestedWord.getSymbol(n));
            } else {
                throw new UnsupportedOperationException("Symbol at position " + n + " is neither internal, call, nor return symbol!");
            }
            ++n;
        }
        PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata = new PredicateFactoryForInterpolantAutomata(cfgSmtToolkit.getManagedScript(), predicateFactory, bl);
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), new VpAlphabet(hashSet, hashSet2, hashSet3), (IEmptyStackStateFactory)predicateFactoryForInterpolantAutomata);
        nestedWordAutomaton.addState(true, false, (Object)iInterpolantGenerator.getPrecondition());
        nestedWordAutomaton.addState(false, true, (Object)iInterpolantGenerator.getPostcondition());
        boolean bl2 = false;
        if (iInterpolantGenerator instanceof TraceCheckSpWp && (traceCheckSpWp = (TraceCheckSpWp)iInterpolantGenerator).wasForwardPredicateComputationRequested() && traceCheckSpWp.wasBackwardSequenceConstructed()) {
            bl2 = true;
            this.addStatesAndCorrespondingTransitionsFromGivenInterpolants(nestedWordAutomaton, iInterpolantGenerator.getPrecondition(), iInterpolantGenerator.getPostcondition(), traceCheckSpWp.getForwardPredicates(), nestedWord);
            this.addStatesAndCorrespondingTransitionsFromGivenInterpolants(nestedWordAutomaton, iInterpolantGenerator.getPrecondition(), iInterpolantGenerator.getPostcondition(), traceCheckSpWp.getBackwardPredicates(), nestedWord);
        }
        if (!bl2) {
            this.addStatesAndCorrespondingTransitionsFromGivenInterpolants(nestedWordAutomaton, iInterpolantGenerator.getPrecondition(), iInterpolantGenerator.getPostcondition(), Arrays.asList(iInterpolantGenerator.getInterpolants()), nestedWord);
        }
        return nestedWordAutomaton;
    }

    public IPredicate getInterpolantAtPosition(int n, IPredicate iPredicate, IPredicate iPredicate2, List<IPredicate> list) {
        if (n < 0) {
            throw new AssertionError((Object)"index beyond precondition");
        }
        if (n == 0) {
            return iPredicate;
        }
        if (n <= list.size()) {
            return list.get(n - 1);
        }
        if (n == list.size() + 1) {
            return iPredicate2;
        }
        throw new AssertionError((Object)"index beyond postcondition");
    }

    private void addStatesAndCorrespondingTransitionsFromGivenInterpolants(NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, IPredicate iPredicate, IPredicate iPredicate2, List<IPredicate> list, NestedWord<LETTER> nestedWord) {
        int n = 0;
        while (n < nestedWord.length()) {
            IPredicate iPredicate3 = this.getInterpolantAtPosition(n, iPredicate, iPredicate2, list);
            IPredicate iPredicate4 = this.getInterpolantAtPosition(n + 1, iPredicate, iPredicate2, list);
            assert (nestedWordAutomaton.getStates().contains(iPredicate3));
            if (!nestedWordAutomaton.getStates().contains(iPredicate4)) {
                nestedWordAutomaton.addState(false, false, (Object)iPredicate4);
            }
            if (nestedWord.isCallPosition(n)) {
                nestedWordAutomaton.addCallTransition((Object)iPredicate3, (Object)((IIcfgTransition)nestedWord.getSymbol(n)), (Object)iPredicate4);
            } else if (nestedWord.isReturnPosition(n)) {
                assert (!nestedWord.isPendingReturn(n));
                int n2 = nestedWord.getCallPosition(n);
                IPredicate iPredicate5 = this.getInterpolantAtPosition(n2, iPredicate, iPredicate2, list);
                nestedWordAutomaton.addReturnTransition((Object)iPredicate3, (Object)iPredicate5, (Object)((IIcfgTransition)nestedWord.getSymbol(n)), (Object)iPredicate4);
            } else {
                assert (nestedWord.isInternalPosition(n));
                nestedWordAutomaton.addInternalTransition((Object)iPredicate3, (Object)((IIcfgTransition)nestedWord.getSymbol(n)), (Object)iPredicate4);
            }
            ++n;
        }
    }

    protected InterpolantConsolidationBenchmarkGenerator getInterpolantConsolidationBenchmarks() {
        return this.mInterpolantConsolidationBenchmarkGenerator;
    }

    protected final TC getInterpolantGenerator() {
        return this.mIpTc;
    }

    protected final IPredicate[] getConsolidatedInterpolants() {
        return this.mConsolidatedInterpolants;
    }

    protected final boolean isConsolidatedInterpolantsPerfectSequence() {
        return this.mIsConsolidatedInterpolantsPerfectSequence;
    }

    private boolean computeIsConsolidatedInterpolantsPerfectSequence(IPredicate[] iPredicateArray) {
        NestedWord nestedWord = TraceCheckUtils.toNestedWord((List)this.getInterpolantGenerator().getTrace());
        List list = TraceCheckUtils.getSequenceOfProgramPoints((Word)nestedWord);
        TracePredicates tracePredicates = new TracePredicates(this.getInterpolantGenerator().getPrecondition(), this.getInterpolantGenerator().getPostcondition(), Arrays.asList(iPredicateArray));
        CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation = TraceCheckUtils.computeCoverageCapability((IUltimateServiceProvider)this.mServices, (TracePredicates)tracePredicates, (List)list, (ILogger)this.mLogger, (IPredicateUnifier)this.getInterpolantGenerator().getPredicateUnifier());
        return backwardCoveringInformation.getPotentialBackwardCoverings() == backwardCoveringInformation.getSuccessfullBackwardCoverings();
    }

    public static class InterpolantConsolidationBenchmarkGenerator
    extends StatisticsGeneratorWithStopwatches
    implements IStatisticsDataProvider {
        private int mDisjunctionsGreaterOneCounter = 0;
        private int mDifferenceBeforeAfter = 0;
        private int mNewlyCreatedInterpolants = 0;
        private int mInterpolantsDropped = 0;
        private final InCaReCounter mNumOfHoareTripleChecks = new InCaReCounter();
        private int mDiffAutomatonEmpty_Counter = 0;

        public void setInterpolantConsolidationData(int n, int n2, int n3, int n4, IStatisticsDataProvider iStatisticsDataProvider) {
            this.mDisjunctionsGreaterOneCounter = n;
            this.mDifferenceBeforeAfter = n4;
            this.mNumOfHoareTripleChecks.add((InCaReCounter)iStatisticsDataProvider.getValue(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverSat.name()));
            this.mNumOfHoareTripleChecks.add((InCaReCounter)iStatisticsDataProvider.getValue(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverUnsat.name()));
            this.mNumOfHoareTripleChecks.add((InCaReCounter)iStatisticsDataProvider.getValue(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.SolverUnknown.name()));
            this.mNewlyCreatedInterpolants = n2;
            this.mInterpolantsDropped = n3;
        }

        public void incrementDiffAutomatonEmpty_Counter() {
            ++this.mDiffAutomatonEmpty_Counter;
        }

        public Collection<String> getKeys() {
            return InterpolantConsolidationBenchmarkType.getInstance().getKeys();
        }

        public Object getValue(String string) {
            switch (string) {
                case "NewlyCreatedInterpolants": {
                    return this.mNewlyCreatedInterpolants;
                }
                case "InterpolantsDropped": {
                    return this.mInterpolantsDropped;
                }
                case "DisjunctionsGreaterOneCounter": {
                    return this.mDisjunctionsGreaterOneCounter;
                }
                case "DifferenceOfInterpolantsBeforeAfter": {
                    return this.mDifferenceBeforeAfter;
                }
                case "NumOfHoareTripleChecks": {
                    return this.mNumOfHoareTripleChecks;
                }
                case "TimeOfConsolidation": {
                    try {
                        return this.getElapsedTime(string);
                    }
                    catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                        throw new AssertionError((Object)("clock still running: " + string));
                    }
                }
                case "DifferenceAutomatonEmptyCounter": {
                    return this.mDiffAutomatonEmpty_Counter;
                }
            }
            throw new AssertionError((Object)"unknown data");
        }

        public IStatisticsType getBenchmarkType() {
            return InterpolantConsolidationBenchmarkType.getInstance();
        }

        public String[] getStopwatches() {
            return new String[]{"TimeOfConsolidation"};
        }
    }

    public static class InterpolantConsolidationBenchmarkType
    implements IStatisticsType {
        private static InterpolantConsolidationBenchmarkType s_Instance = new InterpolantConsolidationBenchmarkType();
        protected static final String s_DifferenceAutomatonEmptyCounter = "DifferenceAutomatonEmptyCounter";
        protected static final String s_DisjunctionsGreaterOneCounter = "DisjunctionsGreaterOneCounter";
        protected static final String s_NewlyCreatedInterpolants = "NewlyCreatedInterpolants";
        protected static final String s_InterpolantsDropped = "InterpolantsDropped";
        protected static final String s_DifferenceBeforeAfter = "DifferenceOfInterpolantsBeforeAfter";
        protected static final String s_NumberOfHoareTripleChecks = "NumOfHoareTripleChecks";
        protected static final String s_TimeOfConsolidation = "TimeOfConsolidation";

        public static InterpolantConsolidationBenchmarkType getInstance() {
            return s_Instance;
        }

        public Collection<String> getKeys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(s_DisjunctionsGreaterOneCounter);
            arrayList.add(s_DifferenceBeforeAfter);
            arrayList.add(s_NumberOfHoareTripleChecks);
            arrayList.add(s_TimeOfConsolidation);
            arrayList.add(s_NewlyCreatedInterpolants);
            arrayList.add(s_InterpolantsDropped);
            arrayList.add(s_DifferenceAutomatonEmptyCounter);
            return arrayList;
        }

        public Object aggregate(String string, Object object, Object object2) {
            switch (string) {
                case "DifferenceAutomatonEmptyCounter": 
                case "NewlyCreatedInterpolants": 
                case "DifferenceOfInterpolantsBeforeAfter": 
                case "DisjunctionsGreaterOneCounter": 
                case "InterpolantsDropped": {
                    int n = (Integer)object + (Integer)object2;
                    return n;
                }
                case "TimeOfConsolidation": {
                    long l = (Long)object + (Long)object2;
                    return l;
                }
                case "NumOfHoareTripleChecks": {
                    InCaReCounter inCaReCounter = (InCaReCounter)object;
                    inCaReCounter.add((InCaReCounter)object2);
                    return inCaReCounter;
                }
            }
            throw new AssertionError((Object)"unknown key");
        }

        public String prettyprintBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\t").append(s_DifferenceAutomatonEmptyCounter).append(": ");
            stringBuilder.append((Integer)iStatisticsDataProvider.getValue(s_DifferenceAutomatonEmptyCounter));
            stringBuilder.append("\t").append(s_DisjunctionsGreaterOneCounter).append(": ");
            stringBuilder.append((Integer)iStatisticsDataProvider.getValue(s_DisjunctionsGreaterOneCounter));
            stringBuilder.append("\t").append(s_NumberOfHoareTripleChecks).append(": ");
            stringBuilder.append(iStatisticsDataProvider.getValue(s_NumberOfHoareTripleChecks));
            stringBuilder.append("\t").append(s_InterpolantsDropped).append(": ");
            stringBuilder.append((Integer)iStatisticsDataProvider.getValue(s_InterpolantsDropped));
            stringBuilder.append("\t").append(s_NewlyCreatedInterpolants).append(": ");
            stringBuilder.append((Integer)iStatisticsDataProvider.getValue(s_NewlyCreatedInterpolants));
            stringBuilder.append("\t").append(s_DifferenceBeforeAfter).append(": ");
            stringBuilder.append((Integer)iStatisticsDataProvider.getValue(s_DifferenceBeforeAfter));
            stringBuilder.append("\t").append(s_TimeOfConsolidation).append(": ");
            Long l = (Long)iStatisticsDataProvider.getValue(s_TimeOfConsolidation);
            stringBuilder.append(CoreUtil.humanReadableTime((long)l, (TimeUnit)TimeUnit.NANOSECONDS, (int)3));
            return stringBuilder.toString();
        }
    }
}

